/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.backend.icode;

import java.io.PrintStream;
import scala.$colon$colon;
import scala.Array$;
import scala.Console$;
import scala.Function1;
import scala.Iterator;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Seq;
import scala.Some;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.compat.StringBuilder;
import scala.runtime.BoxedIntArray;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesUtility;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.tools.nsc.backend.icode.BasicBlocks$BasicBlock$;
import scala.tools.nsc.backend.icode.ICodes;
import scala.tools.nsc.backend.icode.Members;
import scala.tools.nsc.backend.icode.Opcodes;
import scala.tools.nsc.backend.icode.analysis.ProgramPoint;
import scala.tools.nsc.util.NoPosition$;
import scala.tools.nsc.util.Position;

public interface BasicBlocks
extends ScalaObject {

    public class BasicBlock
    implements ProgramPoint,
    ScalaObject {
        public /* synthetic */ ICodes $outer;
        private boolean touched;
        private Opcodes.Instruction[] instrs;
        private boolean closed;
        private Opcodes.Instruction _lastInstruction;
        private List instructionList;
        private Set varsInScope;
        private boolean exceptionHandlerHeader;
        private boolean loopHeader;
        private List preds;
        private boolean ignore;
        private int label;
        private Members.IMethod method;

        public BasicBlock(ICodes $outer, int theLabel, Members.IMethod method) {
            this.method = method;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.label = theLabel;
            this.ignore = false;
            this.preds = null;
            this.loopHeader = false;
            this.exceptionHandlerHeader = false;
            this.varsInScope = new LinkedHashSet();
            this.instructionList = Nil$.MODULE$;
            this._lastInstruction = null;
            this.closed = false;
            this.touched = false;
        }

        private final List subst$0(List l, Map map) {
            List list;
            block4: {
                Option option;
                block6: {
                    List list2;
                    block3: {
                        Opcodes.Instruction x;
                        List xs;
                        block5: {
                            Opcodes.Instruction instruction;
                            Opcodes.Instruction newInstr;
                            List list3;
                            block2: {
                                list = l;
                                if (Nil$.MODULE$ != list) break block2;
                                list2 = Nil$.MODULE$;
                                break block3;
                            }
                            if (!(list instanceof $colon$colon)) break block4;
                            $colon$colon $colon$colon = ($colon$colon)list;
                            Opcodes.Instruction instruction2 = (Opcodes.Instruction)$colon$colon.hd();
                            xs = list3 = $colon$colon.tl$0();
                            x = instruction2;
                            option = map.get(x);
                            if (!(option instanceof Some)) break block5;
                            Some some = (Some)option;
                            Opcodes.Instruction instruction3 = newInstr = (instruction = (Opcodes.Instruction)some.x());
                            list2 = this.subst$0(xs, map).$colon$colon(instruction3);
                            break block3;
                        }
                        if (None$.MODULE$ != option) break block6;
                        Opcodes.Instruction instruction = x;
                        list2 = this.subst$0(xs, map).$colon$colon(instruction);
                    }
                    return list2;
                }
                throw new MatchError(option);
            }
            throw new MatchError(list);
        }

        public /* synthetic */ ICodes scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer() {
            return this.$outer;
        }

        public String toString() {
            return "" + BoxesUtility.boxToInteger(this.label());
        }

        public String fullString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Block ").append(((Object)BoxesUtility.boxToInteger(this.label())).toString());
            buf.append("\nSuccessors: ").append(this.successors());
            buf.append("\nPredecessors: ").append(this.predecessors());
            return buf.toString();
        }

        public void print(PrintStream out$0) {
            out$0.println("block #" + BoxesUtility.boxToInteger(this.label()) + " :");
            this.toList().foreach(new BasicBlock$$anonfun$5(this, out$0));
            out$0.print("Successors: ");
            this.successors().foreach(new BasicBlock$$anonfun$6(this, out$0));
            out$0.println();
        }

        public void print() {
            this.print(System.out);
        }

        public int hashCode() {
            return this.label();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            Object object = other;
            if (!(object instanceof BasicBlock)) return false;
            BasicBlock basicBlock = (BasicBlock)object;
            BasicBlock that = basicBlock;
            if (that.label() != this.label()) return false;
            Members.Code code = that.code();
            Members.Code code2 = this.code();
            if (code != null) {
                if (!code.equals(code2)) return false;
                return true;
            }
            if (code2 == null) return true;
            return false;
        }

        public List predecessors() {
            this.preds_$eq(((Iterator)this.code().blocks().elements()).filter(new BasicBlock$$anonfun$4(this)).toList());
            return this.preds();
        }

        public List successors() {
            List list;
            if (this.isEmpty()) {
                list = Nil$.MODULE$;
            } else {
                List list2;
                Opcodes.Instruction instruction = this.lastInstruction();
                if (instruction instanceof Opcodes.opcodes.JUMP && ((Opcodes.opcodes.JUMP)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$JUMP$$$outer() == this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                    list2 = List$.MODULE$.apply(new BoxedObjectArray(new BasicBlock[]{((Opcodes.opcodes.JUMP)instruction).whereto()}));
                } else if (instruction instanceof Opcodes.opcodes.CJUMP && ((Opcodes.opcodes.CJUMP)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$CJUMP$$$outer() == this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                    BasicBlock basicBlock;
                    Opcodes.opcodes.CJUMP cJUMP = (Opcodes.opcodes.CJUMP)instruction;
                    BasicBlock basicBlock2 = cJUMP.successBlock();
                    BasicBlock failure = basicBlock = cJUMP.failureBlock();
                    BasicBlock success = basicBlock2;
                    BasicBlock basicBlock3 = failure;
                    BasicBlock basicBlock4 = success;
                    list2 = Nil$.MODULE$.$colon$colon(basicBlock4).$colon$colon(basicBlock3);
                } else if (instruction instanceof Opcodes.opcodes.CZJUMP && ((Opcodes.opcodes.CZJUMP)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$CZJUMP$$$outer() == this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                    BasicBlock basicBlock;
                    Opcodes.opcodes.CZJUMP cZJUMP = (Opcodes.opcodes.CZJUMP)instruction;
                    BasicBlock basicBlock5 = cZJUMP.successBlock();
                    BasicBlock failure = basicBlock = cZJUMP.failureBlock();
                    BasicBlock success = basicBlock5;
                    BasicBlock basicBlock6 = failure;
                    BasicBlock basicBlock7 = success;
                    list2 = Nil$.MODULE$.$colon$colon(basicBlock7).$colon$colon(basicBlock6);
                } else if (instruction instanceof Opcodes.opcodes.SWITCH && ((Opcodes.opcodes.SWITCH)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$SWITCH$$$outer() == this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                    list2 = ((Opcodes.opcodes.SWITCH)instruction).labels();
                } else if (instruction instanceof Opcodes.opcodes.RETURN && ((Opcodes.opcodes.RETURN)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$RETURN$$$outer() == this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                    list2 = Nil$.MODULE$;
                } else if (instruction instanceof Opcodes.opcodes.THROW && ((Opcodes.opcodes.THROW)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$THROW$$$outer() == this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                    list2 = Nil$.MODULE$;
                } else {
                    if (this.isClosed()) {
                        this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().dump();
                        this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().global().abort("The last instruction is not a control flow instruction: " + this.lastInstruction());
                        return null;
                    }
                    list2 = Nil$.MODULE$;
                }
                ObjectRef res$0 = new ObjectRef(list2);
                this.method().exh().foreach(new BasicBlock$$anonfun$3(this, res$0));
                list = (List)res$0.elem;
            }
            return list;
        }

        public boolean isClosed() {
            return this.closed();
        }

        public Opcodes.Instruction[] toInstructionArray(List l) {
            ObjectRef array$0 = new ObjectRef(new Opcodes.Instruction[l.length()]);
            IntRef i$0 = new IntRef(0);
            l.foreach(new BasicBlock$$anonfun$2(this, array$0, i$0));
            return (Opcodes.Instruction[])array$0.elem;
        }

        public Opcodes.Instruction firstInstruction() {
            return this.closed() ? this.instrs()[0] : (Opcodes.Instruction)this.instructionList().last();
        }

        public Opcodes.Instruction lastInstruction() {
            return this.closed() ? this.instrs()[this.instrs().length - 1] : (Opcodes.Instruction)this.instructionList().head();
        }

        public void exitIgnoreMode() {
            Predef$.MODULE$.assert(this.ignore(), "Exit ignore mode when not in ignore mode.");
            this.ignore_$eq(false);
        }

        public void enterIgnoreMode() {
            this.ignore_$eq(true);
        }

        public boolean isEmpty() {
            return this.instructionList().isEmpty();
        }

        public void clear() {
            this.instructionList_$eq(Nil$.MODULE$);
            this.instrs_$eq(null);
            this.preds_$eq(null);
        }

        public void open() {
            Predef$.MODULE$.assert(this.closed());
            this.closed_$eq(false);
            this.ignore_$eq(false);
            this.instructionList_$eq((List)this.instructionList().reverse());
        }

        public void close() {
            Predef$.MODULE$.assert(this.instructionList().length() > 0, "Empty block.");
            this.closed_$eq(true);
            this.instructionList_$eq((List)this.instructionList().reverse());
            this.instrs_$eq(this.toInstructionArray(this.instructionList()));
        }

        public void emit(Opcodes.Instruction instr, Position pos) {
            if (this.closed()) {
                this.print();
                Console$.MODULE$.println("trying to emit: " + instr);
            }
            Predef$.MODULE$.assert(!this.closed() || this.ignore(), "BasicBlock closed");
            if (!this.ignore()) {
                this.touched_$eq(true);
                instr.pos_$eq(pos);
                Opcodes.Instruction instruction = instr;
                this.instructionList_$eq(this.instructionList().$colon$colon(instruction));
                this._lastInstruction_$eq(instr);
            }
        }

        public void emit(Opcodes.Instruction instr) {
            if (this.instructionList().isEmpty()) {
                this.emit(instr, NoPosition$.MODULE$);
            } else {
                this.emit(instr, ((Opcodes.Instruction)this.instructionList().head()).pos());
            }
        }

        private void substOnList(Map map$0) {
            this.instructionList_$eq(this.subst$0(this.instructionList(), map$0));
        }

        public void subst(Map map) {
            if (this.closed()) {
                for (int i = 0; i < this.instrs().length; ++i) {
                    Option option = map.get(this.instrs()[i]);
                    if (option instanceof Some) {
                        this.touched_$eq(this.replaceInstruction(i, (Opcodes.Instruction)((Some)option).x()));
                        continue;
                    }
                    if (None$.MODULE$ == option) {
                        continue;
                    }
                    throw new MatchError(option);
                }
            } else {
                this.substOnList(map);
            }
        }

        public void removeLastInstruction() {
            if (this.closed()) {
                this.removeInstructionsAt(new BoxedIntArray(new int[]{this.size()}));
            } else {
                this.instructionList_$eq(this.instructionList().tail());
                this.touched_$eq(true);
            }
        }

        public void removeInstructionsAt(Seq positions) {
            Predef$.MODULE$.assert(this.closed());
            List removed = positions.toList();
            Opcodes.Instruction[] newInstrs = new Opcodes.Instruction[this.instrs().length - positions.length()];
            int j = 0;
            for (int i = 0; i < this.instrs().length; ++i) {
                if (removed.contains(BoxesUtility.boxToInteger(i))) continue;
                newInstrs[j] = this.instrs()[i];
                ++j;
            }
            this.instrs_$eq(newInstrs);
        }

        public void insertAfter(int idx, List is) {
            Predef$.MODULE$.assert(this.closed(), "Instructions can be replaced only after the basic block is closed");
            int i = idx + 1;
            if (i < this.instrs().length) {
                Opcodes.Instruction[] newInstrs$1 = new Opcodes.Instruction[this.instrs().length + is.length()];
                Array$.MODULE$.copy(this.instrs(), 0, newInstrs$1, 0, i);
                IntRef j$1 = new IntRef(i);
                is.foreach(new BasicBlock$$anonfun$1(this, newInstrs$1, j$1));
                if (i + 1 < this.instrs().length) {
                    Array$.MODULE$.copy(this.instrs(), i + 1, newInstrs$1, j$1.elem, this.instrs().length - i);
                }
                this.instrs_$eq(newInstrs$1);
            }
        }

        public boolean replaceInstruction(Opcodes.Instruction iold, List is) {
            int i;
            Predef$.MODULE$.assert(this.closed(), "Instructions can be replaced only after the basic block is closed");
            boolean changed = false;
            for (i = 0; i < this.instrs().length && this.instrs()[i] != iold; ++i) {
            }
            if (i < this.instrs().length) {
                Opcodes.Instruction[] newInstrs$0 = new Opcodes.Instruction[this.instrs().length + is.length() - 1];
                changed = true;
                Array$.MODULE$.copy(this.instrs(), 0, newInstrs$0, 0, i);
                IntRef j$0 = new IntRef(i);
                is.foreach(new BasicBlock$$anonfun$0(this, newInstrs$0, j$0));
                if (i + 1 < this.instrs().length) {
                    Array$.MODULE$.copy(this.instrs(), i + 1, newInstrs$0, j$0.elem, this.instrs().length - i - 1);
                }
                this.instrs_$eq(newInstrs$0);
            }
            return changed;
        }

        public boolean replaceInstruction(Opcodes.Instruction oldInstr, Opcodes.Instruction newInstr) {
            Predef$.MODULE$.assert(this.closed(), "Instructions can be replaced only after the basic block is closed");
            boolean changed = false;
            for (int i = 0; i < this.instrs().length && !changed; ++i) {
                Opcodes.Instruction instruction = this.instrs()[i];
                Opcodes.Instruction instruction2 = oldInstr;
                if (instruction != null ? !instruction.equals(instruction2) : instruction2 != null) continue;
                newInstr.pos_$eq(oldInstr.pos());
                this.instrs()[i] = newInstr;
                changed = true;
            }
            return changed;
        }

        public boolean replaceInstruction(int pos, Opcodes.Instruction instr) {
            Predef$.MODULE$.assert(this.closed(), "Instructions can be replaced only after the basic block is closed");
            instr.pos_$eq(this.instrs()[pos].pos());
            this.instrs()[pos] = instr;
            return true;
        }

        public Opcodes.Instruction apply(int n) {
            return this.closed() ? this.instrs()[n] : (Opcodes.Instruction)((List)this.instructionList().reverse()).apply(n);
        }

        public Option findDef(int pos) {
            Predef$.MODULE$.assert(this.closed());
            int i = pos;
            int d = 0;
            while (i > 0) {
                int prod = this.instrs()[--i].produced();
                if (prod > 0 && d == 0) {
                    return new Some(BoxesUtility.boxToInteger(i));
                }
                d += this.instrs()[i].consumed() - this.instrs()[i].produced();
            }
            return None$.MODULE$;
        }

        public int size() {
            return this.isClosed() ? this.instrs().length : this.instructionList().length();
        }

        public void traverseBackwards(Function1 f) {
            for (int i = this.instrs().length - 1; i >= 0; --i) {
                f.apply(this.instrs()[i]);
            }
        }

        public void traverse(Function1 f) {
            if (this.closed()) {
                new BoxedObjectArray(this.instrs()).foreach(f);
                return;
            }
            this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().dump();
            this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().global().abort("Traversing an open block!: " + BoxesUtility.boxToInteger(this.label()));
        }

        public int indexOf(Opcodes.Instruction inst) {
            Predef$.MODULE$.assert(this.closed());
            for (int i = 0; i < this.instrs().length; ++i) {
                if (this.instrs()[i] != inst) continue;
                return i;
            }
            return -1;
        }

        public void fromList(List is) {
            this.instrs_$eq(this.toInstructionArray(is));
            this.closed_$eq(true);
        }

        public Opcodes.Instruction[] getArray() {
            Predef$.MODULE$.assert(this.closed());
            return this.instrs();
        }

        public List toList() {
            if (this.closed() && this.touched()) {
                this.instructionList_$eq(List$.MODULE$.fromArray(new BoxedObjectArray(this.instrs())));
            }
            return this.instructionList();
        }

        private void touched_$eq(boolean x$1) {
            this.touched = x$1;
        }

        private boolean touched() {
            return this.touched;
        }

        private void instrs_$eq(Opcodes.Instruction[] x$1) {
            this.instrs = x$1;
        }

        private Opcodes.Instruction[] instrs() {
            return this.instrs;
        }

        private void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        private boolean closed() {
            return this.closed;
        }

        private void _lastInstruction_$eq(Opcodes.Instruction x$1) {
            this._lastInstruction = x$1;
        }

        private Opcodes.Instruction _lastInstruction() {
            return this._lastInstruction;
        }

        private void instructionList_$eq(List x$1) {
            this.instructionList = x$1;
        }

        private List instructionList() {
            return this.instructionList;
        }

        public void varsInScope_$eq(Set x$1) {
            this.varsInScope = x$1;
        }

        public Set varsInScope() {
            return this.varsInScope;
        }

        public void exceptionHandlerHeader_$eq(boolean x$1) {
            this.exceptionHandlerHeader = x$1;
        }

        public boolean exceptionHandlerHeader() {
            return this.exceptionHandlerHeader;
        }

        public void loopHeader_$eq(boolean x$1) {
            this.loopHeader = x$1;
        }

        public boolean loopHeader() {
            return this.loopHeader;
        }

        public void preds_$eq(List x$1) {
            this.preds = x$1;
        }

        public List preds() {
            return this.preds;
        }

        public void ignore_$eq(boolean x$1) {
            this.ignore = x$1;
        }

        public boolean ignore() {
            return this.ignore;
        }

        public int label() {
            return this.label;
        }

        public Members.Code code() {
            return this.method().code();
        }

        public Members.IMethod method() {
            return this.method;
        }

        public int $tag() {
            return ScalaObject$class.$tag(this);
        }
    }
}

