/*
 * Decompiled with CFR 0.152.
 */
package scala.dbc.datatype;

import scala.MatchError;
import scala.ScalaObject;
import scala.Tuple3;
import scala.dbc.DataType;
import scala.dbc.datatype.Numeric;
import scala.dbc.exception.UnsupportedFeature;
import scala.runtime.BoxesUtility;

public abstract class ExactNumeric
extends Numeric
implements ScalaObject {
    private int nativeTypeId;

    public ExactNumeric(int nativeTypeId) {
        this.nativeTypeId = nativeTypeId;
        super(nativeTypeId);
    }

    public String sqlString() {
        String string;
        Tuple3 tuple3 = new Tuple3(BoxesUtility.boxToInteger(this.precisionRadix()), BoxesUtility.boxToInteger(this.precision()), BoxesUtility.boxToInteger(this.scale()));
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        int n = BoxesUtility.unboxToInt(tuple3._2());
        int n2 = BoxesUtility.unboxToInt(tuple3._3());
        block0 : switch (BoxesUtility.unboxToInt(tuple3._1())) {
            default: {
                throw new UnsupportedFeature("SQL-99 does not support the precision of an exact numeric type to be defined in a radix other than 2 or 10");
            }
            case 2: {
                switch (n) {
                    default: {
                        throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                    }
                    case 16: {
                        if (n2 == 0) {
                            string = "SMALLINT";
                            break block0;
                        }
                        throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                    }
                    case 32: {
                        if (n2 == 0) {
                            string = "INTEGER";
                            break block0;
                        }
                        throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                    }
                    case 64: {
                        if (n2 == 0) {
                            string = "BIGINT";
                            break block0;
                        }
                        throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                    }
                    case 0x7FFFFFFF: 
                }
                if (n2 == 0) {
                    string = "BIGINT";
                    break;
                }
                throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
            }
            case 10: {
                string = n2 == 0 ? "NUMERIC (" + ((Object)BoxesUtility.boxToInteger(n)).toString() + ")" : "NUMERIC (" + ((Object)BoxesUtility.boxToInteger(n)).toString() + ", " + ((Object)BoxesUtility.boxToInteger(n2)).toString() + ")";
            }
        }
        return string;
    }

    public abstract int scale();

    public boolean isSubtypeOf(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (dataType instanceof ExactNumeric) {
            ExactNumeric exactNumeric;
            ExactNumeric dt = exactNumeric = (ExactNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() <= dt.precision() && this.scale() <= dt.scale() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isEquivalent(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (dataType instanceof ExactNumeric) {
            ExactNumeric exactNumeric;
            ExactNumeric dt = exactNumeric = (ExactNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() == dt.precision() && this.scale() == dt.scale() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    public int nativeTypeId() {
        return this.nativeTypeId;
    }
}

