/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Console$;
import scala.Function1;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Seq;
import scala.Some;
import scala.Tuple2;
import scala.compat.StringBuilder;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesUtility;
import scala.tools.nsc.CompileClient$;
import scala.tools.nsc.CompileSocket;
import scala.tools.nsc.CompileSocket$;
import scala.tools.nsc.GenericRunnerSettings;
import scala.tools.nsc.Global;
import scala.tools.nsc.Interpreter$;
import scala.tools.nsc.ScriptRunner$;
import scala.tools.nsc.Settings;
import scala.tools.nsc.StandardCompileClient;
import scala.tools.nsc.io.PlainFile;
import scala.tools.nsc.reporters.ConsoleReporter;
import scala.tools.nsc.reporters.Reporter;
import scala.tools.nsc.util.CompoundSourceFile;
import scala.tools.nsc.util.SourceFile;
import scala.tools.nsc.util.SourceFileFragment;

public class ScriptRunner
implements ScalaObject {
    private String endCode = "\n} }\n";
    private String defaultScriptMain = "Main";

    private final boolean jarOK$0(String string, File file) {
        return file.canRead() && file.lastModified() > new File(string).lastModified();
    }

    private final Tuple2 compile$0(GenericRunnerSettings genericRunnerSettings, String string) {
        Tuple2 tuple2;
        File compiledPath$0 = File.createTempFile("scalascript", "");
        compiledPath$0.delete();
        compiledPath$0.mkdirs();
        Runtime.getRuntime().addShutdownHook(new $anon$0(this, compiledPath$0));
        genericRunnerSettings.outdir().value_$eq(compiledPath$0.getPath());
        if (genericRunnerSettings.nocompdaemon().value()) {
            ConsoleReporter reporter = new ConsoleReporter(genericRunnerSettings);
            Global compiler$0 = this.newGlobal(genericRunnerSettings, reporter);
            Global.Run cr = new Global.Run(compiler$0);
            SourceFile wrapped = this.wrappedScript(this.scriptMain(genericRunnerSettings), string, new $anonfun$6(this, compiler$0));
            cr.compileSources(List$.MODULE$.apply(new BoxedObjectArray(new SourceFile[]{wrapped})));
            tuple2 = new Tuple2(compiledPath$0, BoxesUtility.boxToBoolean(!reporter.hasErrors()));
        } else {
            boolean compok = this.compileWithDaemon(genericRunnerSettings, string);
            tuple2 = new Tuple2(compiledPath$0, BoxesUtility.boxToBoolean(compok));
        }
        return tuple2;
    }

    public final void addFromDir$0(File dir, String prefix$0, JarOutputStream jarOutputStream, byte[] byArray) {
        new BoxedObjectArray(dir.listFiles()).foreach(new $anonfun$0(this, jarOutputStream, byArray, prefix$0));
    }

    public void runScript(GenericRunnerSettings settings$0, String scriptFile, List scriptArgs$0) {
        File f = new File(scriptFile);
        if (f.isFile()) {
            this.withCompiledScript(settings$0, scriptFile, new $anonfun$7(this, settings$0, scriptArgs$0));
            return;
        }
        Console$.MODULE$.println("no such file: " + scriptFile);
    }

    private void withCompiledScript(GenericRunnerSettings settings$1, String scriptFile$0, Function1 handler) {
        if (settings$1.savecompiled().value()) {
            File jarFile$0 = this.jarFileFor(scriptFile$0);
            if (this.jarOK$0(scriptFile$0, jarFile$0)) {
                handler.apply(jarFile$0.getAbsolutePath());
            } else {
                jarFile$0.delete();
                Tuple2 tuple2 = this.compile$0(settings$1, scriptFile$0);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                File file = (File)tuple2._1();
                boolean bl = BoxesUtility.unboxToBoolean(tuple2._2());
                File compiledPath = file;
                boolean compok = bl;
                Tuple2 tuple22 = new Tuple2(compiledPath, BoxesUtility.boxToBoolean(compok));
                File compiledPath2 = (File)tuple22._1();
                boolean compok2 = BoxesUtility.unboxToBoolean(tuple22._2());
                if (compok2) {
                    this.tryMakeJar(jarFile$0, compiledPath2);
                    if (this.jarOK$0(scriptFile$0, jarFile$0)) {
                        Interpreter$.MODULE$.deleteRecursively(compiledPath2);
                        handler.apply(jarFile$0.getAbsolutePath());
                    } else {
                        handler.apply(compiledPath2.getPath());
                    }
                }
            }
        } else {
            Tuple2 tuple2 = this.compile$0(settings$1, scriptFile$0);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            File file = (File)tuple2._1();
            boolean bl = BoxesUtility.unboxToBoolean(tuple2._2());
            File compiledPath = file;
            boolean compok = bl;
            Tuple2 tuple23 = new Tuple2(compiledPath, BoxesUtility.boxToBoolean(compok));
            File compiledPath3 = (File)tuple23._1();
            boolean compok3 = BoxesUtility.unboxToBoolean(tuple23._2());
            if (compok3) {
                handler.apply(compiledPath3.getPath());
            }
        }
    }

    public Global newGlobal(Settings settings, Reporter reporter) {
        return new Global(settings, reporter);
    }

    private boolean compileWithDaemon(GenericRunnerSettings settings, String scriptFileIn) {
        List coreCompArgs;
        String scriptFile = this.compileClient().absFileName(scriptFileIn);
        List$.MODULE$.apply(new BoxedObjectArray(new Settings.StringSetting[]{settings.classpath(), settings.sourcepath(), settings.bootclasspath(), settings.extdirs(), settings.outdir()})).foreach(new $anonfun$1(this));
        Seq compSettingNames$0 = new Settings(new $anonfun$2(this)).allSettings().map(new $anonfun$3(this));
        Seq compSettings = settings.allSettings().filter(new $anonfun$4(this, (List)compSettingNames$0));
        List list = coreCompArgs = (List)((List)compSettings).foldLeft(Nil$.MODULE$, new $anonfun$5(this));
        List compArgs = List$.MODULE$.apply(new BoxedObjectArray(new String[]{"-Xscript", this.scriptMain(settings), scriptFile})).$colon$colon$colon(list);
        Socket socket = this.compileSocket().getOrCreateSocket("");
        if (socket == null) {
            return false;
        }
        PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        out.println(this.compileSocket().getPassword(socket.getPort()));
        out.println(compArgs.mkString("", "\u0000", ""));
        boolean compok = true;
        String fromServer = in.readLine();
        while (true) {
            if (fromServer == null) {
                in.close();
                out.close();
                socket.close();
                return compok;
            }
            Console$.MODULE$.println(fromServer);
            if (this.compileSocket().errorPattern().matcher(fromServer).matches()) {
                compok = false;
            }
            fromServer = in.readLine();
        }
    }

    public SourceFile wrappedScript(String objectName, String filename, Function1 getSourceFile) {
        SourceFile preamble = new SourceFile("<script preamble>", this.preambleCode(objectName).toCharArray());
        File f = new File(filename);
        SourceFileFragment middle = new SourceFileFragment((SourceFile)getSourceFile.apply(new PlainFile(f)), this.headerLength(filename), (int)f.length());
        SourceFile end = new SourceFile("<script trailer>", this.endCode().toCharArray());
        return new CompoundSourceFile(new BoxedObjectArray(new SourceFile[]{preamble, middle, end}));
    }

    public String endCode() {
        return this.endCode;
    }

    public String preambleCode(String objectName) {
        Option option;
        block6: {
            String string;
            String objName;
            block5: {
                block4: {
                    String string2;
                    Tuple2 tuple2 = this.splitObjectName(objectName);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Option option2 = (Option)tuple2._1();
                    String string3 = (String)tuple2._2();
                    Option maybePack = option2;
                    String objName2 = string3;
                    Tuple2 tuple22 = new Tuple2(maybePack, objName2);
                    Option maybePack2 = (Option)tuple22._1();
                    objName = (String)tuple22._2();
                    option = maybePack2;
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    String pack = string2 = (String)some.x();
                    string = "package " + pack + "\n";
                    break block5;
                }
                if (None$.MODULE$ != option) break block6;
                string = "";
            }
            String packageDecl = string;
            return packageDecl + "object " + objName + " {\n" + "  def main(argv: Array[String]): Unit = {\n" + "  val args = argv;\n";
        }
        throw new MatchError(option);
    }

    private Tuple2 splitObjectName(String fullname) {
        int idx = fullname.lastIndexOf(46);
        return idx < 0 ? new Tuple2(None$.MODULE$, fullname) : new Tuple2(new Some(fullname.substring(0, idx)), fullname.substring(idx + 1));
    }

    private int headerLength(String filename) {
        String fileContents = this.contentsOfFile(filename);
        if (fileContents.startsWith("#!") || fileContents.startsWith("::#!")) {
            Matcher matcher = Pattern.compile("^(::)?!#.*(\\r|\\n|\\r\\n)", 8).matcher(fileContents);
            if (matcher.find()) {
                return matcher.end();
            }
            throw new Error("script file does not close its header with !# or ::!#");
        }
        return 0;
    }

    private String contentsOfFile(String filename) {
        StringBuilder strbuf = new StringBuilder();
        FileReader reader = new FileReader(filename);
        char[] cbuf = new char[1024];
        int n;
        while ((n = reader.read(cbuf)) > 0) {
            strbuf.append(cbuf, 0, n);
        }
        return strbuf.toString();
    }

    private Object tryMakeJar(File jarFile, File sourcePath) {
        Serializable serializable;
        try {
            FileOutputStream jarFileStream = new FileOutputStream(jarFile);
            JarOutputStream jar$0 = new JarOutputStream(jarFileStream);
            byte[] buf$0 = new byte[10240];
            this.addFromDir$0(sourcePath, "", jar$0, buf$0);
            jar$0.close();
            serializable = BoxedUnit.UNIT;
        }
        catch (Error error) {
            serializable = BoxesUtility.boxToBoolean(jarFile.delete());
        }
        return serializable;
    }

    private File jarFileFor(String scriptFile) {
        String filename = scriptFile.matches(".*\\.[^.\\\\/]*") ? scriptFile.replaceFirst("\\.[^.\\\\/]*$", ".jar") : scriptFile + ".jar";
        return new File(filename);
    }

    public String scriptMain(Settings settings) {
        String string = settings.script().value();
        String string2 = "";
        return !(string != null ? !string.equals(string2) : string2 != null) ? this.defaultScriptMain() : settings.script().value();
    }

    public String defaultScriptMain() {
        return this.defaultScriptMain;
    }

    public CompileSocket compileSocket() {
        return CompileSocket$.MODULE$;
    }

    public StandardCompileClient compileClient() {
        return CompileClient$.MODULE$;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

