/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.scalap;

import scala.ScalaObject;
import scala.ScalaObject$class;

public class ByteArrayReader
implements ScalaObject {
    private int bp;
    private byte[] buf;

    public ByteArrayReader(byte[] content) {
        this.buf = content;
        this.bp = 0;
    }

    public void skip(int n) {
        this.bp_$eq(this.bp() + n);
    }

    public double getDouble(int bp) {
        return Double.longBitsToDouble(this.getLong(bp));
    }

    public float getFloat(int bp) {
        return Float.intBitsToFloat(this.getInt(bp));
    }

    public long getLong(int bp) {
        return ((long)this.getInt(bp) << 32) + ((long)this.getInt(bp + 4) & 0xFFFFFFFFL);
    }

    public int getInt(int bp) {
        return ((this.buf()[bp] & 0xFF) << 24) + ((this.buf()[bp + 1] & 0xFF) << 16) + ((this.buf()[bp + 2] & 0xFF) << 8) + (this.buf()[bp + 3] & 0xFF);
    }

    public char getChar(int bp) {
        return (char)(((this.buf()[bp] & 0xFF) << 8) + (this.buf()[bp + 1] & 0xFF));
    }

    public String nextUTF8(int len) {
        char[] cs = new char[len];
        int i = this.bp();
        int j = 0;
        this.bp_$eq(this.bp() + len);
        while (i < this.bp()) {
            int b = this.buf()[i] & 0xFF;
            ++i;
            if (b < 224) {
                if (b >= 192) {
                    b = (b & 0x1F) << 6 | this.buf()[i] & 0x3F;
                    ++i;
                }
            } else {
                b = (b & 0xF) << 12 | (this.buf()[i] & 0x3F) << 6;
                b |= this.buf()[++i] & 0x3F;
                ++i;
            }
            cs[j] = (char)b;
            ++j;
        }
        return new String(cs, 0, j);
    }

    public long nextNum(int n) {
        long x = 0L;
        int i = 0;
        while (true) {
            if (i >= n) {
                int leading = 64 - n * 8;
                return x << leading >> leading;
            }
            x = (x << 8) + (long)(this.nextByte() & 0xFF);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int nextNat() {
        void var1_1;
        int x = 0;
        int b = 0;
        do {
            b = this.buf()[this.bp()];
            this.bp_$eq(this.bp() + 1);
            x = (x << 7) + (b & 0x7F);
        } while ((b & 0x80) != 0);
        return (int)var1_1;
    }

    public double nextDouble() {
        return Double.longBitsToDouble(this.nextLong());
    }

    public float nextFloat() {
        return Float.intBitsToFloat(this.nextInt());
    }

    public long nextLong() {
        return ((long)this.nextInt() << 32) + ((long)this.nextInt() & 0xFFFFFFFFL);
    }

    public int nextInt() {
        this.bp_$eq(this.bp() + 4);
        return ((this.buf()[this.bp() - 4] & 0xFF) << 24) + ((this.buf()[this.bp() - 3] & 0xFF) << 16) + ((this.buf()[this.bp() - 2] & 0xFF) << 8) + (this.buf()[this.bp() - 1] & 0xFF);
    }

    public char nextChar() {
        this.bp_$eq(this.bp() + 2);
        return (char)(((this.buf()[this.bp() - 2] & 0xFF) << 8) + (this.buf()[this.bp() - 1] & 0xFF));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] nextBytes(int len) {
        void var2_2;
        byte[] res = new byte[len];
        System.arraycopy(this.buf(), this.bp(), res, 0, len);
        this.bp_$eq(this.bp() + len);
        return var2_2;
    }

    public byte nextByte() {
        this.bp_$eq(this.bp() + 1);
        return this.buf()[this.bp() - 1];
    }

    public byte byteAt(int pos) {
        return this.buf()[pos];
    }

    public void bp_$eq(int x$1) {
        this.bp = x$1;
    }

    public int bp() {
        return this.bp;
    }

    public byte[] buf() {
        return this.buf;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

