/*
 * Decompiled with CFR 0.152.
 */
package sbaz;

import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import sbaz.AvailableList;
import sbaz.AvailablePackage;
import sbaz.Message;
import sbaz.PackageSpec;
import sbaz.ServletRequestHandler$;
import sbaz.SimpleUniverse;
import sbaz.Universe;
import sbaz.keys.Key;
import sbaz.keys.KeyRing;
import sbaz.keys.KeyUtil$;
import sbaz.keys.MessagePattern;
import sbaz.messages.AddPackage;
import sbaz.messages.KeyCreate;
import sbaz.messages.KeyCreated;
import sbaz.messages.KeyList;
import sbaz.messages.KeyRevoke;
import sbaz.messages.LatestPackages;
import sbaz.messages.NotOK;
import sbaz.messages.OK;
import sbaz.messages.RemovePackage;
import sbaz.messages.SendKeyList$;
import sbaz.messages.SendPackageList;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.List;
import scala.MatchError;
import scala.ScalaObject;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

public class ServletRequestHandler
implements ScalaObject {
    private List keylessRequests;
    private KeyRing keyring;
    private AvailableList packages;
    private SimpleUniverse universe;
    private File directory;

    public ServletRequestHandler(File file) {
        SimpleUniverse simpleUniverse;
        this.directory = file;
        Universe universe = (Universe)this.loadXML("universe", new $anonfun$1(this), new $anonfun$0(this));
        if (!(universe instanceof SimpleUniverse)) {
            throw new Error("this universe is not a simple universe");
        }
        this.universe = simpleUniverse = (SimpleUniverse)universe;
        this.packages = (AvailableList)this.loadXML("packages", new $anonfun$3(this), new $anonfun$2(this));
        this.keyring = (KeyRing)this.loadXML("keyring", new $anonfun$5(this), new $anonfun$4(this));
        this.keylessRequests = (List)this.loadXML("keylessRequests", new $anonfun$9(this), new $anonfun$8(this));
        Console$.MODULE$.println((Object)("requests needing no key are: " + this.keylessRequests()));
    }

    public final List fromXML$0(Node node) {
        return node.child().toList().filter((Function1)new $anonfun$6(this)).map((Function1)new $anonfun$7(this));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message handleRequest(Message message) {
        ServletRequestHandler servletRequestHandler = this;
        synchronized (servletRequestHandler) {
            NotOK notOK;
            block17: {
                void var9_13;
                block18: {
                    Message message2;
                    block19: {
                        boolean bl;
                        Message message3;
                        block16: {
                            message3 = message.sansKeys();
                            List list = message.authKeys().filter((Function1)new $anonfun$11(this));
                            if (this.keylessRequests().exists((Function1)new $anonfun$12(this, message3)) || list.exists((Function1)new $anonfun$13(this, message3))) break block16;
                            notOK = new NotOK("Permission denied");
                            break block17;
                        }
                        message2 = message3;
                        switch (message2.$tag()) {
                            default: {
                                bl = false;
                                break;
                            }
                            case -2087426967: {
                                if (!(message2 instanceof KeyRevoke)) {
                                    bl = false;
                                    break;
                                }
                                this.keyring().removeKey(((KeyRevoke)message2).key());
                                this.saveKeyring();
                                OK oK = new OK();
                                break block18;
                            }
                            case -780905530: {
                                if (!(message2 instanceof RemovePackage)) {
                                    bl = false;
                                    break;
                                }
                                RemovePackage removePackage = (RemovePackage)message2;
                                PackageSpec packageSpec = removePackage.spec();
                                Console$.MODULE$.println((Object)("removing package: " + packageSpec));
                                List list = this.packages().available().filter((Function1)new $anonfun$15(this, packageSpec));
                                this.packages_$eq(new AvailableList(list));
                                this.savePackages();
                                OK oK = new OK();
                                break block18;
                            }
                            case -659615167: {
                                if (!(message2 instanceof AddPackage)) {
                                    bl = false;
                                    break;
                                }
                                AddPackage addPackage = (AddPackage)message2;
                                AvailablePackage availablePackage = addPackage.pack();
                                Console$.MODULE$.println((Object)("adding new package: " + availablePackage));
                                List list = this.packages().available().filter((Function1)new $anonfun$14(this, availablePackage));
                                AvailablePackage availablePackage2 = availablePackage;
                                List list2 = list.$colon$colon((Object)availablePackage2);
                                this.packages_$eq(new AvailableList(list2));
                                this.savePackages();
                                OK oK = new OK();
                                break block18;
                            }
                            case -306258688: {
                                if (!(message2 instanceof SendPackageList)) {
                                    bl = false;
                                    break;
                                }
                                LatestPackages latestPackages = new LatestPackages(this.packages());
                                break block18;
                            }
                            case 171012249: {
                                if (message2 != SendKeyList$.MODULE$) {
                                    bl = false;
                                    break;
                                }
                                KeyList keyList = new KeyList(this.keyring().keys());
                                break block18;
                            }
                            case 1789589215: {
                                if (message2 instanceof KeyCreate) break block19;
                                bl = false;
                            }
                        }
                        if (bl) throw new MatchError((Object)message2);
                        NotOK notOK2 = new NotOK("unhandled message type.  full message: " + message3);
                        break block18;
                    }
                    KeyCreate keyCreate = (KeyCreate)message2;
                    MessagePattern messagePattern = keyCreate.messages();
                    String string = keyCreate.description();
                    String string2 = KeyUtil$.MODULE$.genKeyData();
                    Key key = new Key(messagePattern, string, string2);
                    this.keyring().addKey(key);
                    this.saveKeyring();
                    KeyCreated keyCreated = new KeyCreated(key);
                }
                notOK = var9_13;
            }
            return notOK;
        }
    }

    public String responseForGET() {
        ServletRequestHandler servletRequestHandler = this;
        synchronized (servletRequestHandler) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("This is a Scala Bazaar.  The bazaar descriptor is:\n");
            stringWriter.write(this.universe().toXML().toString());
            stringWriter.write("\n\n");
            stringWriter.write("The packages included are:\n");
            this.packages().sortedSpecs().foreach((Function1)new $anonfun$10(this, stringWriter));
            return stringWriter.toString();
        }
    }

    public List keylessRequests() {
        return this.keylessRequests;
    }

    public boolean saveKeyring() {
        return this.saveXML(this.keyring().toXML(), "keyring");
    }

    public KeyRing keyring() {
        return this.keyring;
    }

    public boolean savePackages() {
        return this.saveXML((Node)this.packages().toXML(), "packages");
    }

    public void packages_$eq(AvailableList availableList) {
        this.packages = availableList;
    }

    public AvailableList packages() {
        return this.packages;
    }

    public SimpleUniverse universe() {
        return this.universe;
    }

    private boolean saveXML(Node node, String string) {
        File file = new File(this.directory, string + ".tmp");
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(node.toString());
        fileWriter.close();
        return this.renameFile(file, new File(this.directory, string));
    }

    private boolean renameFile(File file, File file2) {
        file2.delete();
        return file.renameTo(file2);
    }

    public Object loadXML(String string, Function1 function1, Function0 function0) {
        Object object;
        File file = new File(this.directory, string);
        if (!file.exists()) {
            object = function0.apply();
        } else {
            Elem elem = XML$.MODULE$.load(file.getAbsolutePath());
            object = function1.apply((Object)elem);
        }
        return object;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

