/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.util;

import scala.Function1;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.runtime.BoxedUnit;
import scala.tools.nsc.util.SourceFile$;

public class CharArrayReader
implements ScalaObject {
    private boolean onlyBlankChars;
    private int lastBlankLinePos;
    private int lineStartPos;
    private int lastLineStartPos;
    private boolean isUnicode;
    private char oldCh;
    private int oldBp;
    private int bp;
    private char ch;
    private int tabinc;
    private Function1 error;
    private boolean decodeUni;
    private int start;
    private char[] buf;

    public CharArrayReader(char[] cArray, int n, boolean bl, Function1 function1) {
        this.buf = cArray;
        this.start = n;
        this.decodeUni = bl;
        this.error = function1;
        this.tabinc = 8;
        this.bp = n;
        this.oldBp = -1;
        this.lastLineStartPos = 0;
        this.lineStartPos = 0;
        this.lastBlankLinePos = 0;
        this.onlyBlankChars = false;
    }

    private final int udigit$0() {
        Object object;
        int n = this.digit2int(this.buf[this.bp()], 16);
        if (n < 0) {
            object = this.error.apply("error in unicode escape");
        } else {
            this.bp_$eq(this.bp() + 1);
            object = BoxedUnit.UNIT;
        }
        return n;
    }

    private final boolean evenSlashPrefix$0() {
        int n = this.bp() - 2;
        while (n >= 0 && this.buf[n] == '\\') {
            --n;
        }
        return (this.bp() - n) % 2 == 0;
    }

    public int digit2int(char c, int n) {
        return '0' > c || c > '9' || c >= 48 + n ? ('A' > c || c >= 65 + n - 10 ? ('a' > c || c >= 97 + n - 10 ? -1 : c - 97 + 10) : c - 65 + 10) : c - 48;
    }

    public CharArrayReader copy() {
        return new CharArrayReader(this.buf, this.bp(), this.decodeUni, this.error);
    }

    public void rewind() {
        if (this.oldBp() != -1) {
            this.bp_$eq(this.oldBp());
            this.ch_$eq(this.oldCh());
            this.oldBp_$eq(-1);
            this.oldCh_$eq('x');
            return;
        }
        throw new IllegalArgumentException();
    }

    public void next() {
        if (!this.hasNext()) {
            SourceFile$.MODULE$.SU();
            return;
        }
        this.oldBp_$eq(this.bp());
        this.oldCh_$eq(this.ch());
        this.ch_$eq(this.buf[this.bp()]);
        this.isUnicode_$eq(false);
        this.bp_$eq(this.bp() + 1);
        char c = this.ch();
        if (c != '\t') {
            if (c != SourceFile$.MODULE$.CR()) {
                if (c != SourceFile$.MODULE$.LF() && c != SourceFile$.MODULE$.FF()) {
                    if (c != '\\') {
                        if (this.ch() > ' ') {
                            this.onlyBlankChars_$eq(false);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (this.buf[this.bp()] == 'u' && this.decodeUni && this.evenSlashPrefix$0()) {
                            do {
                                this.bp_$eq(this.bp() + 1);
                            } while (this.buf[this.bp()] == 'u');
                            int n = this.udigit$0() << 12 | this.udigit$0() << 8 | this.udigit$0() << 4 | this.udigit$0();
                            this.ch_$eq((char)n);
                            this.isUnicode_$eq(true);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    this.markNewLine();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                if (this.buf[this.bp()] == SourceFile$.MODULE$.LF()) {
                    this.ch_$eq(SourceFile$.MODULE$.LF());
                    this.bp_$eq(this.bp() + 1);
                }
                this.markNewLine();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public char last() {
        return this.bp() <= this.start + 2 ? (char)' ' : this.buf[this.bp() - 2];
    }

    public boolean hasNext() {
        return this.bp() < this.buf.length;
    }

    private void markNewLine() {
        this.lastLineStartPos_$eq(this.lineStartPos());
        if (this.onlyBlankChars()) {
            this.lastBlankLinePos_$eq(this.lineStartPos());
        }
        this.lineStartPos_$eq(this.bp());
        this.onlyBlankChars_$eq(true);
    }

    private void onlyBlankChars_$eq(boolean bl) {
        this.onlyBlankChars = bl;
    }

    private boolean onlyBlankChars() {
        return this.onlyBlankChars;
    }

    public void lastBlankLinePos_$eq(int n) {
        this.lastBlankLinePos = n;
    }

    public int lastBlankLinePos() {
        return this.lastBlankLinePos;
    }

    public void lineStartPos_$eq(int n) {
        this.lineStartPos = n;
    }

    public int lineStartPos() {
        return this.lineStartPos;
    }

    public void lastLineStartPos_$eq(int n) {
        this.lastLineStartPos = n;
    }

    public int lastLineStartPos() {
        return this.lastLineStartPos;
    }

    public void isUnicode_$eq(boolean bl) {
        this.isUnicode = bl;
    }

    public boolean isUnicode() {
        return this.isUnicode;
    }

    public int cpos() {
        return this.bp();
    }

    public void oldCh_$eq(char c) {
        this.oldCh = c;
    }

    public char oldCh() {
        return this.oldCh;
    }

    public void oldBp_$eq(int n) {
        this.oldBp = n;
    }

    public int oldBp() {
        return this.oldBp;
    }

    public void bp_$eq(int n) {
        this.bp = n;
    }

    public int bp() {
        return this.bp;
    }

    public void ch_$eq(char c) {
        this.ch = c;
    }

    public char ch() {
        return this.ch;
    }

    public int tabinc() {
        return this.tabinc;
    }

    public CharArrayReader(char[] cArray, boolean bl, Function1 function1) {
        this(cArray, 0, bl, function1);
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

