/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2005-2007, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: ActorProxy.scala 10899 2007-05-01 10:33:58Z phaller $


package scala.actors


import java.lang.Thread

/**
 * The class <code>ActorProxy</code>provides a dynamic actor proxy for normal
 * Java threads.
 *
 * @version 0.9.6
 * @author Philipp Haller
 */
private[actors] class ActorProxy(t: Thread) extends Actor {

  def act() {}

  /**
   * Terminates with exit reason <code>'normal</code>.
   */
  override def exit(): Nothing = {
    shouldExit = false
    // links
    if (!links.isEmpty)
      exitLinked()
    throw new InterruptedException
  }

}
