/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.backend.icode;

import java.io.PrintStream;
import scala.$colon$colon;
import scala.Array$;
import scala.Console$;
import scala.Function1;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Seq;
import scala.Some;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.compat.StringBuilder;
import scala.runtime.BoxedIntArray;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesUtility;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.tools.nsc.backend.icode.BasicBlocks$BasicBlock$;
import scala.tools.nsc.backend.icode.ICodes;
import scala.tools.nsc.backend.icode.Members;
import scala.tools.nsc.backend.icode.Opcodes;
import scala.tools.nsc.backend.icode.analysis.ProgramPoint;
import scala.tools.nsc.util.NoPosition$;
import scala.tools.nsc.util.Position;

public interface BasicBlocks
extends ScalaObject {

    public class BasicBlock
    implements ProgramPoint,
    ScalaObject {
        public /* synthetic */ ICodes $outer;
        private boolean touched;
        private Opcodes.Instruction[] instrs;
        private boolean closed;
        private Opcodes.Instruction _lastInstruction;
        private List instructionList;
        private Set varsInScope;
        private boolean exceptionHandlerHeader;
        private boolean loopHeader;
        private List preds;
        private boolean ignore;
        private int label;
        private Members.IMethod method;

        public BasicBlock(ICodes iCodes, int n, Members.IMethod iMethod) {
            this.method = iMethod;
            if (iCodes != null) {
                this.$outer = iCodes;
                this.label = n;
                this.ignore = false;
                this.preds = null;
                this.loopHeader = false;
                this.exceptionHandlerHeader = false;
                this.varsInScope = new LinkedHashSet();
                this.instructionList = Nil$.MODULE$;
                this._lastInstruction = null;
                this.closed = false;
                this.touched = false;
                return;
            }
            throw new NullPointerException();
        }

        private final List subst$0(List list, Map map) {
            List list2;
            List list3 = list;
            if (list3 != Nil$.MODULE$) {
                List list4;
                if (!(list3 instanceof $colon$colon)) {
                    throw new MatchError(list3);
                }
                $colon$colon $colon$colon = ($colon$colon)list3;
                Opcodes.Instruction instruction = (Opcodes.Instruction)$colon$colon.hd();
                List list5 = $colon$colon.tl$0();
                Option option = map.get(instruction);
                if (!(option instanceof Some)) {
                    if (option != None$.MODULE$) {
                        throw new MatchError(option);
                    }
                    Opcodes.Instruction instruction2 = instruction;
                    list4 = this.subst$0(list5, map).$colon$colon(instruction2);
                } else {
                    Opcodes.Instruction instruction3;
                    Some some = (Some)option;
                    Opcodes.Instruction instruction4 = instruction3 = (Opcodes.Instruction)some.x();
                    list4 = this.subst$0(list5, map).$colon$colon(instruction4);
                }
                list2 = list4;
            } else {
                list2 = Nil$.MODULE$;
            }
            return list2;
        }

        public /* synthetic */ ICodes scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer() {
            return this.$outer;
        }

        public String toString() {
            return "" + BoxesUtility.boxToInteger(this.label());
        }

        public String fullString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Block ").append(((Object)BoxesUtility.boxToInteger(this.label())).toString());
            stringBuilder.append("\nSuccessors: ").append(this.successors());
            stringBuilder.append("\nPredecessors: ").append(this.predecessors());
            return stringBuilder.toString();
        }

        public void print(PrintStream printStream) {
            printStream.println("block #" + BoxesUtility.boxToInteger(this.label()) + " :");
            this.toList().foreach(new BasicBlock$$anonfun$5(this, printStream));
            printStream.print("Successors: ");
            this.successors().foreach(new BasicBlock$$anonfun$6(this, printStream));
            printStream.println();
        }

        public void print() {
            this.print(System.out);
        }

        public int hashCode() {
            return this.label();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            Object object2 = object;
            if (!(object2 instanceof BasicBlock)) {
                return false;
            }
            BasicBlock basicBlock = (BasicBlock)object2;
            BasicBlock basicBlock2 = basicBlock;
            if (basicBlock2.label() != this.label()) return false;
            Members.Code code = basicBlock2.code();
            Members.Code code2 = this.code();
            if (code != null) {
                if (code.equals(code2)) return true;
                return false;
            } else if (code2 == null) return true;
            return false;
        }

        public List predecessors() {
            this.preds_$eq(this.code().blocks().elements().filter(new BasicBlock$$anonfun$4(this)).toList());
            return this.preds();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public List successors() {
            void var3_14;
            List list;
            block15: {
                Opcodes.Instruction instruction;
                block16: {
                    boolean bl;
                    if (this.isEmpty()) {
                        list = Nil$.MODULE$;
                        return list;
                    }
                    instruction = this.lastInstruction();
                    switch (instruction.$tag()) {
                        default: {
                            bl = false;
                            break;
                        }
                        case -1887773086: {
                            if (!(instruction instanceof Opcodes.opcodes.CJUMP) || ((Opcodes.opcodes.CJUMP)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$CJUMP$$$outer() != this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                                bl = false;
                                break;
                            }
                            Opcodes.opcodes.CJUMP cJUMP = (Opcodes.opcodes.CJUMP)instruction;
                            BasicBlock basicBlock = cJUMP.successBlock();
                            BasicBlock basicBlock2 = cJUMP.failureBlock();
                            BasicBlock basicBlock3 = basicBlock;
                            BasicBlock basicBlock4 = basicBlock2;
                            List list2 = Nil$.MODULE$.$colon$colon(basicBlock4).$colon$colon(basicBlock3);
                            break block15;
                        }
                        case -1872135625: {
                            if (!(instruction instanceof Opcodes.opcodes.THROW) || ((Opcodes.opcodes.THROW)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$THROW$$$outer() != this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                                bl = false;
                                break;
                            }
                            Nil$ nil$ = Nil$.MODULE$;
                            break block15;
                        }
                        case -1584697699: {
                            if (!(instruction instanceof Opcodes.opcodes.JUMP) || ((Opcodes.opcodes.JUMP)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$JUMP$$$outer() != this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                                bl = false;
                                break;
                            }
                            List list3 = List$.MODULE$.apply(new BoxedObjectArray(new BasicBlock[]{((Opcodes.opcodes.JUMP)instruction).where()}));
                            break block15;
                        }
                        case 1623032788: {
                            if (!(instruction instanceof Opcodes.opcodes.CZJUMP) || ((Opcodes.opcodes.CZJUMP)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$CZJUMP$$$outer() != this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                                bl = false;
                                break;
                            }
                            Opcodes.opcodes.CZJUMP cZJUMP = (Opcodes.opcodes.CZJUMP)instruction;
                            BasicBlock basicBlock = cZJUMP.successBlock();
                            BasicBlock basicBlock5 = cZJUMP.failureBlock();
                            BasicBlock basicBlock6 = basicBlock;
                            BasicBlock basicBlock7 = basicBlock5;
                            List list4 = Nil$.MODULE$.$colon$colon(basicBlock7).$colon$colon(basicBlock6);
                            break block15;
                        }
                        case 2033374175: {
                            if (!(instruction instanceof Opcodes.opcodes.RETURN) || ((Opcodes.opcodes.RETURN)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$RETURN$$$outer() != this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                                bl = false;
                                break;
                            }
                            Nil$ nil$ = Nil$.MODULE$;
                            break block15;
                        }
                        case 2078297571: {
                            if (instruction instanceof Opcodes.opcodes.SWITCH && ((Opcodes.opcodes.SWITCH)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$SWITCH$$$outer() == this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) break block16;
                            bl = false;
                        }
                    }
                    if (bl) throw new MatchError(instruction);
                    if (this.isClosed()) {
                        this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().dump();
                        this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().global().abort("The last instruction is not a control flow instruction: " + this.lastInstruction());
                        return null;
                    }
                    Nil$ nil$ = Nil$.MODULE$;
                    break block15;
                }
                List list5 = ((Opcodes.opcodes.SWITCH)instruction).labels();
            }
            ObjectRef objectRef = new ObjectRef(var3_14);
            this.method().exh().foreach(new BasicBlock$$anonfun$3(this, objectRef));
            list = (List)objectRef.elem;
            return list;
        }

        public boolean isClosed() {
            return this.closed();
        }

        public Opcodes.Instruction[] toInstructionArray(List list) {
            ObjectRef objectRef = new ObjectRef(new Opcodes.Instruction[list.length()]);
            IntRef intRef = new IntRef(0);
            list.foreach(new BasicBlock$$anonfun$2(this, objectRef, intRef));
            return (Opcodes.Instruction[])objectRef.elem;
        }

        public Opcodes.Instruction firstInstruction() {
            return !this.closed() ? (Opcodes.Instruction)this.instructionList().last() : this.instrs()[0];
        }

        public Opcodes.Instruction lastInstruction() {
            return !this.closed() ? (Opcodes.Instruction)this.instructionList().head() : this.instrs()[this.instrs().length - 1];
        }

        public void exitIgnoreMode() {
            Predef$.MODULE$.assert(this.ignore(), "Exit ignore mode when not in ignore mode.");
            this.ignore_$eq(false);
        }

        public void enterIgnoreMode() {
            this.ignore_$eq(true);
        }

        public boolean isEmpty() {
            return this.instructionList().isEmpty();
        }

        public void clear() {
            this.instructionList_$eq(Nil$.MODULE$);
            this.instrs_$eq(null);
            this.preds_$eq(null);
        }

        public void open() {
            Predef$.MODULE$.assert(this.closed());
            this.closed_$eq(false);
            this.ignore_$eq(false);
            this.instructionList_$eq((List)this.instructionList().reverse());
        }

        public void close() {
            Predef$.MODULE$.assert(this.instructionList().length() > 0, "Empty block.");
            this.closed_$eq(true);
            this.instructionList_$eq((List)this.instructionList().reverse());
            this.instrs_$eq(this.toInstructionArray(this.instructionList()));
        }

        public void emit(Opcodes.Instruction instruction, Position position) {
            block1: {
                if (this.closed()) {
                    this.print();
                    Console$.MODULE$.println("trying to emit: " + instruction);
                }
                Predef$.MODULE$.assert(!this.closed() || this.ignore(), "BasicBlock closed");
                if (this.ignore()) break block1;
                this.touched_$eq(true);
                instruction.pos_$eq(position);
                Opcodes.Instruction instruction2 = instruction;
                this.instructionList_$eq(this.instructionList().$colon$colon(instruction2));
                this._lastInstruction_$eq(instruction);
            }
        }

        public void emit(Opcodes.Instruction instruction) {
            if (!this.instructionList().isEmpty()) {
                this.emit(instruction, ((Opcodes.Instruction)this.instructionList().head()).pos());
            } else {
                this.emit(instruction, NoPosition$.MODULE$);
            }
        }

        private void substOnList(Map map) {
            this.instructionList_$eq(this.subst$0(this.instructionList(), map));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void subst(Map map) {
            if (!this.closed()) {
                this.substOnList(map);
                return;
            }
            int n = 0;
            while (n < this.instrs().length) {
                BoxedUnit boxedUnit;
                Option option = map.get(this.instrs()[n]);
                if (!(option instanceof Some)) {
                    if (option != None$.MODULE$) {
                        throw new MatchError(option);
                    }
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.touched_$eq(this.replaceInstruction(n, (Opcodes.Instruction)((Some)option).x()));
                    boxedUnit = BoxedUnit.UNIT;
                }
                ++n;
            }
            return;
        }

        public void removeLastInstruction() {
            if (!this.closed()) {
                this.instructionList_$eq(this.instructionList().tail());
                this.touched_$eq(true);
            } else {
                this.removeInstructionsAt(new BoxedIntArray(new int[]{this.size()}));
            }
        }

        public void removeInstructionsAt(Seq seq) {
            Predef$.MODULE$.assert(this.closed());
            List list = seq.toList();
            Opcodes.Instruction[] instructionArray = new Opcodes.Instruction[this.instrs().length - seq.length()];
            int n = 0;
            int n2 = 0;
            while (true) {
                if (n >= this.instrs().length) {
                    this.instrs_$eq(instructionArray);
                    return;
                }
                if (!list.contains(BoxesUtility.boxToInteger(n))) {
                    instructionArray[n2] = this.instrs()[n];
                    ++n2;
                }
                ++n;
            }
        }

        public void insertAfter(int n, List list) {
            Predef$.MODULE$.assert(this.closed(), "Instructions can be replaced only after the basic block is closed");
            int n2 = n + 1;
            if (n2 < this.instrs().length) {
                Opcodes.Instruction[] instructionArray = new Opcodes.Instruction[this.instrs().length + list.length()];
                Array$.MODULE$.copy(this.instrs(), 0, instructionArray, 0, n2);
                IntRef intRef = new IntRef(n2);
                list.foreach(new BasicBlock$$anonfun$1(this, instructionArray, intRef));
                if (n2 + 1 < this.instrs().length) {
                    Array$.MODULE$.copy(this.instrs(), n2 + 1, instructionArray, intRef.elem, this.instrs().length - n2);
                }
                this.instrs_$eq(instructionArray);
            }
        }

        public boolean replaceInstruction(Opcodes.Instruction instruction, List list) {
            Predef$.MODULE$.assert(this.closed(), "Instructions can be replaced only after the basic block is closed");
            int n = 0;
            boolean bl = false;
            while (true) {
                if (n >= this.instrs().length || this.instrs()[n] == instruction) {
                    if (n < this.instrs().length) {
                        Opcodes.Instruction[] instructionArray = new Opcodes.Instruction[this.instrs().length + list.length() - 1];
                        bl = true;
                        Array$.MODULE$.copy(this.instrs(), 0, instructionArray, 0, n);
                        IntRef intRef = new IntRef(n);
                        list.foreach(new BasicBlock$$anonfun$0(this, instructionArray, intRef));
                        if (n + 1 < this.instrs().length) {
                            Array$.MODULE$.copy(this.instrs(), n + 1, instructionArray, intRef.elem, this.instrs().length - n - 1);
                        }
                        this.instrs_$eq(instructionArray);
                    }
                    return bl;
                }
                ++n;
            }
        }

        public boolean replaceInstruction(Opcodes.Instruction instruction, Opcodes.Instruction instruction2) {
            Predef$.MODULE$.assert(this.closed(), "Instructions can be replaced only after the basic block is closed");
            boolean bl = false;
            for (int i = 0; i < this.instrs().length && !bl; ++i) {
                Opcodes.Instruction instruction3 = this.instrs()[i];
                Opcodes.Instruction instruction4 = instruction;
                if (instruction3 != null ? !instruction3.equals(instruction4) : instruction4 != null) continue;
                instruction2.pos_$eq(instruction.pos());
                this.instrs()[i] = instruction2;
                bl = true;
            }
            return bl;
        }

        public boolean replaceInstruction(int n, Opcodes.Instruction instruction) {
            Predef$.MODULE$.assert(this.closed(), "Instructions can be replaced only after the basic block is closed");
            instruction.pos_$eq(this.instrs()[n].pos());
            this.instrs()[n] = instruction;
            return true;
        }

        public Opcodes.Instruction apply(int n) {
            return !this.closed() ? (Opcodes.Instruction)((List)this.instructionList().reverse()).apply(n) : this.instrs()[n];
        }

        public Option findDef(int n) {
            Predef$.MODULE$.assert(this.closed());
            int n2 = n;
            int n3 = 0;
            while (true) {
                if (n2 <= 0) {
                    return None$.MODULE$;
                }
                int n4 = this.instrs()[--n2].produced();
                if (n4 > 0 && n3 == false) break;
                n3 += this.instrs()[n2].consumed() - this.instrs()[n2].produced();
            }
            return new Some(BoxesUtility.boxToInteger(n2));
        }

        public int size() {
            return !this.isClosed() ? this.instructionList().length() : this.instrs().length;
        }

        public void traverseBackwards(Function1 function1) {
            int n = this.instrs().length - 1;
            while (n >= 0) {
                function1.apply(this.instrs()[n]);
                --n;
            }
            return;
        }

        public void traverse(Function1 function1) {
            if (!this.closed()) {
                this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().dump();
                this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().global().abort("Traversing an open block!: " + BoxesUtility.boxToInteger(this.label()));
                return;
            }
            new BoxedObjectArray(this.instrs()).foreach(function1);
        }

        public int indexOf(Opcodes.Instruction instruction) {
            Predef$.MODULE$.assert(this.closed());
            int n = 0;
            while (true) {
                if (n >= this.instrs().length) {
                    return -1;
                }
                if (this.instrs()[n] == instruction) break;
                ++n;
            }
            return n;
        }

        public void fromList(List list) {
            this.instrs_$eq(this.toInstructionArray(list));
            this.closed_$eq(true);
        }

        public Opcodes.Instruction[] getArray() {
            Predef$.MODULE$.assert(this.closed());
            return this.instrs();
        }

        public List toList() {
            if (this.closed() && this.touched()) {
                this.instructionList_$eq(List$.MODULE$.fromArray(new BoxedObjectArray(this.instrs())));
            }
            return this.instructionList();
        }

        private void touched_$eq(boolean bl) {
            this.touched = bl;
        }

        private boolean touched() {
            return this.touched;
        }

        private void instrs_$eq(Opcodes.Instruction[] instructionArray) {
            this.instrs = instructionArray;
        }

        private Opcodes.Instruction[] instrs() {
            return this.instrs;
        }

        private void closed_$eq(boolean bl) {
            this.closed = bl;
        }

        private boolean closed() {
            return this.closed;
        }

        private void _lastInstruction_$eq(Opcodes.Instruction instruction) {
            this._lastInstruction = instruction;
        }

        private Opcodes.Instruction _lastInstruction() {
            return this._lastInstruction;
        }

        private void instructionList_$eq(List list) {
            this.instructionList = list;
        }

        private List instructionList() {
            return this.instructionList;
        }

        public void varsInScope_$eq(Set set) {
            this.varsInScope = set;
        }

        public Set varsInScope() {
            return this.varsInScope;
        }

        public void exceptionHandlerHeader_$eq(boolean bl) {
            this.exceptionHandlerHeader = bl;
        }

        public boolean exceptionHandlerHeader() {
            return this.exceptionHandlerHeader;
        }

        public void loopHeader_$eq(boolean bl) {
            this.loopHeader = bl;
        }

        public boolean loopHeader() {
            return this.loopHeader;
        }

        public void preds_$eq(List list) {
            this.preds = list;
        }

        public List preds() {
            return this.preds;
        }

        public void ignore_$eq(boolean bl) {
            this.ignore = bl;
        }

        public boolean ignore() {
            return this.ignore;
        }

        public int label() {
            return this.label;
        }

        public Members.Code code() {
            return this.method().code();
        }

        public Members.IMethod method() {
            return this.method;
        }

        public int $tag() {
            return ScalaObject$class.$tag(this);
        }
    }
}

