/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Random;
import java.util.regex.Pattern;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Seq;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesUtility;
import scala.runtime.Nothing$;
import scala.tools.nsc.CompileClient$;
import scala.tools.nsc.CompileSocket$;
import scala.tools.nsc.Properties$;

public final class CompileSocket$
implements ScalaObject {
    public static final CompileSocket$ MODULE$;
    private int sleepTime;
    private int MaxAttempts;
    private File portsDir;
    private File tmpDir;
    private Pattern errorPattern;
    private String errorRegex;
    private String serverClass;
    private String vmCommand;
    private String dirName = "scalac-compile-server-port";

    static {
        CompileSocket$ compileSocket$ = new CompileSocket$();
    }

    public CompileSocket$() {
        String string;
        MODULE$ = this;
        String string2 = Properties$.MODULE$.scalaHome();
        if (string2 != null) {
            String string3 = string2;
            File file = new File(new File(string3, "bin"), Properties$.MODULE$.cmdName());
            string = !file.canRead() ? Properties$.MODULE$.cmdName() : file.getPath();
        } else {
            Object var2_4 = null;
            string = Properties$.MODULE$.cmdName();
        }
        this.vmCommand = string;
        this.serverClass = "scala.tools.nsc.CompileServer";
        this.errorRegex = ".*errors? found.*";
        this.errorPattern = Pattern.compile(this.errorRegex());
        List list = List$.MODULE$.apply(new BoxedObjectArray(new Tuple2[]{new Tuple2("scala.home", List$.MODULE$.apply(new BoxedObjectArray(new String[]{"var", "scala-devel"}))), new Tuple2("user.home", List$.MODULE$.apply(new BoxedObjectArray(new String[]{"tmp"}))), new Tuple2("java.io.tmpdir", Nil$.MODULE$)}));
        Seq seq = ((List)((List)((List)list.map(new anonfun.1())).filter(new anonfun.2())).filter(new anonfun.3())).map(new anonfun.4());
        if (!seq.isEmpty()) {
            File file = (File)((List)seq).head();
            file.mkdirs();
            this.info("[Temp directory: " + file + "]");
            this.tmpDir = file;
            this.portsDir = new File(this.tmpDir(), this.dirName());
            this.portsDir().mkdirs();
            this.MaxAttempts = 100;
            this.sleepTime = 20;
            return;
        }
        this.fatal("Could not find a directory for temporary files");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Socket getsock$0(int n, String string, boolean bl) {
        if (n == 0) {
            this.error("Unable to establish connection to compilation daemon");
            return null;
        }
        int n2 = !bl ? this.pollPort() : this.getPort(string);
        if (n2 < 0) return null;
        String string2 = InetAddress.getLocalHost().getHostName();
        {
            Socket socket = new Socket(string2, n2);
            this.info("[Connected to compilation daemon at port " + BoxesUtility.boxToInteger(n2) + "]");
            Socket socket2 = socket;
            return socket2;
        }
    }

    public final boolean isDirWritable$0(File file) {
        return file.isDirectory() && file.canWrite();
    }

    public final Option expand$0(Tuple2 tuple2) {
        Tuple2 tuple22 = tuple2;
        if (tuple22 != null) {
            String string = (String)tuple22._1();
            List list = (List)tuple22._2();
            String string2 = string;
            List list2 = list;
            Tuple2 tuple23 = new Tuple2(string2, list2);
            String string3 = (String)tuple23._1();
            List list3 = (List)tuple23._2();
            String string4 = System.getProperty(string3);
            if (string4 != null) {
                File file = (File)list3.foldLeft(new File(string4), new anonfun.0());
                return new Some(file);
            }
            return None$.MODULE$;
        }
        throw new MatchError(tuple22);
    }

    public String getPassword(int n) {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.portFile(n)));
        String string = bufferedReader.readLine();
        bufferedReader.close();
        return string;
    }

    public Socket getSocket(String string, int n) {
        try {
            return new Socket(string, n);
        }
        catch (Exception exception) {
            this.fatal("Unable to establish connection to server " + string + ":" + BoxesUtility.boxToInteger(n) + "; exiting");
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Socket getSocket(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            this.fatal("Malformed server address: " + string + "; exiting");
            return null;
        }
        String string2 = string.substring(0, n);
        try {
            int n2 = Predef$.MODULE$.stringWrapper(string.substring(n + 1)).toInt();
            return this.getSocket(string2, n2);
        }
        catch (Throwable throwable) {
            this.fatal("Malformed server address: " + string + "; exiting");
            return null;
        }
    }

    public Socket getOrCreateSocket(String string) {
        return this.getOrCreateSocket(string, true);
    }

    public Socket getOrCreateSocket(String string, boolean bl) {
        int n = 49;
        return this.getsock$0(n, string, bl);
    }

    public void deletePort(int n) {
        this.portFile(n).delete();
    }

    public void setPort(int n) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.portFile(n)));
            printWriter.println(((Object)BoxesUtility.boxToInteger(new Random().nextInt())).toString());
            printWriter.close();
            return;
        }
        catch (Exception exception) {
            this.fatal("Cannot create file: " + this.portFile(n).getAbsolutePath());
            return;
        }
    }

    public int getPort(String string) {
        int n = 0;
        int n2 = this.pollPort();
        if (n2 < 0) {
            this.startNewServer(string);
        }
        while (true) {
            if (n2 >= 0 || n >= this.MaxAttempts()) {
                this.info("[Port number: " + BoxesUtility.boxToInteger(n2) + "]");
                if (n2 >= 0) {
                    return n2;
                }
                this.fatal("Could not connect to compilation daemon.");
                return 0;
            }
            ++n;
            Thread.sleep(Predef$.MODULE$.int2long(this.sleepTime()));
            n2 = this.pollPort();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int pollPort() {
        int n;
        File[] fileArray = this.portsDir().listFiles();
        if (fileArray.length == 0) return -1;
        try {
            Predef$.MODULE$.intWrapper(1).until(fileArray.length).foreach(new anonfun.5(fileArray));
            n = Predef$.MODULE$.stringWrapper(fileArray[0].getName()).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            this.fatal(numberFormatException.toString() + "\nbad file in temp directory: " + fileArray[0].getAbsolutePath() + "\nplease remove the file and try again");
            return 0;
        }
        return n;
    }

    public File portFile(int n) {
        return new File(this.portsDir(), ((Object)BoxesUtility.boxToInteger(n)).toString());
    }

    private void startNewServer(String string) {
        String string2 = this.serverCommand(string);
        this.info("[Executed command: " + string2 + "]");
        try {
            Runtime.getRuntime().exec(string2);
            return;
        }
        catch (IOException iOException) {
            this.fatal("Cannot start compilation daemon.\ntried command: " + string2);
            return;
        }
    }

    private String serverCommand(String string) {
        return this.vmCommand() + string + " " + this.serverClass();
    }

    private int sleepTime() {
        return this.sleepTime;
    }

    private int MaxAttempts() {
        return this.MaxAttempts;
    }

    public File portsDir() {
        return this.portsDir;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    private void info(String string) {
        if (CompileClient$.MODULE$.verbose()) {
            System.out.println(string);
        }
    }

    private Nothing$ fatal(String string) {
        this.error(string);
        return Predef$.MODULE$.exit(1);
    }

    private void error(String string) {
        System.err.println(string);
    }

    public Pattern errorPattern() {
        return this.errorPattern;
    }

    public String errorRegex() {
        return this.errorRegex;
    }

    private String serverClass() {
        return this.serverClass;
    }

    private String vmCommand() {
        return this.vmCommand;
    }

    private String dirName() {
        return this.dirName;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

