/*
 * Decompiled with CFR 0.152.
 */
package scala.actors;

import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.actors.Actor;
import scala.actors.FJTask;
import scala.actors.FJTaskRunnerGroup;
import scala.actors.IScheduler;
import scala.actors.IScheduler$class;
import scala.actors.LinkedQueue;
import scala.actors.QuitException;
import scala.actors.Reaction;
import scala.actors.TimerThread$;
import scala.actors.WorkerThread;
import scala.compat.Platform$;
import scala.runtime.Null$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class FJTaskScheduler2
extends Thread
implements IScheduler,
ScalaObject {
    private Reaction QUIT_TASK;
    private Function0 lockupHandler;
    private int CHECK_FREQ;
    private int TICK_FREQ;
    private int pendingReactions;
    private int submittedTasks;
    private long lastActivity;
    private boolean suspending;
    private boolean terminating;
    private FJTaskRunnerGroup executor;
    private int coreSize;
    private int maxSize;
    private int initCoreSize;
    private String maxProp;
    private String coreProp;
    private boolean printStats = false;

    public FJTaskScheduler2() {
        IScheduler$class.$init$(this);
        this.coreProp = System.getProperty("actors.corePoolSize");
        this.maxProp = System.getProperty("actors.maxPoolSize");
        this.initCoreSize = this.coreProp() != null ? Integer.parseInt(this.coreProp()) : 4;
        this.maxSize = this.maxProp() != null ? Integer.parseInt(this.maxProp()) : 256;
        this.coreSize = this.initCoreSize();
        this.executor = new FJTaskRunnerGroup(this.coreSize());
        this.terminating = false;
        this.suspending = false;
        this.lastActivity = Platform$.MODULE$.currentTime();
        this.submittedTasks = 0;
        this.pendingReactions = 0;
        this.TICK_FREQ = 50;
        this.CHECK_FREQ = 100;
        this.lockupHandler = null;
    }

    private final void liftedTry0$0() {
        block2: {
            try {
                this.wait(Predef$.MODULE$.int2long(this.CHECK_FREQ()));
            }
            catch (InterruptedException interruptedException) {
                if (this.terminating()) break block2;
            }
            return;
        }
        throw new QuitException();
    }

    public Runnable getTask(WorkerThread workerThread) {
        this.getTask(workerThread);
        return null;
    }

    public LinkedQueue snapshot() {
        FJTaskScheduler2 fJTaskScheduler2 = this;
        synchronized (fJTaskScheduler2) {
            this.suspending_$eq(true);
            this.executor().snapshot();
            return this.executor().entryQueue;
        }
    }

    public void shutdown() {
        FJTaskScheduler2 fJTaskScheduler2 = this;
        synchronized (fJTaskScheduler2) {
            this.terminating_$eq(true);
            TimerThread$.MODULE$.t().interrupt();
            return;
        }
    }

    public void tick(Actor actor) {
        this.lastActivity_$eq(Platform$.MODULE$.currentTime());
    }

    public Null$ getTask(WorkerThread workerThread) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(Reaction reaction) {
        FJTaskScheduler2 fJTaskScheduler2 = this;
        synchronized (fJTaskScheduler2) {
            this.pendingReactions_$eq(this.pendingReactions() + 1);
        }
        this.executor().execute(reaction);
    }

    public void execute(FJTask fJTask) {
        this.executor().execute(fJTask);
    }

    public void execute(Reaction reaction) {
        this.executor().execute(reaction);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (!this.terminating()) {
            FJTaskScheduler2 fJTaskScheduler2 = this;
            synchronized (fJTaskScheduler2) {
                this.liftedTry0$0();
                if (!(this.suspending() || Platform$.MODULE$.currentTime() - this.lastActivity() >= (long)this.TICK_FREQ() && this.coreSize() < this.maxSize() && this.executor().checkPoolSize() || this.pendingReactions() > 0 || this.executor().getActiveCount() != 0)) {
                    TimerThread$.MODULE$.t().interrupt();
                    throw new QuitException();
                }
            }
        }
        return;
        {
            catch (QuitException quitException) {
                if (!this.printStats()) return;
                this.executor().stats();
                return;
            }
            {
                catch (Throwable throwable) {}
                throw throwable;
            }
        }
    }

    private void lockupHandler_$eq(Function0 function0) {
        this.lockupHandler = function0;
    }

    private Function0 lockupHandler() {
        return this.lockupHandler;
    }

    public void onLockup(int n, Function0 function0) {
        this.lockupHandler_$eq(function0);
    }

    public void onLockup(Function0 function0) {
        this.lockupHandler_$eq(function0);
    }

    private int CHECK_FREQ() {
        return this.CHECK_FREQ;
    }

    private int TICK_FREQ() {
        return this.TICK_FREQ;
    }

    public void terminated(Actor actor) {
    }

    public void printActorDump() {
    }

    public void unPendReaction() {
        FJTaskScheduler2 fJTaskScheduler2 = this;
        synchronized (fJTaskScheduler2) {
            this.pendingReactions_$eq(this.pendingReactions() - 1);
            return;
        }
    }

    public void pendReaction() {
        FJTaskScheduler2 fJTaskScheduler2 = this;
        synchronized (fJTaskScheduler2) {
            this.pendingReactions_$eq(this.pendingReactions() + 1);
            return;
        }
    }

    private void pendingReactions_$eq(int n) {
        this.pendingReactions = n;
    }

    private int pendingReactions() {
        return this.pendingReactions;
    }

    private void submittedTasks_$eq(int n) {
        this.submittedTasks = n;
    }

    private int submittedTasks() {
        return this.submittedTasks;
    }

    private void lastActivity_$eq(long l) {
        this.lastActivity = l;
    }

    private long lastActivity() {
        return this.lastActivity;
    }

    private void suspending_$eq(boolean bl) {
        this.suspending = bl;
    }

    private boolean suspending() {
        return this.suspending;
    }

    private void terminating_$eq(boolean bl) {
        this.terminating = bl;
    }

    private boolean terminating() {
        return this.terminating;
    }

    private FJTaskRunnerGroup executor() {
        return this.executor;
    }

    private void coreSize_$eq(int n) {
        this.coreSize = n;
    }

    private int coreSize() {
        return this.coreSize;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public int initCoreSize() {
        return this.initCoreSize;
    }

    public String maxProp() {
        return this.maxProp;
    }

    public String coreProp() {
        return this.coreProp;
    }

    public boolean printStats() {
        return this.printStats;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }

    public final void QUIT_TASK_$eq(Reaction reaction) {
        this.QUIT_TASK = reaction;
    }

    public final Reaction QUIT_TASK() {
        return this.QUIT_TASK;
    }
}

