/*
 * Decompiled with CFR 0.152.
 */
package sbaz;

import java.io.File;
import java.io.FileWriter;
import java.io.StringWriter;
import sbaz.AvailableList;
import sbaz.AvailablePackage;
import sbaz.Message;
import sbaz.PackageSpec;
import sbaz.ServletRequestHandler$;
import sbaz.SimpleUniverse;
import sbaz.Universe;
import sbaz.keys.Key;
import sbaz.keys.KeyRing;
import sbaz.keys.KeyUtil$;
import sbaz.keys.MessagePattern;
import sbaz.messages.AddPackage;
import sbaz.messages.KeyCreate;
import sbaz.messages.KeyCreated;
import sbaz.messages.KeyList;
import sbaz.messages.KeyRevoke;
import sbaz.messages.LatestPackages;
import sbaz.messages.NotOK;
import sbaz.messages.OK;
import sbaz.messages.RemovePackage;
import sbaz.messages.SendKeyList$;
import sbaz.messages.SendPackageList;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.List;
import scala.ScalaObject;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

public class ServletRequestHandler
implements ScalaObject {
    private List keylessRequests;
    private KeyRing keyring;
    private AvailableList packages;
    private SimpleUniverse universe;
    private File directory;

    public ServletRequestHandler(File file) {
        SimpleUniverse simpleUniverse;
        this.directory = file;
        Universe universe = (Universe)this.loadXML("universe", new $anonfun$1(this), new $anonfun$0(this));
        if (!(universe instanceof SimpleUniverse)) {
            throw new Error("this universe is not a simple universe");
        }
        this.universe = simpleUniverse = (SimpleUniverse)universe;
        this.packages = (AvailableList)this.loadXML("packages", new $anonfun$3(this), new $anonfun$2(this));
        this.keyring = (KeyRing)this.loadXML("keyring", new $anonfun$5(this), new $anonfun$4(this));
        this.keylessRequests = (List)this.loadXML("keylessRequests", new $anonfun$9(this), new $anonfun$8(this));
        Console$.MODULE$.println((Object)("requests needing no key are: " + this.keylessRequests()));
    }

    public final List fromXML$0(Node node) {
        return node.child().toList().filter((Function1)new $anonfun$6(this)).map((Function1)new $anonfun$7(this));
    }

    public Message handleRequest(Message message) {
        ServletRequestHandler servletRequestHandler = this;
        synchronized (servletRequestHandler) {
            Message message2;
            Message message3 = message.sansKeys();
            List list = message.authKeys().filter((Function1)new $anonfun$11(this));
            if (!this.keylessRequests().exists((Function1)new $anonfun$12(this, message3)) && !list.exists((Function1)new $anonfun$13(this, message3))) {
                message2 = new NotOK("Permission denied");
            } else {
                Message message4;
                Message message5 = message3;
                if (!(message5 instanceof SendPackageList)) {
                    if (!(message5 instanceof AddPackage)) {
                        if (!(message5 instanceof RemovePackage)) {
                            if (!(message5 instanceof KeyCreate)) {
                                if (!(message5 instanceof KeyRevoke)) {
                                    message4 = message5 != SendKeyList$.MODULE$ ? new NotOK("unhandled message type.  full message: " + message3) : new KeyList(this.keyring().keys());
                                } else {
                                    this.keyring().removeKey(((KeyRevoke)message5).key());
                                    this.saveKeyring();
                                    message4 = new OK();
                                }
                            } else {
                                KeyCreate keyCreate = (KeyCreate)message5;
                                MessagePattern messagePattern = keyCreate.messages();
                                String string = keyCreate.description();
                                String string2 = KeyUtil$.MODULE$.genKeyData();
                                Key key = new Key(messagePattern, string, string2);
                                this.keyring().addKey(key);
                                this.saveKeyring();
                                message4 = new KeyCreated(key);
                            }
                        } else {
                            RemovePackage removePackage = (RemovePackage)message5;
                            PackageSpec packageSpec = removePackage.spec();
                            Console$.MODULE$.println((Object)("removing package: " + packageSpec));
                            List list2 = this.packages().available().filter((Function1)new $anonfun$15(this, packageSpec));
                            this.packages_$eq(new AvailableList(list2));
                            this.savePackages();
                            message4 = new OK();
                        }
                    } else {
                        AddPackage addPackage = (AddPackage)message5;
                        AvailablePackage availablePackage = addPackage.pack();
                        Console$.MODULE$.println((Object)("adding new package: " + availablePackage));
                        List list3 = this.packages().available().filter((Function1)new $anonfun$14(this, availablePackage));
                        AvailablePackage availablePackage2 = availablePackage;
                        List list4 = list3.$colon$colon((Object)availablePackage2);
                        this.packages_$eq(new AvailableList(list4));
                        this.savePackages();
                        message4 = new OK();
                    }
                } else {
                    message4 = new LatestPackages(this.packages());
                }
                message2 = message4;
            }
            return message2;
        }
    }

    public String responseForGET() {
        ServletRequestHandler servletRequestHandler = this;
        synchronized (servletRequestHandler) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write("This is a Scala Bazaar.  The bazaar descriptor is:\n");
            stringWriter.write(this.universe().toXML().toString());
            stringWriter.write("\n\n");
            stringWriter.write("The packages included are:\n");
            this.packages().sortedSpecs().foreach((Function1)new $anonfun$10(this, stringWriter));
            return stringWriter.toString();
        }
    }

    public List keylessRequests() {
        return this.keylessRequests;
    }

    public boolean saveKeyring() {
        return this.saveXML(this.keyring().toXML(), "keyring");
    }

    public KeyRing keyring() {
        return this.keyring;
    }

    public boolean savePackages() {
        return this.saveXML((Node)this.packages().toXML(), "packages");
    }

    public void packages_$eq(AvailableList availableList) {
        this.packages = availableList;
    }

    public AvailableList packages() {
        return this.packages;
    }

    public SimpleUniverse universe() {
        return this.universe;
    }

    private boolean saveXML(Node node, String string) {
        File file = new File(this.directory, string + ".tmp");
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(node.toString());
        fileWriter.close();
        return this.renameFile(file, new File(this.directory, string));
    }

    private boolean renameFile(File file, File file2) {
        file2.delete();
        return file.renameTo(file2);
    }

    public Object loadXML(String string, Function1 function1, Function0 function0) {
        Object object;
        File file = new File(this.directory, string);
        if (!file.exists()) {
            object = function0.apply();
        } else {
            Elem elem = XML$.MODULE$.load(file.getAbsolutePath());
            object = function1.apply((Object)elem);
        }
        return object;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

