/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2005-2007, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: Reaction.scala 9716 2007-01-24 09:54:06Z phaller $


package scala.actors

import java.lang.{InterruptedException, Runnable}

class ExitActorException extends Throwable

/**
 * The abstract class <code>Reaction</code> associates
 * an instance of an <code>Actor</code> with a
 * <code>java.lang.Runnable</code>.
 *
 * @version 0.9.2
 * @author Philipp Haller
 */
private[actors] class Reaction(a: Actor,
                               f: PartialFunction[Any, Unit],
                               msg: Any) extends Runnable {
  def this(a: Actor) = this(a, null, null)

  def actor = a

  def run(): Unit = {
    /*val t = currentThread
    val saved = Actor.selfs.get(t).asInstanceOf[Actor]
    Actor.selfs.put(t, a)*/
    val saved = Actor.tl.get.asInstanceOf[Actor]
    Actor.tl.set(a)
    Scheduler.unPendReaction
    a.isDetached = false
    try {
      try {
        // links
        if (a.shouldExit)
          a.exit()
        else {
          if (f == null)
            a.act()
          else
            f(msg)
          a.exit()
        }
      } catch {
        case _: ExitActorException =>
      }
    }
    catch {
      case _: SuspendActorException => {
        // do nothing (continuation is already saved)
      }
      case _: Throwable => {
        // links
        if (!a.links.isEmpty) {
          a.exitLinked()
        }
      }
    }
    /*finally {
      //Actor.selfs.put(t, saved)
      Actor.tl.set(saved)
    }*/
    Actor.tl.set(saved)
  }

}
