/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import scala.MatchError;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.actors.remote.Node;
import scala.actors.remote.TcpService;
import scala.runtime.BoxedUnit;

public class TcpServiceWorker
extends Thread
implements ScalaObject {
    private boolean running;
    private Node connectedNode;
    private PrintWriter writer;
    private BufferedReader reader;
    private DataOutputStream dataout;
    private DataInputStream datain;
    private OutputStream out;
    private InputStream in;
    private Socket so;
    private TcpService parent;

    public TcpServiceWorker(TcpService tcpService, Socket socket) {
        this.parent = tcpService;
        this.so = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.datain = new DataInputStream(this.in());
        this.dataout = new DataOutputStream(this.out());
        this.reader = new BufferedReader(new InputStreamReader(this.in()));
        this.writer = new PrintWriter(new OutputStreamWriter(this.out()));
        this.running = true;
    }

    public void run() {
        try {
            while (this.running()) {
                if (this.in().available() <= 0) continue;
                Object object = this.parent.serializer().readObject(this.datain());
                this.parent.kernel().processMsg(this.connectedNode(), object);
            }
        }
        catch (Exception exception) {
            this.parent.nodeDown(this.connectedNode());
        }
        catch (IOException iOException) {
            this.parent.nodeDown(this.connectedNode());
        }
    }

    public void halt() {
        TcpServiceWorker tcpServiceWorker = this;
        synchronized (tcpServiceWorker) {
            this.so.close();
            this.running_$eq(false);
            return;
        }
    }

    public void running_$eq(boolean bl) {
        this.running = bl;
    }

    public boolean running() {
        return this.running;
    }

    public void transmit(byte[] byArray) {
        TcpServiceWorker tcpServiceWorker = this;
        synchronized (tcpServiceWorker) {
            this.dataout().writeInt(byArray.length);
            this.dataout().write(byArray);
            this.dataout().flush();
            return;
        }
    }

    public void readNode() {
        Node node;
        Object object = this.parent.serializer().readObject(this.datain());
        Object object2 = object;
        if (!(object2 instanceof Node)) {
            throw new MatchError(object2);
        }
        Node node2 = node = (Node)object2;
        this.connectedNode_$eq(node2);
        this.parent.addConnection(node2, this);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void sendNode(Node node) {
        this.connectedNode_$eq(node);
        this.parent.serializer().writeObject(this.dataout(), this.parent.node());
    }

    public void connectedNode_$eq(Node node) {
        this.connectedNode = node;
    }

    public Node connectedNode() {
        return this.connectedNode;
    }

    public PrintWriter writer() {
        return this.writer;
    }

    public BufferedReader reader() {
        return this.reader;
    }

    public DataOutputStream dataout() {
        return this.dataout;
    }

    public DataInputStream datain() {
        return this.datain;
    }

    public OutputStream out() {
        return this.out;
    }

    public InputStream in() {
        return this.in;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

