/*
 * Decompiled with CFR 0.152.
 */
package sbaz;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sbaz.AvailableList;
import sbaz.AvailablePackage;
import sbaz.DependencyError;
import sbaz.Downloader;
import sbaz.EmptyUniverse;
import sbaz.Filename;
import sbaz.InstalledEntry;
import sbaz.InstalledList;
import sbaz.ManagedDirectory$;
import sbaz.Package;
import sbaz.ProposedChanges;
import sbaz.Universe;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedInt;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.xml.Node;
import scala.xml.XML$;

public class ManagedDirectory
implements ScalaObject {
    private static /* synthetic */ Class class$Cache0;
    private Universe universe;
    private InstalledList installed;
    private AvailableList available;
    private Downloader downloader;
    private File old_meta_dir;
    private File meta_dir;
    private File directory;

    public ManagedDirectory(File file) {
        this.directory = file;
        this.meta_dir = new File(file, "meta");
        this.old_meta_dir = new File(file, "scbaz");
        if (!this.meta_dir().isDirectory() && !this.old_meta_dir().isDirectory()) {
            throw new Error("Directory " + file + " does not appear to be a sbaz-managed directory");
        }
        if (this.old_meta_dir().exists() && !this.meta_dir().exists()) {
            this.old_meta_dir().renameTo(this.meta_dir());
        }
        this.downloader = new Downloader(new File(this.meta_dir(), "cache"));
        this.available = (AvailableList)this.loadXML("available", new $anonfun$0(this), new AvailableList((List)Nil$.MODULE$));
        this.installed = (InstalledList)this.loadXML("installed", new $anonfun$1(this), new InstalledList());
        this.universe = (Universe)this.loadXML("universe", new $anonfun$2(this), new EmptyUniverse());
        this.universe().keyringFilesAreIn(this.meta_dir());
    }

    private final void lp$1(InputStream inputStream, FileOutputStream fileOutputStream) {
        byte[] byArray;
        int n;
        while ((n = inputStream.read(byArray = new byte[100])) >= 0) {
            fileOutputStream.write(byArray, 0, n);
        }
        return;
    }

    public String toString() {
        return "(" + this.directory().toString() + ": " + BoxedInt.box((int)this.installed().size()) + "/" + BoxedInt.box((int)this.available().numPackages()) + " packages)";
    }

    public void compact() {
        this.downloader().flushCache();
    }

    public boolean updateAvailable() {
        this.available_$eq(this.universe().retrieveAvailable());
        return this.saveAvailable();
    }

    private void downloadURL(URL uRL, File file) {
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.lp$1(inputStream, fileOutputStream);
        fileOutputStream.close();
    }

    public boolean sbaz$ManagedDirectory$$removeNoCheck(InstalledEntry installedEntry) {
        this.removeEntryFiles(installedEntry);
        this.installed().remove(installedEntry.packageSpec());
        return this.saveInstalled();
    }

    public boolean remove(InstalledEntry installedEntry) {
        if (!this.installed().anyDependOn(installedEntry.name())) {
            return this.sbaz$ManagedDirectory$$removeNoCheck(installedEntry);
        }
        throw new DependencyError("Package " + installedEntry.name() + " is still needed");
    }

    private void removeEntryFiles(InstalledEntry installedEntry) {
        List list = installedEntry.files().map((Function1)new $anonfun$17(this));
        List list2 = list.sort((Function2)new $anonfun$18(this));
        list2.filter((Function1)new $anonfun$19(this)).foreach((Function1)new $anonfun$20(this));
    }

    public void install(File file) {
        this.makeChanges((Seq)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new ProposedChanges.AdditionFromFile[]{new ProposedChanges.AdditionFromFile(file)})));
    }

    public void install(AvailablePackage availablePackage) {
        this.makeChanges((Seq)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new ProposedChanges.AdditionFromNet[]{new ProposedChanges.AdditionFromNet(availablePackage)})));
    }

    public void installNoCheck(Package package_, File file) {
        ZipFile zipFile = new ZipFile(file);
        List list = this.mkList(zipFile.entries());
        List list2 = list.filter((Function1)new $anonfun$11(this));
        list2.filter((Function1)new $anonfun$12(this)).foreach((Function1)new $anonfun$13(this, package_));
        List list3 = list2.map((Function1)new $anonfun$16(this));
        InstalledEntry installedEntry = new InstalledEntry(package_, list3);
        Option option = this.installed().entryNamed(package_.name());
        if (option != None$.MODULE$) {
            if (!(option instanceof Some)) {
                throw new MatchError((Object)option);
            }
            this.removeEntryFiles((InstalledEntry)((Some)option).x());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.extractFiles(zipFile, list2, this.directory());
        this.installed().add(installedEntry);
        this.saveInstalled();
        zipFile.close();
    }

    public void extractFiles(ZipFile zipFile, List list, File file) {
        list.foreach((Function1)new $anonfun$10(this, zipFile, file));
    }

    private List mkList(Enumeration enumeration) {
        Nil$ nil$ = Nil$.MODULE$;
        while (enumeration.hasMoreElements()) {
            Object e;
            Object e2 = e = enumeration.nextElement();
            nil$ = nil$.$colon$colon(e2);
        }
        return nil$.reverse();
    }

    public void makeChanges(Seq seq) {
        if (!this.installed().changesAcceptible(seq)) {
            throw new DependencyError();
        }
        seq.elements().filter((Function1)new $anonfun$4(this)).foreach((Function1)new $anonfun$5(this));
        seq.elements().filter((Function1)new $anonfun$6(this)).foreach((Function1)new $anonfun$7(this));
        seq.elements().foreach((Function1)new $anonfun$9(this));
    }

    public Object sbaz$ManagedDirectory$$makeExecutable(File file) {
        Object object;
        try {
            Object object2 = ScalaRunTime$.MODULE$.arrayValue(Array$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{"chmod", "+x", file.getPath()})), ManagedDirectory.class$Method0());
            object = Runtime.getRuntime().exec((String[])(!(object2 instanceof BoxedArray) ? object2 : ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object2, ManagedDirectory.class$Method0())));
        }
        catch (IOException iOException) {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public Filename sbaz$ManagedDirectory$$zipToFilename(ZipEntry zipEntry) {
        List list = new BoxedObjectArray((Object[])zipEntry.getName().split("/")).toList().filter((Function1)new $anonfun$3(this));
        return new Filename(!zipEntry.isDirectory(), true, list);
    }

    public File sbaz$ManagedDirectory$$download(AvailablePackage availablePackage) {
        String string = availablePackage.name() + "-" + availablePackage.version() + ".sbp";
        if (!this.downloader().is_downloaded(string)) {
            this.downloader().download(availablePackage.link(), string);
        }
        return new File(this.downloader().dir(), string);
    }

    public boolean setUniverse(Universe universe) {
        this.clearAvailable();
        this.universe_$eq(universe);
        return this.saveUniverse();
    }

    private boolean clearAvailable() {
        this.available_$eq(new AvailableList((List)Nil$.MODULE$));
        return new File(this.meta_dir(), "available").delete();
    }

    private boolean saveUniverse() {
        return this.saveXML(this.universe().toXML(), "universe");
    }

    public void universe_$eq(Universe universe) {
        this.universe = universe;
    }

    public Universe universe() {
        return this.universe;
    }

    private boolean saveInstalled() {
        return this.saveXML(this.installed().toXML(), "installed");
    }

    public InstalledList installed() {
        return this.installed;
    }

    private boolean saveAvailable() {
        return this.saveXML((Node)this.available().toXML(), "available");
    }

    public void available_$eq(AvailableList availableList) {
        this.available = availableList;
    }

    public AvailableList available() {
        return this.available;
    }

    private boolean saveXML(Node node, String string) {
        File file = new File(this.meta_dir(), string + ".tmp");
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(node.toString());
        fileWriter.close();
        return this.renameFile(file, new File(this.meta_dir(), string));
    }

    private Object loadXML(String string, Function1 function1, Object object) {
        File file = new File(this.meta_dir(), string);
        return !file.exists() ? object : function1.apply((Object)XML$.MODULE$.load(file.getAbsolutePath()));
    }

    private boolean renameFile(File file, File file2) {
        file2.delete();
        return file.renameTo(file2);
    }

    public Downloader downloader() {
        return this.downloader;
    }

    public File old_meta_dir() {
        return this.old_meta_dir;
    }

    public File meta_dir() {
        return this.meta_dir;
    }

    public ManagedDirectory(File file, File file2) {
        this(file);
    }

    public File directory() {
        return this.directory;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }

    private static /* synthetic */ Class class$Method0() {
        if (class$Cache0 == null) {
            class$Cache0 = Class.forName("java.lang.String");
        }
        return class$Cache0;
    }
}

