/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function1$class;
import scala.Function2;
import scala.Iterable;
import scala.Iterable$class;
import scala.Iterator;
import scala.List;
import scala.Option;
import scala.Ordered;
import scala.PartialFunction;
import scala.PartialFunction$class;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Seq;
import scala.Seq$class;
import scala.collection.mutable.PriorityQueue$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.ResizableArray;
import scala.collection.mutable.ResizableArray$class;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedNumber;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PriorityQueue
implements ResizableArray,
ScalaObject,
Serializable,
Cloneable {
    private int size;
    private BoxedArray array;
    private int initialSize;
    private Function1 view$0;

    public PriorityQueue(Function1 function1) {
        this.view$0 = function1;
        Function1$class.$init$(this);
        PartialFunction$class.$init$(this);
        Iterable$class.$init$(this);
        Seq$class.$init$(this);
        ResizableArray$class.$init$(this);
        this.size_$eq(this.size() + 1);
    }

    public Object clone() {
        return this.clone();
    }

    public Object apply(Object object) {
        Object object2 = object;
        return this.apply(object2 == null ? 0 : ((BoxedNumber)object2).intValue());
    }

    public boolean isDefinedAt(Object object) {
        Object object2 = object;
        return this.isDefinedAt(object2 == null ? 0 : ((BoxedNumber)object2).intValue());
    }

    public PriorityQueue clone() {
        PriorityQueue priorityQueue = new PriorityQueue(this.view$0);
        priorityQueue.$plus$plus$eq(this);
        return priorityQueue;
    }

    public String toString() {
        return this.toList().mkString("PriorityQueue(", ", ", ")");
    }

    public Queue toQueue() {
        Queue queue = new Queue();
        queue.$plus$plus$eq(this);
        return queue;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("unsuitable as hash key");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof PriorityQueue)) return false;
        PriorityQueue priorityQueue = (PriorityQueue)object;
        if (((Iterator)this.elements().zip(priorityQueue.elements())).forall(new $anonfun$1(this))) return true;
        return false;
    }

    public Iterator elements() {
        return new $anon$0(this);
    }

    public void clear() {
        this.size_$eq(1);
    }

    public Object max() {
        if (this.size() <= 1) {
            throw new NoSuchElementException("queue is empty");
        }
        return this.array().apply(1);
    }

    public Object dequeue() {
        if (this.size() <= 1) {
            throw new NoSuchElementException("no element to remove from heap");
        }
        this.size_$eq(this.size() - 1);
        this.swap(1, this.size());
        this.fixDown(this.array(), 1, this.size() - 1);
        return this.array().apply(this.size());
    }

    public void enqueue(Seq seq) {
        this.$plus$plus$eq(seq);
    }

    public void $plus$plus$eq(Iterator iterator) {
        iterator.foreach(new $anonfun$0(this));
    }

    public void $plus$plus$eq(Iterable iterable) {
        this.$plus$plus$eq(iterable.elements());
    }

    public void $plus$eq(Object object) {
        this.ensureSize(this.size() + 1);
        this.array().update(this.size(), object);
        this.fixUp(this.array(), this.size());
        this.size_$eq(this.size() + 1);
    }

    public boolean isEmpty() {
        return this.size() < 2;
    }

    public void fixDown(BoxedArray boxedArray, int n, int n2) {
        int n3 = n;
        boolean bl = true;
        while (bl && n2 >= 2 * n3) {
            int n4 = 2 * n3;
            if (n4 < n2 && ((Ordered)this.view$0.apply(boxedArray.apply(n4))).$less(boxedArray.apply(n4 + 1))) {
                ++n4;
            }
            if (!((Ordered)this.view$0.apply(boxedArray.apply(n3))).$less(boxedArray.apply(n4))) {
                bl = false;
                continue;
            }
            Object object = boxedArray.apply(n3);
            boxedArray.update(n3, boxedArray.apply(n4));
            boxedArray.update(n4, object);
            n3 = n4;
        }
        return;
    }

    public void fixUp(BoxedArray boxedArray, int n) {
        int n2 = n;
        while (n2 > 1 && ((Ordered)this.view$0.apply(boxedArray.apply(n2 / 2))).$less(boxedArray.apply(n2))) {
            this.swap(n2, n2 / 2);
            n2 /= 2;
        }
        return;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }

    public Function1 compose(Function1 function1) {
        return Function1$class.compose(this, function1);
    }

    public Object andThen(Function1 function1) {
        return PartialFunction$class.andThen(this, function1);
    }

    public Object orElse(PartialFunction partialFunction) {
        return PartialFunction$class.orElse(this, partialFunction);
    }

    public List toList() {
        return Iterable$class.toList(this);
    }

    public boolean sameElements(Iterable iterable) {
        return Iterable$class.sameElements(this, iterable);
    }

    public Object $colon$bslash(Object object, Function2 function2) {
        return Iterable$class.$colon$bslash(this, object, function2);
    }

    public Object $div$colon(Object object, Function2 function2) {
        return Iterable$class.$div$colon(this, object, function2);
    }

    public Object foldRight(Object object, Function2 function2) {
        return Iterable$class.foldRight(this, object, function2);
    }

    public Object foldLeft(Object object, Function2 function2) {
        return Iterable$class.foldLeft(this, object, function2);
    }

    public int indexOf(Object object) {
        return Iterable$class.indexOf(this, object);
    }

    public int findIndexOf(Function1 function1) {
        return Iterable$class.findIndexOf(this, function1);
    }

    public Option find(Function1 function1) {
        return Iterable$class.find(this, function1);
    }

    public boolean exists(Function1 function1) {
        return Iterable$class.exists(this, function1);
    }

    public boolean forall(Function1 function1) {
        return Iterable$class.forall(this, function1);
    }

    public void foreach(Function1 function1) {
        Iterable$class.foreach(this, function1);
    }

    public Iterable concat(Iterable iterable) {
        return Iterable$class.concat(this, iterable);
    }

    public String stringPrefix() {
        return Seq$class.stringPrefix(this);
    }

    public String mkString(String string, String string2, String string3) {
        return Seq$class.mkString(this, string, string2, string3);
    }

    public BoxedArray copyToArray(BoxedArray boxedArray, int n) {
        return Seq$class.copyToArray(this, boxedArray, n);
    }

    public Seq subseq(int n, int n2) {
        return Seq$class.subseq(this, n, n2);
    }

    public Seq drop(int n) {
        return Seq$class.drop(this, n);
    }

    public Seq take(int n) {
        return Seq$class.take(this, n);
    }

    public int lastIndexOf(Object object) {
        return Seq$class.lastIndexOf(this, object);
    }

    public boolean isDefinedAt(int n) {
        return Seq$class.isDefinedAt(this, n);
    }

    public Seq concat(Seq seq) {
        return Seq$class.concat(this, seq);
    }

    public void copy(int n, int n2, int n3) {
        ResizableArray$class.copy(this, n, n2, n3);
    }

    public void swap(int n, int n2) {
        ResizableArray$class.swap(this, n, n2);
    }

    public void ensureSize(int n) {
        ResizableArray$class.ensureSize(this, n);
    }

    public BoxedArray toArray() {
        return ResizableArray$class.toArray(this);
    }

    public Object apply(int n) {
        return ResizableArray$class.apply(this, n);
    }

    public int length() {
        return ResizableArray$class.length(this);
    }

    public final void initialSize_$eq(int n) {
        this.initialSize = n;
    }

    public final void size_$eq(int n) {
        this.size = n;
    }

    public final int size() {
        return this.size;
    }

    public final void array_$eq(BoxedArray boxedArray) {
        this.array = boxedArray;
    }

    public final BoxedArray array() {
        return this.array;
    }

    public final int initialSize() {
        return this.initialSize;
    }
}

