/*
 * Decompiled with CFR 0.152.
 */
package sbaz.clui.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sbaz.AvailablePackage;
import sbaz.Package;
import sbaz.PackageUtil$;
import sbaz.Version;
import sbaz.VersionUtil$;
import sbaz.clui.Command;
import sbaz.clui.Settings;
import sbaz.clui.commands.Pack;
import sbaz.clui.commands.Pack$;
import scala.;
import scala.Console$;
import scala.Function1;
import scala.Function2;
import scala.Iterable;
import scala.List;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.immutable.ListSet;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class Pack$
extends Command
implements ScalaObject {
    public static final Pack$ MODULE$;
    private String fullHelp = "pack name directory [options]\n\nOptions (defaults):\n  --version version (0.0)\n  --description description (no description)\n  --descfile description-file (no description)\n  --depends dependencies seperated by a comma (none)\n  --outdir directory (current directory)\n  --linkbase url (none)\n\nCreate an sbaz package and, if a link base is specified, an\nadvertisement file.  The package file is named name-version.sbp.\nThe advertisement file is named name-version.advert.  The URL\nin the advertisement file is the URL base with the package\nfilename appended.\n";
    private String oneLineHelp = "create an sbaz package";
    private String name = "pack";

    static {
        Pack$ pack$ = new Pack$();
    }

    public Pack$() {
        MODULE$ = this;
    }

    public final void lp$0(File file, String string, Function2 function2) {
        function2.apply((Object)file, (Object)string);
        if (file.isDirectory()) {
            new BoxedObjectArray((Object[])file.listFiles()).toList().foreach((Function1)new anonfun.0(function2, string));
        }
    }

    public void run(List list, Settings settings) {
        Pack.Settings settings2 = this.parseArguments(list);
        Option option = PackageUtil$.MODULE$.checkName(settings2.name());
        if (!(option instanceof Some)) {
            if (option != None$.MODULE$) {
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Some some = (Some)option;
            String string = (String)some.x();
            Console$.MODULE$.println((Object)("Warning: " + string));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Option option2 = VersionUtil$.MODULE$.check(settings2.version().toString());
        if (!(option2 instanceof Some)) {
            if (option2 != None$.MODULE$) {
                throw new MatchError((Object)option2);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Some some = (Some)option2;
            String string = (String)some.x();
            Console$.MODULE$.println((Object)("Warning: " + string));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        try {
            this.writeSBP(settings, settings2);
            if (!settings2.linkBase().isEmpty()) {
                this.writeAdvert(settings, settings2);
            }
            return;
        }
        catch (IOException iOException) {
            Console$.MODULE$.println((Object)iOException);
            Predef$.MODULE$.exit(2);
            return;
        }
    }

    public void writeAdvert(Settings settings, Pack.Settings settings2) {
        String string = (String)settings2.linkBase().get() + settings2.name() + "-" + settings2.version() + ".sbp";
        File file = new File(settings2.name() + "-" + settings2.version() + ".advert");
        if (settings.verbose()) {
            Console$.MODULE$.println((Object)("writing " + file + "..."));
        }
        AvailablePackage availablePackage = new AvailablePackage(this.packageFor(settings2), new URL(string));
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(availablePackage.toXML().toString());
        fileWriter.close();
    }

    public void writeSBP(Settings settings, Pack.Settings settings2) {
        String string = settings2.name() + "-" + settings2.version() + ".sbp";
        File file = new File(settings2.outdir(), string);
        if (settings.verbose()) {
            Console$.MODULE$.println((Object)("Writing " + file + "..."));
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        this.withDirTree(settings2.packdir(), new anonfun.1(settings, zipOutputStream));
        if (settings.verbose()) {
            Console$.MODULE$.println((Object)"Writing meta/description");
        }
        zipOutputStream.putNextEntry(new ZipEntry("meta/description"));
        zipOutputStream.write(this.packageFor(settings2).toXML().toString().getBytes());
        zipOutputStream.closeEntry();
        zipOutputStream.close();
        if (settings.verbose()) {
            Console$.MODULE$.println((Object)("Finished with " + file + "."));
        }
    }

    public Package packageFor(Pack.Settings settings) {
        return new Package(settings.name(), settings.version(), new ListSet().incl((Iterable)settings.depends()), settings.description());
    }

    public void copyFile(File file, OutputStream outputStream) {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = fileInputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public void withDirTree(File file, Function2 function2) {
        this.lp$0(file, "", function2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pack.Settings parseArguments(List list) {
        .colon.colon colon2;
        ObjectRef objectRef;
        ObjectRef objectRef2;
        ObjectRef objectRef3;
        ObjectRef objectRef4;
        ObjectRef objectRef5;
        ObjectRef objectRef6;
        ObjectRef objectRef7;
        List list2;
        block8: {
            block7: {
                list2 = list;
                objectRef7 = new ObjectRef(null);
                objectRef6 = new ObjectRef(null);
                objectRef5 = new ObjectRef(null);
                objectRef4 = new ObjectRef((Object)None$.MODULE$);
                objectRef3 = new ObjectRef((Object)new Version("0.0"));
                objectRef2 = new ObjectRef((Object)"(no description)");
                objectRef = new ObjectRef((Object)Nil$.MODULE$);
                List list3 = list;
                if (!(list3 instanceof .colon.colon)) break block7;
                colon2 = (.colon.colon)list3;
                if (colon2.tl$0() instanceof .colon.colon) break block8;
            }
            this.usageExit();
            return null;
        }
        .colon.colon colon3 = (.colon.colon)colon2.tl$0();
        String string2 = (String)colon2.hd();
        String string3 = (String)colon3.hd();
        List list4 = colon3.tl$0();
        objectRef7.elem = string2;
        objectRef6.elem = new File(string3);
        list2 = list4;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        while (true) {
            BoxedUnit boxedUnit2;
            .colon.colon colon4;
            block10: {
                block11: {
                    block12: {
                        block13: {
                            block14: {
                                block15: {
                                    block9: {
                                        List list3 = list2;
                                        Object object = Nil$.MODULE$;
                                        if (!(list3 != null ? !list3.equals(object) : object != null)) break;
                                        List list5 = list2;
                                        if (!(list5 instanceof .colon.colon)) break block9;
                                        colon4 = (.colon.colon)list5;
                                        Object object2 = colon4.hd();
                                        object = "--version";
                                        if (object2 != null && object2.equals(object) && colon4.tl$0() instanceof .colon.colon) break block10;
                                        Object object3 = colon4.hd();
                                        object = "--description";
                                        if (object3 != null && object3.equals(object) && colon4.tl$0() instanceof .colon.colon) break block11;
                                        Object object4 = colon4.hd();
                                        object = "--descfile";
                                        if (object4 != null && object4.equals(object) && colon4.tl$0() instanceof .colon.colon) break block12;
                                        Object object5 = colon4.hd();
                                        object = "--depends";
                                        if (object5 != null && object5.equals(object) && colon4.tl$0() instanceof .colon.colon) break block13;
                                        Object object6 = colon4.hd();
                                        object = "--outdir";
                                        if (object6 != null && object6.equals(object) && colon4.tl$0() instanceof .colon.colon) break block14;
                                        Object object7 = colon4.hd();
                                        object = "--linkbase";
                                        if (object7 == null || !object7.equals(object)) break block9;
                                        if (colon4.tl$0() instanceof .colon.colon) break block15;
                                    }
                                    this.usageExit();
                                    return null;
                                }
                                .colon.colon colon5 = (.colon.colon)colon4.tl$0();
                                String string4 = (String)colon5.hd();
                                List list7 = colon5.tl$0();
                                objectRef4.elem = new Some((Object)string4);
                                list2 = list7;
                                boxedUnit2 = BoxedUnit.UNIT;
                                continue;
                            }
                            .colon.colon colon6 = (.colon.colon)colon4.tl$0();
                            String string5 = (String)colon6.hd();
                            List list8 = colon6.tl$0();
                            objectRef5.elem = new File(string5);
                            list2 = list8;
                            boxedUnit2 = BoxedUnit.UNIT;
                            continue;
                        }
                        .colon.colon colon7 = (.colon.colon)colon4.tl$0();
                        String string6 = (String)colon7.hd();
                        List list9 = colon7.tl$0();
                        objectRef.elem = new BoxedObjectArray((Object[])string6.split(",")).toList();
                        list2 = list9;
                        boxedUnit2 = BoxedUnit.UNIT;
                        continue;
                    }
                    .colon.colon colon8 = (.colon.colon)colon4.tl$0();
                    String string = (String)colon8.hd();
                    List list10 = colon8.tl$0();
                    try {
                        objectRef2.elem = this.readFile(string);
                        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                        list2 = list10;
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    catch (IOException iOException) {
                        Console$.MODULE$.println((Object)("Error reading " + string + ": " + iOException));
                        Predef$.MODULE$.exit(1);
                        return null;
                    }
                }
                .colon.colon colon9 = (.colon.colon)colon4.tl$0();
                String string7 = (String)colon9.hd();
                List list11 = colon9.tl$0();
                objectRef2.elem = string7;
                list2 = list11;
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            .colon.colon colon10 = (.colon.colon)colon4.tl$0();
            String string8 = (String)colon10.hd();
            List list12 = colon10.tl$0();
            objectRef3.elem = new Version(string8);
            list2 = list12;
            boxedUnit2 = BoxedUnit.UNIT;
        }
        return new anon.0(objectRef7, objectRef6, objectRef5, objectRef4, objectRef3, objectRef2, objectRef);
    }

    public String readFile(String string) {
        FileReader fileReader = new FileReader(string);
        char[] cArray = new char[1024];
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((n = fileReader.read(cArray)) >= 0) {
            stringBuffer.append(cArray, 0, n);
        }
        fileReader.close();
        return stringBuffer.toString();
    }

    public String fullHelp() {
        return this.fullHelp;
    }

    public String oneLineHelp() {
        return this.oneLineHelp;
    }

    public String name() {
        return this.name;
    }
}

