/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2006, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: CharacterVarying.scala 5889 2006-03-05 00:33:02 +0000 (Sun, 05 Mar 2006) mihaylov $


package scala.dbc.datatype;


/** A SQL type for a varying length string of characters with arbitrary
 *  maximal length and arbitrary character set.
 */
abstract class CharacterVarying extends CharacterString {
  
  def isEquivalent(datatype: DataType) = datatype match {
    case dt: CharacterVarying =>
      length == dt.length && encoding == dt.encoding
    case _ =>
      false
  }

  def isSubtypeOf(datatype: DataType) = datatype match {
    case dt: CharacterVarying =>
      length >= dt.length && encoding == dt.encoding
    case _ =>
      false
  }
  
  /** The maximal length of the string defined in characters. */
  def length: Int;

  /** A SQL-99 compliant string representation of the type. */
  override def sqlString: java.lang.String =
    "CHARACTER VARYING (" + length.toString() + ")";

}
