/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.reporters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import scala.Console$;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.compat.StringBuilder;
import scala.runtime.BoxedInt;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.reporters.AbstractReporter;
import scala.tools.nsc.reporters.Reporter;
import scala.tools.nsc.util.FakePos;
import scala.tools.nsc.util.Position;
import scala.tools.nsc.util.Position$;

public class ConsoleReporter
extends AbstractReporter
implements ScalaObject {
    private boolean shortname;
    private PrintWriter writer;
    private BufferedReader reader;

    public ConsoleReporter(BufferedReader bufferedReader, PrintWriter printWriter) {
        this.reader = bufferedReader;
        this.writer = printWriter;
        this.shortname = false;
    }

    public void displayPrompt() {
        try {
            boolean bl = true;
            while (true) {
                String string;
                if (!bl) {
                    return;
                }
                this.writer.print("r)esume, a)bort: ");
                this.writer.flush();
                String string2 = string = this.reader.readLine();
                Object var4_3 = null;
                if (!(string2 != null ? !string2.equals(var4_3) : var4_3 != null)) continue;
                if ("abort".startsWith(string = string.toLowerCase())) break;
                if (!"resume".startsWith(string)) continue;
                bl = false;
            }
            throw new Error("user abort");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new Error("input read error");
        }
    }

    public void display(Position position, String string, Reporter.Severity severity) {
        this.incr(severity);
        this.print(position, string, severity);
    }

    public void printSummary() {
        if (this.warnings() > 0) {
            this.printMessage(this.getCountString(this.WARNING()) + " found");
        }
        if (this.errors() > 0) {
            this.printMessage(this.getCountString(this.ERROR()) + " found");
        }
    }

    public void printColumnMarker(Position position) {
        Position position2 = position;
        Object var2_2 = null;
        if (position2 != null ? !position2.equals(var2_2) : var2_2 != null) {
            StringBuilder stringBuilder = new StringBuilder(position.column());
            int n = 1;
            while (true) {
                if (n >= position.column()) {
                    if (position.column() > 0) {
                        stringBuilder.append('^');
                    }
                    this.printMessage(stringBuilder.toString());
                    break;
                }
                stringBuilder.append(' ');
                ++n;
            }
        }
    }

    public void printSourceLine(Position position) {
        Position position2 = position;
        Object var2_2 = null;
        if ((position2 != null ? !position2.equals(var2_2) : var2_2 != null) && position.offset() != Position$.MODULE$.NOPOS()) {
            this.printMessage(Predef$.MODULE$.stringWrapper(position.lineContent()).stripLineEnd());
            this.printColumnMarker(position);
        }
    }

    public void print(Position position, String string, Reporter.Severity severity) {
        this.printMessage(position, this.clabel(severity) + string);
    }

    public void printMessage(Position position, String string) {
        Position position2 = position;
        Object var3_3 = null;
        if (position2 != null ? !position2.equals(var3_3) : var3_3 != null) {
            StringBuilder stringBuilder;
            Position position3;
            Position position4 = position.inUltimateSource();
            StringBuilder stringBuilder2 = new StringBuilder(string);
            stringBuilder2.insert(0, " ");
            if (position4.line() != Position$.MODULE$.NOLINE()) {
                stringBuilder2.insert(0, ":" + BoxedInt.box(position4.line()));
            }
            if (!((position3 = position4) instanceof FakePos)) {
                AbstractFile abstractFile = position4.source().file();
                stringBuilder = stringBuilder2.insert(0, !this.shortname() ? abstractFile.path() : abstractFile.name());
            } else {
                stringBuilder = stringBuilder2.insert(0, ((FakePos)position3).msg());
            }
            this.printMessage(stringBuilder2.toString());
            this.printSourceLine(position4);
        } else {
            this.printMessage(string);
        }
    }

    public void printMessage(String string) {
        this.writer.println(string);
    }

    public String getCountString0(int n, String string) {
        String string2;
        switch (n) {
            default: {
                string2 = "" + BoxedInt.box(n) + " " + string + "s";
                break;
            }
            case 0: {
                string2 = "no " + string + "s";
                break;
            }
            case 1: {
                string2 = "one " + string;
                break;
            }
            case 2: {
                string2 = "two " + string + "s";
                break;
            }
            case 3: {
                string2 = "three " + string + "s";
                break;
            }
            case 4: {
                string2 = "four " + string + "s";
            }
        }
        return string2;
    }

    public String getCountString(Reporter.Severity severity) {
        return this.getCountString0(this.count(severity), this.label(severity));
    }

    public ConsoleReporter() {
        this(Console$.MODULE$.in(), new PrintWriter(Console$.MODULE$.err(), true));
    }

    public String clabel(Reporter.Severity severity) {
        String string;
        String string2 = string = this.label(severity);
        Object var3_3 = null;
        return (string2 != null ? !string2.equals(var3_3) : var3_3 != null) ? string + ": " : "";
    }

    public String label(Reporter.Severity severity) {
        String string;
        Reporter.Severity severity2 = severity;
        if (severity2 != this.ERROR()) {
            if (severity2 != this.WARNING()) {
                if (severity2 != this.INFO()) {
                    throw new MatchError(severity2);
                }
                string = null;
            } else {
                string = "warning";
            }
        } else {
            string = "error";
        }
        return string;
    }

    public void shortname_$eq(boolean bl) {
        this.shortname = bl;
    }

    public boolean shortname() {
        return this.shortname;
    }
}

