/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2006, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: Actor.scala 8912 2006-10-10 14:25:20Z emir $


package scala.concurrent

/**
 * The class <code>Actor</code> ...
 *
 * @author Martin Odersky
 * @version 1.0
 */
abstract class Actor extends Thread {
  private val in = new MailBox

  def send(msg: in.Message) = 
    in.send(msg)

  def receive[a](f: PartialFunction[in.Message, a]): a = 
    if (Thread.currentThread() == this) in.receive(f)
    else throw new IllegalArgumentException("receive called not on own process")

  def receiveWithin[a](msec: long)(f: PartialFunction[in.Message, a]): a = 
    if (Thread.currentThread() == this) in.receiveWithin(msec)(f)
    else throw new IllegalArgumentException("receiveWithin called not on own process")

  private var pid: Pid = null

  def self = {
    if (pid == null) pid = new Pid(this)
    pid
  }

  def self_= (p: Pid) = pid = p
}



