/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2006, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: Unknown.scala 5889 2006-03-05 00:33:02 +0000 (Sun, 05 Mar 2006) mihaylov $


package scala.dbc.datatype;


/** The SQL type for a truth value. */
class Unknown extends DataType {
  
  def isEquivalent(datatype: DataType) = datatype match {
    case dt: Unknown =>
      nativeTypeId == dt.nativeTypeId
    case _ =>
      false
  }

  def isSubtypeOf(datatype: DataType) = true;

  type NativeType = Object;
  val nativeTypeId = DataType.OBJECT;

  /** A SQL-99 compliant string representation of the type. */
  override def sqlString: java.lang.String =
    error("The 'UNKNOWN' data type cannot be represented.");

}
