/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Iterator;
import scala.MatchError;
import scala.None$;
import scala.Nothing$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.runtime.BoxedInt;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.io.PlainFile;
import scala.tools.nsc.io.VirtualFile;

public final class ZipArchive
extends PlainFile
implements ScalaObject {
    private DirEntry root;
    private ZipFile archive;
    private File file;

    public ZipArchive(File file, ZipFile zipFile) {
        this.archive = zipFile;
        super(file);
        ZipFile zipFile2 = zipFile;
        Object var3_3 = null;
        Predef$.MODULE$.assert(zipFile2 != null ? !zipFile2.equals(var3_3) : var3_3 != null);
    }

    private DirEntry getDir(Map map, String string) {
        DirEntry dirEntry;
        Option option = map.get(string);
        if (!(option instanceof Some)) {
            if (option != None$.MODULE$) {
                throw new MatchError(option);
            }
            int n = string.lastIndexOf(47, string.length() - 2);
            String string2 = n >= 0 ? string.substring(n + 1) : string;
            String string3 = n >= 0 ? string.substring(0, n + 1) : "/";
            DirEntry dirEntry2 = this.getDir(map, string3);
            DirEntry dirEntry3 = new DirEntry(this, string2.substring(0, string2.length() - 1), string);
            dirEntry2.entries().update(string2, dirEntry3);
            map.update(string, dirEntry3);
            dirEntry = dirEntry3;
        } else {
            dirEntry = (DirEntry)((Some)option).x();
        }
        return dirEntry;
    }

    private void load() {
        this.root_$eq(new DirEntry(this, "<root>", "/"));
        HashMap hashMap = new HashMap();
        hashMap.update("/", this.root());
        Enumeration<? extends ZipEntry> enumeration = this.archive().entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            Predef$.MODULE$.assert(zipEntry.isDirectory() == string.endsWith("/"), this.toString() + " - " + string);
            if (!zipEntry.isDirectory()) {
                int n = string.lastIndexOf(47);
                String string2 = n >= 0 ? string.substring(n + 1) : string;
                String string3 = n >= 0 ? string.substring(0, n + 1) : "/";
                DirEntry dirEntry = this.getDir(hashMap, string3);
                Predef$.MODULE$.assert(!dirEntry.entries().contains(string), this.toString() + " - " + string);
                dirEntry.entries().update(string2, new FileEntry(this, string2, string, zipEntry));
                continue;
            }
            DirEntry dirEntry = this.getDir(hashMap, string);
            ZipEntry zipEntry2 = dirEntry.entry();
            Object var6_6 = null;
            Predef$.MODULE$.assert(!(zipEntry2 != null ? !zipEntry2.equals(var6_6) : var6_6 != null), this.toString() + " - " + string);
            dirEntry.entry_$eq(zipEntry);
        }
        return;
    }

    public AbstractFile lookupName(String string, boolean bl) {
        DirEntry dirEntry = this.root();
        Object var3_3 = null;
        if (!(dirEntry == null ? var3_3 != null : !dirEntry.equals(var3_3))) {
            this.load();
        }
        return this.root().lookupName(string, bl);
    }

    public Iterator elements() {
        DirEntry dirEntry = this.root();
        Object var1_1 = null;
        if (!(dirEntry == null ? var1_1 != null : !dirEntry.equals(var1_1))) {
            this.load();
        }
        return this.root().elements();
    }

    public boolean isDirectory() {
        return true;
    }

    private void root_$eq(DirEntry dirEntry) {
        this.root = dirEntry;
    }

    private DirEntry root() {
        return this.root;
    }

    public ZipFile archive() {
        return this.archive;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public final class DirEntry
    extends Entry
    implements ScalaObject {
        public /* synthetic */ ZipArchive $outer;
        private ZipEntry entry;
        private Map entries;
        private String path;
        private String name;

        public DirEntry(ZipArchive zipArchive, String string, String string2) {
            if (zipArchive != null) {
                this.$outer = zipArchive;
                super(zipArchive, string, string2);
                this.entries = new HashMap();
                return;
            }
            throw new NullPointerException();
        }

        public InputStream read() {
            this.read();
            return null;
        }

        public /* synthetic */ ZipArchive scala$tools$nsc$io$ZipArchive$DirEntry$$$outer() {
            return this.$outer;
        }

        public AbstractFile lookupName(String string, boolean bl) {
            AbstractFile abstractFile;
            Option option = this.entries().get(!bl ? string : string + "/");
            if (!(option instanceof Some)) {
                if (option != None$.MODULE$) {
                    throw new MatchError(option);
                }
                abstractFile = null;
            } else {
                abstractFile = (AbstractFile)((Some)option).x();
            }
            return abstractFile;
        }

        public Iterator elements() {
            return this.entries().values();
        }

        public long lastModified() {
            ZipEntry zipEntry = this.entry();
            Object var1_1 = null;
            return (zipEntry != null ? !zipEntry.equals(var1_1) : var1_1 != null) ? this.entry().getTime() : super.lastModified();
        }

        public Nothing$ read() {
            throw new Error("cannot read directories");
        }

        public boolean isDirectory() {
            return true;
        }

        public void entry_$eq(ZipEntry zipEntry) {
            this.entry = zipEntry;
        }

        public ZipEntry entry() {
            return this.entry;
        }

        public Map entries() {
            return this.entries;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public final class FileEntry
    extends Entry
    implements ScalaObject {
        public /* synthetic */ ZipArchive $outer;
        private ZipEntry entry;
        private String path;
        private String name;

        public FileEntry(ZipArchive zipArchive, String string, String string2, ZipEntry zipEntry) {
            this.entry = zipEntry;
            if (zipArchive != null) {
                this.$outer = zipArchive;
                super(zipArchive, string, string2);
                return;
            }
            throw new NullPointerException();
        }

        public Option size() {
            return this.size();
        }

        public /* synthetic */ ZipArchive scala$tools$nsc$io$ZipArchive$FileEntry$$$outer() {
            return this.$outer;
        }

        public Some size() {
            return new Some(BoxedInt.box((int)this.entry().getSize()));
        }

        public InputStream read() {
            return this.scala$tools$nsc$io$ZipArchive$FileEntry$$$outer().archive().getInputStream(this.entry());
        }

        public long lastModified() {
            return this.entry().getTime();
        }

        public ZipEntry entry() {
            return this.entry;
        }
    }

    public abstract class Entry
    extends VirtualFile
    implements ScalaObject {
        public /* synthetic */ ZipArchive $outer;
        private String path;
        private String name;

        public Entry(ZipArchive zipArchive, String string, String string2) {
            if (zipArchive != null) {
                this.$outer = zipArchive;
                super(string, string2);
                return;
            }
            throw new NullPointerException();
        }

        public /* synthetic */ ZipArchive scala$tools$nsc$io$ZipArchive$Entry$$$outer() {
            return this.$outer;
        }

        public final ZipFile getArchive() {
            return this.scala$tools$nsc$io$ZipArchive$Entry$$$outer().archive();
        }

        public final String path() {
            return this.scala$tools$nsc$io$ZipArchive$Entry$$$outer().toString() + "(" + super.path() + ")";
        }
    }
}

