/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Random;
import java.util.regex.Pattern;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Nothing$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedInt;
import scala.runtime.BoxedObjectArray;
import scala.tools.nsc.CompileClient$;
import scala.tools.nsc.CompileSocket$;

public final class CompileSocket$
implements ScalaObject {
    public static final CompileSocket$ MODULE$;
    private int sleepTime;
    private int MaxAttempts;
    private File tmpDir;
    private Pattern errorPattern;
    private String errorRegex;
    private String serverClass;
    private String vmCommand;
    private String cmdName;
    private boolean isWin;
    private String dirName = "scalac-compile-server-port";

    static {
        CompileSocket$ compileSocket$ = new CompileSocket$();
    }

    public CompileSocket$() {
        String string;
        String string2;
        MODULE$ = this;
        this.isWin = System.getProperty("os.name").startsWith("Windows");
        this.cmdName = !this.isWin() ? "scala" : "scala.bat";
        String string3 = string2 = System.getProperty("scala.home");
        Object var2_2 = null;
        if (string3 != null ? !string3.equals(var2_2) : var2_2 != null) {
            String string4 = string2;
            File file = new File(new File(string4, "bin"), this.cmdName());
            string = !file.canRead() ? this.cmdName() : file.getPath();
        } else {
            string = this.cmdName();
        }
        this.vmCommand = string;
        this.serverClass = "scala.tools.nsc.CompileServer";
        this.errorRegex = ".*errors? found.*";
        this.errorPattern = Pattern.compile(this.errorRegex());
        List list = List$.MODULE$.apply(new BoxedObjectArray(new Tuple2[]{Predef$.MODULE$.Pair("scala.home", List$.MODULE$.apply(new BoxedObjectArray(new String[]{"var", "scala-devel"}))), Predef$.MODULE$.Pair("user.home", List$.MODULE$.apply(new BoxedObjectArray(new String[]{"tmp"}))), Predef$.MODULE$.Pair("java.io.tmpdir", Nil$.MODULE$)}));
        List list2 = list.map(new anonfun.1()).filter(new anonfun.2()).filter(new anonfun.3()).map(new anonfun.4());
        if (!list2.isEmpty()) {
            File file = new File((File)list2.head(), this.dirName());
            this.info("[Temp directory: " + file + "]");
            file.mkdirs();
            this.tmpDir = file;
            this.MaxAttempts = 100;
            this.sleepTime = 20;
            return;
        }
        this.fatal("Could not find a directory for port files");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Socket getsock$0(int n, String string, int n2) {
        Socket socket;
        if (n == 0) {
            this.fatal("Unable to establish connection to server; exiting");
            return null;
        }
        int n3 = this.getPort(string);
        String string2 = InetAddress.getLocalHost().getHostName();
        try {
            socket = new Socket(string2, n3);
            return socket;
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.err.println("...connection attempt to server at port " + BoxedInt.box(n3) + " failed; re-trying...");
            if (n % 2 == 0) {
                this.portFile(n3).delete();
            }
            Thread.sleep(100L);
            Socket socket2 = this.getsock$0(n - 1, string, n2);
            if (n == n2) {
                System.err.println("...connection established at port " + BoxedInt.box(n3) + "...");
            }
            socket = socket2;
        }
        return socket;
    }

    public final boolean isDirWritable$0(File file) {
        return file.isDirectory() && file.canWrite();
    }

    public final Option expand$0(Tuple2 tuple2) {
        String string;
        Tuple2 tuple22;
        Tuple2 tuple23 = tuple2;
        if (!(tuple23 instanceof Tuple2)) {
            throw new MatchError(tuple23);
        }
        Tuple2 tuple24 = tuple23;
        Tuple2 tuple25 = tuple22 = new Tuple2(tuple24._1(), tuple24._2());
        String string2 = (String)tuple25._1();
        List list = (List)tuple25._2();
        String string3 = string = System.getProperty(string2);
        Object var9_9 = null;
        if (string3 != null ? !string3.equals(var9_9) : var9_9 != null) {
            File file = (File)list.foldLeft(new File(string), new anonfun.0());
            return new Some(file);
        }
        return None$.MODULE$;
    }

    public String getPassword(int n) {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.portFile(n)));
        String string = bufferedReader.readLine();
        bufferedReader.close();
        return string;
    }

    public Socket getSocket(String string, int n) {
        try {
            return new Socket(string, n);
        }
        catch (Exception exception) {
            this.fatal("Unable to establish connection to server " + string + ":" + BoxedInt.box(n) + "; exiting");
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Socket getSocket(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            this.fatal("Malformed server address: " + string + "; exiting");
            return null;
        }
        String string2 = string.substring(0, n);
        try {
            int n2 = Integer.parseInt(string.substring(n + 1));
            return this.getSocket(string2, n2);
        }
        catch (Throwable throwable) {
            this.fatal("Malformed server address: " + string + "; exiting");
            return null;
        }
    }

    public Socket getOrCreateSocket(String string) {
        int n = 9;
        return this.getsock$0(n, string, n);
    }

    public void deletePort(int n) {
        this.portFile(n).delete();
    }

    public void setPort(int n) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(this.portFile(n)));
            printWriter.println(BoxedInt.box(new Random().nextInt()).toString());
            printWriter.close();
            return;
        }
        catch (Exception exception) {
            this.fatal("Cannot create file: " + this.portFile(n).getAbsolutePath() + "; exiting");
            return;
        }
    }

    public int getPort(String string) {
        int n = 0;
        int n2 = this.pollPort();
        if (n2 < 0) {
            this.startNewServer(string);
        }
        while (true) {
            if (n2 >= 0 || n >= this.MaxAttempts()) {
                this.info("[Port number: " + BoxedInt.box(n2) + "]");
                if (n2 >= 0) {
                    return n2;
                }
                this.fatal("Could not connect to server.");
                return 0;
            }
            ++n;
            Thread.sleep(Predef$.MODULE$.int2long(this.sleepTime()));
            n2 = this.pollPort();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int pollPort() {
        int n;
        File[] fileArray = this.tmpDir().listFiles();
        if (fileArray.length == 0) return -1;
        try {
            Predef$.MODULE$.intWrapper(1).until(fileArray.length).foreach(new anonfun.5(fileArray));
            n = Integer.parseInt(fileArray[0].getName());
        }
        catch (NumberFormatException numberFormatException) {
            this.fatal(numberFormatException.toString() + "\nbad file in temp directory: " + fileArray[0].getAbsolutePath() + "\nplease remove the file and try again");
            return 0;
        }
        return n;
    }

    public File portFile(int n) {
        return new File(this.tmpDir(), BoxedInt.box(n).toString());
    }

    private void startNewServer(String string) {
        String string2 = this.serverCommand(string);
        this.info("[Executed command: " + string2 + "]");
        try {
            Runtime.getRuntime().exec(string2);
            return;
        }
        catch (IOException iOException) {
            this.fatal("cannot start server.\ntried command: " + string2);
            return;
        }
    }

    private String serverCommand(String string) {
        return this.vmCommand() + string + " " + this.serverClass();
    }

    private int sleepTime() {
        return this.sleepTime;
    }

    private int MaxAttempts() {
        return this.MaxAttempts;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private void info(String string) {
        if (CompileClient$.MODULE$.verbose()) {
            System.out.println(string);
        }
    }

    private Nothing$ fatal(String string) {
        System.err.println(string);
        return Predef$.MODULE$.exit(1);
    }

    public Pattern errorPattern() {
        return this.errorPattern;
    }

    public String errorRegex() {
        return this.errorRegex;
    }

    private String serverClass() {
        return this.serverClass;
    }

    private String vmCommand() {
        return this.vmCommand;
    }

    private String cmdName() {
        return this.cmdName;
    }

    private boolean isWin() {
        return this.isWin;
    }

    private String dirName() {
        return this.dirName;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

