/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Some;
import scala.actors.remote.JavaSerializer;
import scala.actors.remote.NetKernel;
import scala.actors.remote.Node;
import scala.actors.remote.Serializer;
import scala.actors.remote.Service;
import scala.actors.remote.Service$class;
import scala.actors.remote.TcpServiceWorker;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedBoolean;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TcpService
extends Thread
implements Service,
ScalaObject {
    private NetKernel kernel;
    private HashMap connections;
    private Node internalNode;
    private JavaSerializer serializer;
    private int port;

    public TcpService(int n) {
        this.port = n;
        Service$class.$init$(this);
        this.serializer = new JavaSerializer(this);
        this.internalNode = new Node(InetAddress.getLocalHost().getHostAddress(), n);
        this.connections = new HashMap();
    }

    public Serializer serializer() {
        return this.serializer();
    }

    public void nodeDown(Node node) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            this.connections().$minus$eq(node);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReachable(Node node) {
        if (this.isConnected(node)) return true;
        try {
            this.connect(node);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public void disconnectNode(Node node) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            Option option = this.connections().get(node);
            if (option != None$.MODULE$) {
                if (!(option instanceof Some)) {
                    throw new MatchError(option);
                }
                this.connections().$minus$eq(node);
                ((TcpServiceWorker)((Some)option).x()).halt();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public TcpServiceWorker connect(Node node) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            Socket socket = new Socket(node.address(), node.port());
            TcpServiceWorker tcpServiceWorker = new TcpServiceWorker(this, socket);
            tcpServiceWorker.sendNode(node);
            tcpServiceWorker.start();
            this.addConnection(node, tcpServiceWorker);
            return tcpServiceWorker;
        }
    }

    public boolean isConnected(Node node) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            return ScalaRunTime$.MODULE$.booleanValue(BoxedBoolean.box(!this.connections().get(node).isEmpty()));
        }
    }

    public Option getConnection(Node node) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            return this.connections().get(node);
        }
    }

    public void addConnection(Node node, TcpServiceWorker tcpServiceWorker) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            this.connections().$plus$eq(node).$minus$greater(tcpServiceWorker);
            return;
        }
    }

    private HashMap connections() {
        return this.connections;
    }

    public void run() {
        try {
            ServerSocket serverSocket = new ServerSocket(this.port);
            while (true) {
                Socket socket = serverSocket.accept();
                TcpServiceWorker tcpServiceWorker = new TcpServiceWorker(this, socket);
                tcpServiceWorker.readNode();
                tcpServiceWorker.start();
            }
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void send(Node node, byte[] byArray) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            Option option = this.getConnection(node);
            if (option != None$.MODULE$) {
                if (!(option instanceof Some)) {
                    throw new MatchError(option);
                }
                ((TcpServiceWorker)((Some)option).x()).transmit(byArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                TcpServiceWorker tcpServiceWorker = this.connect(node);
                tcpServiceWorker.transmit(byArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public Node node() {
        return this.internalNode();
    }

    private Node internalNode() {
        return this.internalNode;
    }

    public JavaSerializer serializer() {
        return this.serializer;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }

    public final void kernel_$eq(NetKernel netKernel) {
        this.kernel = netKernel;
    }

    public final NetKernel kernel() {
        return this.kernel;
    }
}

