/*
 * Decompiled with CFR 0.152.
 */
package scala.actors;

import scala.Iterator;
import scala.List$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.actors.Actor;
import scala.actors.IScheduler;
import scala.actors.Reaction;
import scala.actors.TickedScheduler$;
import scala.actors.WorkerThread;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Queue;
import scala.runtime.BoxedLong;
import scala.runtime.BoxedNumber;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TickedScheduler
extends IScheduler
implements ScalaObject {
    private int ticksCnt;
    private int TICKFREQ = 50;
    private boolean terminating = false;
    private HashMap executing;
    private HashMap ticks;
    private Queue idle;
    private Buffer scala$actors$TickedScheduler$$workers;
    private Queue tasks = new Queue();

    public TickedScheduler() {
        this.scala$actors$TickedScheduler$$workers = new ArrayBuffer();
        this.idle = new Queue();
        this.ticks = new HashMap();
        this.executing = new HashMap();
        this.init();
        this.ticksCnt = 0;
    }

    public Runnable getTask(WorkerThread workerThread) {
        return this.getTask(workerThread);
    }

    public void shutdown() {
        TickedScheduler tickedScheduler = this;
        synchronized (tickedScheduler) {
            this.terminating_$eq(true);
            Iterator iterator = this.idle().elements();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                WorkerThread workerThread = (WorkerThread)iterator.next();
                workerThread.running_$eq(false);
                workerThread.interrupt();
            }
        }
    }

    public void tick(Actor actor) {
        TickedScheduler tickedScheduler = this;
        synchronized (tickedScheduler) {
            this.ticksCnt_$eq(this.ticksCnt() + 1);
            Option option = this.executing().get(actor);
            if (option != None$.MODULE$) {
                if (!(option instanceof Some)) {
                    throw new MatchError(option);
                }
                this.ticks().update(((Some)option).x(), BoxedLong.box(System.currentTimeMillis()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void ticksCnt_$eq(int n) {
        this.ticksCnt = n;
    }

    public int ticksCnt() {
        return this.ticksCnt;
    }

    public Reaction getTask(WorkerThread workerThread) {
        TickedScheduler tickedScheduler = this;
        synchronized (tickedScheduler) {
            Reaction reaction;
            if (this.terminating()) {
                this.QUIT_TASK();
            }
            if (this.tasks().length() <= 0) {
                this.idle().$plus$eq(workerThread);
                reaction = null;
            } else {
                Reaction reaction2 = (Reaction)this.tasks().dequeue();
                this.executing().update(reaction2.actor(), workerThread);
                reaction = reaction2;
            }
            return reaction;
        }
    }

    public void execute(Reaction reaction) {
        TickedScheduler tickedScheduler = this;
        synchronized (tickedScheduler) {
            if (!this.terminating()) {
                if (this.idle().length() <= 0) {
                    Iterator iterator = this.scala$actors$TickedScheduler$$workers().elements();
                    boolean bl = false;
                    while (iterator.hasNext() && !bl) {
                        BoxedUnit boxedUnit;
                        WorkerThread workerThread = (WorkerThread)iterator.next();
                        Option option = this.ticks().get(workerThread);
                        if (option != None$.MODULE$) {
                            if (!(option instanceof Some)) {
                                throw new MatchError(option);
                            }
                            long l = System.currentTimeMillis();
                            if (l - ScalaRunTime$.MODULE$.longValue((BoxedNumber)((Some)option).x()) < (long)this.TICKFREQ()) {
                                bl = true;
                            }
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        bl = true;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    if (!bl) {
                        WorkerThread workerThread = new WorkerThread(this);
                        this.scala$actors$TickedScheduler$$workers().$plus$eq(workerThread);
                        this.executing().update(reaction.actor(), workerThread);
                        workerThread.execute(reaction);
                        workerThread.start();
                    } else {
                        this.tasks().$plus$eq(reaction);
                    }
                } else {
                    WorkerThread workerThread = (WorkerThread)this.idle().dequeue();
                    this.executing().update(reaction.actor(), workerThread);
                    workerThread.execute(reaction);
                }
            }
            return;
        }
    }

    public void init() {
        List$.MODULE$.range(0, 2).foreach(new $anonfun$1(this));
    }

    public void TICKFREQ_$eq(int n) {
        this.TICKFREQ = n;
    }

    public int TICKFREQ() {
        return this.TICKFREQ;
    }

    private void terminating_$eq(boolean bl) {
        this.terminating = bl;
    }

    private boolean terminating() {
        return this.terminating;
    }

    private HashMap executing() {
        return this.executing;
    }

    private HashMap ticks() {
        return this.ticks;
    }

    private Queue idle() {
        return this.idle;
    }

    private void scala$actors$TickedScheduler$$workers_$eq(Buffer buffer) {
        this.scala$actors$TickedScheduler$$workers = buffer;
    }

    public Buffer scala$actors$TickedScheduler$$workers() {
        return this.scala$actors$TickedScheduler$$workers;
    }

    private Queue tasks() {
        return this.tasks;
    }
}

