/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.backend.icode;

import java.io.PrintStream;
import scala.$colon$colon;
import scala.Function1;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Seq;
import scala.Some;
import scala.collection.mutable.Map;
import scala.runtime.BoxedInt;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.tools.nsc.backend.icode.BasicBlocks$BasicBlock$;
import scala.tools.nsc.backend.icode.ICodes;
import scala.tools.nsc.backend.icode.Members;
import scala.tools.nsc.backend.icode.Opcodes;
import scala.tools.nsc.backend.icode.analysis.ProgramPoint;
import scala.tools.nsc.util.Position$;

public interface BasicBlocks
extends ScalaObject {

    public class BasicBlock
    implements ProgramPoint,
    ScalaObject {
        public /* synthetic */ ICodes $outer;
        private boolean touched;
        private Opcodes.Instruction[] instrs;
        private boolean closed;
        private Opcodes.Instruction _lastInstruction;
        private List instructionList;
        private boolean loopHeader;
        private List preds;
        private boolean ignore;
        private int label;
        private Members.Code code;
        private int theLabel;

        public BasicBlock(ICodes iCodes, int n, Members.Code code) {
            this.code = code;
            if (iCodes != null) {
                this.$outer = iCodes;
                this.label = n;
                this.ignore = false;
                this.preds = null;
                this.loopHeader = false;
                this.instructionList = Nil$.MODULE$;
                this._lastInstruction = null;
                this.closed = false;
                this.touched = false;
                return;
            }
            throw new NullPointerException();
        }

        private final List subst$0(List list, Map map) {
            List list2;
            List list3 = list;
            if (list3 != Nil$.MODULE$) {
                List list4;
                if (!(list3 instanceof $colon$colon)) {
                    throw new MatchError(list3);
                }
                $colon$colon $colon$colon = ($colon$colon)list3;
                Opcodes.Instruction instruction = (Opcodes.Instruction)$colon$colon.hd();
                List list5 = $colon$colon.tl$0();
                Option option = map.get(instruction);
                if (!(option instanceof Some)) {
                    if (option != None$.MODULE$) {
                        throw new MatchError(option);
                    }
                    Opcodes.Instruction instruction2 = instruction;
                    list4 = this.subst$0(list5, map).$colon$colon(instruction2);
                } else {
                    Opcodes.Instruction instruction3;
                    Some some = (Some)option;
                    Opcodes.Instruction instruction4 = instruction3 = (Opcodes.Instruction)some.x();
                    list4 = this.subst$0(list5, map).$colon$colon(instruction4);
                }
                list2 = list4;
            } else {
                list2 = Nil$.MODULE$;
            }
            return list2;
        }

        public /* synthetic */ ICodes scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer() {
            return this.$outer;
        }

        public String toString() {
            return "" + BoxedInt.box(this.label());
        }

        public String fullString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Block ").append(BoxedInt.box(this.label()).toString());
            stringBuffer.append("\nSuccessors: ").append(this.successors());
            stringBuffer.append("\nPredecessors: ").append(this.predecessors());
            return stringBuffer.toString();
        }

        public void print(PrintStream printStream) {
            printStream.println("block #" + BoxedInt.box(this.label()) + " :");
            this.instructionList().reverse().foreach(new BasicBlock$$anonfun$3(this, printStream));
            printStream.print("Successors: ");
            this.successors().foreach(new BasicBlock$$anonfun$4(this, printStream));
            printStream.println();
        }

        public void print() {
            this.print(System.out);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof BasicBlock)) return false;
            if (((BasicBlock)object).label() != this.label()) return false;
            Members.Code code = ((BasicBlock)object).code();
            Members.Code code2 = this.code();
            if (code != null) {
                if (code.equals(code2)) return true;
                return false;
            } else if (code2 == null) return true;
            return false;
        }

        public List predecessors() {
            this.preds_$eq(this.code().blocks().elements().filter(new BasicBlock$$anonfun$2(this)).toList());
            return this.preds();
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public List successors() {
            void var2_14;
            Nil$ nil$;
            block15: {
                Opcodes.Instruction instruction;
                block16: {
                    boolean bl;
                    if (this.isEmpty()) {
                        nil$ = Nil$.MODULE$;
                        return nil$;
                    }
                    instruction = this.lastInstruction();
                    switch (instruction.$tag()) {
                        default: {
                            bl = false;
                            break;
                        }
                        case -1887773086: {
                            if (!(instruction instanceof Opcodes.opcodes.CJUMP) || ((Opcodes.opcodes.CJUMP)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$CJUMP$$$outer() != this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                                bl = false;
                                break;
                            }
                            Opcodes.opcodes.CJUMP cJUMP = (Opcodes.opcodes.CJUMP)instruction;
                            BasicBlock basicBlock = cJUMP.successBlock();
                            BasicBlock basicBlock2 = cJUMP.failureBlock();
                            BasicBlock basicBlock3 = basicBlock;
                            BasicBlock basicBlock4 = basicBlock2;
                            List list = Nil$.MODULE$.$colon$colon(basicBlock4).$colon$colon(basicBlock3);
                            break block15;
                        }
                        case -1872135625: {
                            if (!(instruction instanceof Opcodes.opcodes.THROW) || ((Opcodes.opcodes.THROW)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$THROW$$$outer() != this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                                bl = false;
                                break;
                            }
                            Nil$ nil$2 = Nil$.MODULE$;
                            break block15;
                        }
                        case -1584697699: {
                            if (!(instruction instanceof Opcodes.opcodes.JUMP) || ((Opcodes.opcodes.JUMP)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$JUMP$$$outer() != this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                                bl = false;
                                break;
                            }
                            List list = List$.MODULE$.apply(new BoxedObjectArray(new BasicBlock[]{((Opcodes.opcodes.JUMP)instruction).where()}));
                            break block15;
                        }
                        case 1623032788: {
                            if (!(instruction instanceof Opcodes.opcodes.CZJUMP) || ((Opcodes.opcodes.CZJUMP)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$CZJUMP$$$outer() != this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                                bl = false;
                                break;
                            }
                            Opcodes.opcodes.CZJUMP cZJUMP = (Opcodes.opcodes.CZJUMP)instruction;
                            BasicBlock basicBlock = cZJUMP.successBlock();
                            BasicBlock basicBlock5 = cZJUMP.failureBlock();
                            BasicBlock basicBlock6 = basicBlock;
                            BasicBlock basicBlock7 = basicBlock5;
                            List list = Nil$.MODULE$.$colon$colon(basicBlock7).$colon$colon(basicBlock6);
                            break block15;
                        }
                        case 2033374175: {
                            if (!(instruction instanceof Opcodes.opcodes.RETURN) || ((Opcodes.opcodes.RETURN)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$RETURN$$$outer() != this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                                bl = false;
                                break;
                            }
                            Nil$ nil$3 = Nil$.MODULE$;
                            break block15;
                        }
                        case 2078297571: {
                            if (instruction instanceof Opcodes.opcodes.SWITCH && ((Opcodes.opcodes.SWITCH)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$SWITCH$$$outer() == this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) break block16;
                            bl = false;
                        }
                    }
                    if (bl) throw new MatchError(instruction);
                    if (this.isClosed()) {
                        this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().dump();
                        this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().global().abort("The last instruction is not a control flow instruction: " + this.lastInstruction());
                        return null;
                    }
                    Nil$ nil$4 = Nil$.MODULE$;
                    break block15;
                }
                List list = ((Opcodes.opcodes.SWITCH)instruction).labels();
            }
            nil$ = var2_14;
            return nil$;
        }

        public boolean isClosed() {
            return this.closed();
        }

        public Opcodes.Instruction[] toInstructionArray(List list) {
            ObjectRef objectRef = new ObjectRef(new Opcodes.Instruction[list.length()]);
            IntRef intRef = new IntRef(0);
            list.foreach(new BasicBlock$$anonfun$1(this, objectRef, intRef));
            return (Opcodes.Instruction[])objectRef.elem;
        }

        public Opcodes.Instruction firstInstruction() {
            return !this.closed() ? (Opcodes.Instruction)this.instructionList().last() : this.instrs()[0];
        }

        public Opcodes.Instruction lastInstruction() {
            return !this.closed() ? (Opcodes.Instruction)this.instructionList().head() : this.instrs()[this.instrs().length - 1];
        }

        public void exitIgnoreMode() {
            Predef$.MODULE$.assert(this.ignore(), "Exit ignore mode when not in ignore mode.");
            this.ignore_$eq(false);
        }

        public void enterIgnoreMode() {
            this.ignore_$eq(true);
        }

        public boolean isEmpty() {
            return this.instructionList().isEmpty();
        }

        public void clear() {
            this.instructionList_$eq(Nil$.MODULE$);
            this.instrs_$eq(null);
            this.preds_$eq(null);
        }

        public void open() {
            this.closed_$eq(false);
            this.ignore_$eq(false);
        }

        public void close() {
            Predef$.MODULE$.assert(this.instructionList().length() > 0, "Empty block.");
            this.closed_$eq(true);
            this.instructionList_$eq(this.instructionList().reverse());
            this.instrs_$eq(this.toInstructionArray(this.instructionList()));
        }

        public void emit(Opcodes.Instruction instruction, int n) {
            Predef$.MODULE$.assert(!this.closed() || this.ignore(), "BasicBlock closed");
            if (!this.ignore()) {
                this.touched_$eq(true);
                instruction.pos_$eq(n);
                Opcodes.Instruction instruction2 = instruction;
                this.instructionList_$eq(this.instructionList().$colon$colon(instruction2));
                this._lastInstruction_$eq(instruction);
            }
        }

        public void emit(Opcodes.Instruction instruction) {
            if (!this.instructionList().isEmpty()) {
                this.emit(instruction, ((Opcodes.Instruction)this.instructionList().head()).pos());
            } else {
                this.emit(instruction, Position$.MODULE$.NOPOS());
            }
        }

        private void substOnList(Map map) {
            this.instructionList_$eq(this.subst$0(this.instructionList(), map));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void subst(Map map) {
            if (!this.closed()) {
                this.substOnList(map);
                return;
            }
            int n = 0;
            while (n < this.instrs().length) {
                BoxedUnit boxedUnit;
                Option option = map.get(this.instrs()[n]);
                if (!(option instanceof Some)) {
                    if (option != None$.MODULE$) {
                        throw new MatchError(option);
                    }
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.touched_$eq(this.replaceInstruction(n, (Opcodes.Instruction)((Some)option).x()));
                    boxedUnit = BoxedUnit.UNIT;
                }
                ++n;
            }
            return;
        }

        public void removeInstructionsAt(Seq seq) {
            Predef$.MODULE$.assert(this.closed());
            List list = seq.toList();
            Opcodes.Instruction[] instructionArray = new Opcodes.Instruction[this.instrs().length - seq.length()];
            int n = 0;
            int n2 = 0;
            while (true) {
                if (n >= this.instrs().length) {
                    this.instrs_$eq(instructionArray);
                    return;
                }
                if (!list.contains(BoxedInt.box(n))) {
                    instructionArray[n2] = this.instrs()[n];
                    ++n2;
                }
                ++n;
            }
        }

        public boolean replaceInstruction(Opcodes.Instruction instruction, List list) {
            Predef$.MODULE$.assert(this.closed(), "Instructions can be replaced only after the basic block is closed");
            int n = 0;
            boolean bl = false;
            while (true) {
                if (n >= this.instrs().length || this.instrs()[n] == instruction) {
                    if (n < this.instrs().length) {
                        Opcodes.Instruction[] instructionArray = new Opcodes.Instruction[this.instrs().length + list.length() - 1];
                        bl = true;
                        System.arraycopy(this.instrs(), 0, instructionArray, 0, n);
                        IntRef intRef = new IntRef(n);
                        list.foreach(new BasicBlock$$anonfun$0(this, instructionArray, intRef));
                        if (n + 1 < this.instrs().length) {
                            System.arraycopy(this.instrs(), n + 1, instructionArray, intRef.elem, this.instrs().length - n - 1);
                        }
                        this.instrs_$eq(instructionArray);
                    }
                    return bl;
                }
                ++n;
            }
        }

        public boolean replaceInstruction(Opcodes.Instruction instruction, Opcodes.Instruction instruction2) {
            Predef$.MODULE$.assert(this.closed(), "Instructions can be replaced only after the basic block is closed");
            boolean bl = false;
            for (int i = 0; i < this.instrs().length && !bl; ++i) {
                Opcodes.Instruction instruction3 = this.instrs()[i];
                Opcodes.Instruction instruction4 = instruction;
                if (instruction3 == null ? instruction4 != null : !instruction3.equals(instruction4)) continue;
                instruction2.pos_$eq(instruction.pos());
                this.instrs()[i] = instruction2;
                bl = true;
            }
            return bl;
        }

        public boolean replaceInstruction(int n, Opcodes.Instruction instruction) {
            Predef$.MODULE$.assert(this.closed(), "Instructions can be replaced only after the basic block is closed");
            instruction.pos_$eq(this.instrs()[n].pos());
            this.instrs()[n] = instruction;
            return true;
        }

        public Opcodes.Instruction apply(int n) {
            return !this.closed() ? (Opcodes.Instruction)this.instructionList().reverse().apply(n) : this.instrs()[n];
        }

        public Option findDef(int n) {
            Predef$.MODULE$.assert(this.closed());
            int n2 = n;
            int n3 = 0;
            while (n2 > 0 && n3 >= 0) {
                n3 += this.instrs()[--n2].consumed() - this.instrs()[n2].produced();
            }
            return n2 < 0 ? None$.MODULE$ : new Some(BoxedInt.box(n2));
        }

        public int size() {
            return !this.isClosed() ? this.instructionList().length() : this.instrs().length;
        }

        public void traverseBackwards(Function1 function1) {
            int n = this.instrs().length - 1;
            while (n >= 0) {
                function1.apply(this.instrs()[n]);
                --n;
            }
            return;
        }

        public void traverse(Function1 function1) {
            if (!this.closed()) {
                this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().dump();
                this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().global().abort("Traversing an open block!: " + BoxedInt.box(this.label()));
                return;
            }
            new BoxedObjectArray(this.instrs()).foreach(function1);
        }

        public int hashCode() {
            return this.label();
        }

        public void fromList(List list) {
            this.instrs_$eq(this.toInstructionArray(list));
            this.closed_$eq(true);
        }

        public List toList() {
            if (this.closed() && this.touched()) {
                this.instructionList_$eq(List$.MODULE$.fromArray(new BoxedObjectArray(this.instrs())));
            }
            return this.instructionList();
        }

        private void touched_$eq(boolean bl) {
            this.touched = bl;
        }

        private boolean touched() {
            return this.touched;
        }

        private void instrs_$eq(Opcodes.Instruction[] instructionArray) {
            this.instrs = instructionArray;
        }

        private Opcodes.Instruction[] instrs() {
            return this.instrs;
        }

        private void closed_$eq(boolean bl) {
            this.closed = bl;
        }

        private boolean closed() {
            return this.closed;
        }

        private void _lastInstruction_$eq(Opcodes.Instruction instruction) {
            this._lastInstruction = instruction;
        }

        private Opcodes.Instruction _lastInstruction() {
            return this._lastInstruction;
        }

        private void instructionList_$eq(List list) {
            this.instructionList = list;
        }

        private List instructionList() {
            return this.instructionList;
        }

        public void loopHeader_$eq(boolean bl) {
            this.loopHeader = bl;
        }

        public boolean loopHeader() {
            return this.loopHeader;
        }

        public void preds_$eq(List list) {
            this.preds = list;
        }

        public List preds() {
            return this.preds;
        }

        public void ignore_$eq(boolean bl) {
            this.ignore = bl;
        }

        public boolean ignore() {
            return this.ignore;
        }

        public int label() {
            return this.label;
        }

        public Members.Code code() {
            return this.code;
        }

        public int $tag() {
            return ScalaObject$class.$tag(this);
        }
    }
}

