/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.serialization.NullSerializer$;
import akka.serialization.Serialization$;
import akka.serialization.Serialization$$anonfun$sort$1$;
import akka.serialization.Serializer;
import com.typesafe.config.Config;
import java.io.NotSerializableException;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.DynamicVariable;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t%r!B\u0001\u0003\u0011\u00039\u0011!D*fe&\fG.\u001b>bi&|gN\u0003\u0002\u0004\t\u0005i1/\u001a:jC2L'0\u0019;j_:T\u0011!B\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003\u001bM+'/[1mSj\fG/[8o'\tIA\u0002\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u\u0011\u0015)\u0012\u0002\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq!\u0002\u0003\u0019\u0013\u0001I\"aD\"mCN\u001c8+\u001a:jC2L'0\u001a:\u0011\tiirDM\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1A+\u001e9mKJ\u0002$\u0001I\u0015\u0011\u0007\u0005\"sE\u0004\u0002\u001bE%\u00111eG\u0001\u0007!J,G-\u001a4\n\u0005\u00152#!B\"mCN\u001c(BA\u0012\u001c!\tA\u0013\u0006\u0004\u0001\u0005\u0013):\u0012\u0011!A\u0001\u0006\u0003Y#aA0%cE\u0011Af\f\t\u000355J!AL\u000e\u0003\u000f9{G\u000f[5oOB\u0011!\u0004M\u0005\u0003cm\u00111!\u00118z!\tA1'\u0003\u00025\u0005\tQ1+\u001a:jC2L'0\u001a:\t\u000fYJ!\u0019!C\u0001o\u000592-\u001e:sK:$HK]1ogB|'\u000f^!eIJ,7o]\u000b\u0002qA\u0019\u0011\b\u0010 \u000e\u0003iR!aO\u000e\u0002\tU$\u0018\u000e\\\u0005\u0003{i\u0012q\u0002R=oC6L7MV1sS\u0006\u0014G.\u001a\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\u0012\tQ!Y2u_JL!a\u0011!\u0003\u000f\u0005#GM]3tg\"1Q)\u0003Q\u0001\na\n\u0001dY;se\u0016tG\u000f\u0016:b]N\u0004xN\u001d;BI\u0012\u0014Xm]:!\r\u00119\u0015\u0002\u0001%\u0003\u0011M+G\u000f^5oON\u001c\"A\u0012\u0007\t\u0011)3%Q1A\u0005\u0002-\u000baaY8oM&<W#\u0001'\u0011\u00055\u001bV\"\u0001(\u000b\u0005){%B\u0001)R\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001*\u0002\u0007\r|W.\u0003\u0002U\u001d\n11i\u001c8gS\u001eD\u0001B\u0016$\u0003\u0002\u0003\u0006I\u0001T\u0001\bG>tg-[4!\u0011\u0015)b\t\"\u0001Y)\tI6\f\u0005\u0002[\r6\t\u0011\u0002C\u0003K/\u0002\u0007A\nC\u0004^\r\n\u0007I\u0011\u00010\u0002\u0017M+'/[1mSj,'o]\u000b\u0002?B!\u0011\u0005\u00192c\u0013\t\tgEA\u0002NCB\u0004\"!I2\n\u0005\u00114#AB*ue&tw\r\u0003\u0004g\r\u0002\u0006IaX\u0001\r'\u0016\u0014\u0018.\u00197ju\u0016\u00148\u000f\t\u0005\bQ\u001a\u0013\r\u0011\"\u0001_\u0003U\u0019VM]5bY&T\u0018\r^5p]\nKg\u000eZ5oONDaA\u001b$!\u0002\u0013y\u0016AF*fe&\fG.\u001b>bi&|gNQ5oI&twm\u001d\u0011\t\u000b14E\u0011B7\u0002\u0017\r|gNZ5h)>l\u0015\r\u001d\u000b\u0003?:DQa\\6A\u00021\u000b1a\u00194h\r\u0011Q!\u0001A9\u0014\u0007Ad!\u000f\u0005\u0002@g&\u0011A\u000f\u0011\u0002\n\u000bb$XM\\:j_:D\u0001B\u001e9\u0003\u0006\u0004%\ta^\u0001\u0007gf\u001cH/Z7\u0016\u0003a\u0004\"aP=\n\u0005i\u0004%aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0007\u0002\u0003?q\u0005\u0003\u0005\u000b\u0011\u0002=\u0002\u000fML8\u000f^3nA!)Q\u0003\u001dC\u0001}R\u0019q0!\u0001\u0011\u0005!\u0001\b\"\u0002<~\u0001\u0004A\b\"CA\u0003a\n\u0007I\u0011AA\u0004\u0003!\u0019X\r\u001e;j]\u001e\u001cXCAA\u0005!\r\tYA\u0012\b\u0003\u0011\u0001A\u0001\"a\u0004qA\u0003%\u0011\u0011B\u0001\ng\u0016$H/\u001b8hg\u0002B\u0011\"a\u0005q\u0005\u0004%\t!!\u0006\u0002\u00071|w-\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e\u0011\tQ!\u001a<f]RLA!!\t\u0002\u001c\tqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\b\u0002CA\u0013a\u0002\u0006I!a\u0006\u0002\t1|w\r\t\u0005\b\u0003S\u0001H\u0011AA\u0016\u0003%\u0019XM]5bY&TX\r\u0006\u0003\u0002.\u0005]\u0003\u0003CA\u0018\u0003\u007f\t)%a\u0013\u000f\t\u0005E\u00121\b\b\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019\u0011q\u0007\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0012bAA\u001f7\u00059\u0001/Y2lC\u001e,\u0017\u0002BA!\u0003\u0007\u0012a!R5uQ\u0016\u0014(bAA\u001f7A!\u0011qFA$\u0013\u0011\tI%a\u0011\u0003\u0013QC'o\\<bE2,\u0007#\u0002\u000e\u0002N\u0005E\u0013bAA(7\t)\u0011I\u001d:bsB\u0019!$a\u0015\n\u0007\u0005U3D\u0001\u0003CsR,\u0007\u0002CA-\u0003O\u0001\r!a\u0017\u0002\u0003=\u00042AGA/\u0013\r\tyf\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0005\r\u0004\u000f\"\u0001\u0002f\u0005YA-Z:fe&\fG.\u001b>f)!\t9'!\u001b\u0002n\u0005]\u0004\u0003CA\u0018\u0003\u007f\t)%a\u0017\t\u0011\u0005-\u0014\u0011\ra\u0001\u0003\u0017\nQAY=uKND\u0001\"a\u001c\u0002b\u0001\u0007\u0011\u0011O\u0001\rg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\n\u001a\t\u00045\u0005M\u0014bAA;7\t\u0019\u0011J\u001c;\t\u0011\u0005e\u0014\u0011\ra\u0001\u0003w\nQa\u00197buj\u0004RAGA?\u0003\u0003K1!a \u001c\u0005\u0019y\u0005\u000f^5p]B\"\u00111QAD!\u0011\tC%!\"\u0011\u0007!\n9\tB\u0006\u0002\n\u0006\u0005\u0014\u0011!A\u0001\u0006\u0003Y#aA0%e!9\u00111\r9\u0005\u0002\u00055ECBA4\u0003\u001f\u000b\t\n\u0003\u0005\u0002l\u0005-\u0005\u0019AA&\u0011!\tI(a#A\u0002\u0005M\u0005\u0007BAK\u00033\u0003B!\t\u0013\u0002\u0018B\u0019\u0001&!'\u0005\u0017\u0005m\u00151RA\u0001\u0002\u0003\u0015\ta\u000b\u0002\u0004?\u0012\u001a\u0004bBAPa\u0012\u0005\u0011\u0011U\u0001\u0012M&tGmU3sS\u0006d\u0017N_3s\r>\u0014Hc\u0001\u001a\u0002$\"A\u0011\u0011LAO\u0001\u0004\tY\u0006C\u0004\u0002(B$\t!!+\u0002\u001bM,'/[1mSj,'OR8s)\r\u0011\u00141\u0016\u0005\t\u0003s\n)\u000b1\u0001\u0002.B\"\u0011qVAZ!\u0011\tC%!-\u0011\u0007!\n\u0019\fB\u0006\u00026\u0006\u0015\u0016\u0011!A\u0001\u0006\u0003Y#aA0%i!9\u0011\u0011\u00189\u0005\u0002\u0005m\u0016\u0001D:fe&\fG.\u001b>fe>3G\u0003BA_\u0003\u007f\u0003r!a\f\u0002@\u0005\u0015#\u0007C\u0004\u0002B\u0006]\u0006\u0019\u00012\u0002\u001bM,'/[1mSj,'OR)O\u0011%\t)\r\u001db\u0001\n\u0013\t9-A\u0006tKJL\u0017\r\\5{KJ\u001cXCAAe!\u0011\t\u0003M\u0019\u001a\t\u0011\u00055\u0007\u000f)A\u0005\u0003\u0013\fAb]3sS\u0006d\u0017N_3sg\u0002B!\"!5q\u0005\u0004%\t\u0001BAj\u0003!\u0011\u0017N\u001c3j]\u001e\u001cXCAAk!\u0019\ty#a6\u0002\\&!\u0011\u0011\\A\"\u0005\r\u0019V-\u001d\t\u0004\u0003\u00179\u0002\u0002CApa\u0002\u0006I!!6\u0002\u0013\tLg\u000eZ5oON\u0004\u0003bBAra\u0012%\u0011Q]\u0001\u0005g>\u0014H\u000f\u0006\u0003\u0002V\u0006\u001d\b\u0002CAu\u0003C\u0004\r!a;\u0002\u0005%t\u0007CBA\u0018\u0003[\fY.\u0003\u0003\u0002p\u0006\r#\u0001C%uKJ\f'\r\\3\t\u0013\u0005M\bO1A\u0005\n\u0005U\u0018!D:fe&\fG.\u001b>fe6\u000b\u0007/\u0006\u0002\u0002xB9\u0011\u0011 B\u0001\u0005\u000b\u0011TBAA~\u0015\u0011\ti0a@\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002<!%!!1AA~\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\u0019\u0005\u0005\u000f\u0011Y\u0001\u0005\u0003\"I\t%\u0001c\u0001\u0015\u0003\f\u0011Q!Q\u00029\u0002\u0002\u0003\u0005)\u0011A\u0016\u0003\u0007}#s\u0007\u0003\u0005\u0003\u0012A\u0004\u000b\u0011\u0002B\n\u00039\u0019XM]5bY&TXM]'ba\u0002\u0002r!!?\u0003\u0002\tU!\u0007\r\u0003\u0003\u0018\tm\u0001\u0003B\u0011%\u00053\u00012\u0001\u000bB\u000e\t)\u0011i\u0001]A\u0001\u0002\u0003\u0015\ta\u000b\u0005\n\u0005?\u0001(\u0019!C\u0001\u0005C\tAc]3sS\u0006d\u0017N_3s\u0005fLE-\u001a8uSRLXC\u0001B\u0012!\u0015\t\u0003-!\u001d3\u0011!\u00119\u0003\u001dQ\u0001\n\t\r\u0012!F:fe&\fG.\u001b>fe\nK\u0018\nZ3oi&$\u0018\u0010\t")
public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final LoggingAdapter log;
    private final Map<String, Serializer> akka$serialization$Serialization$$serializers;
    private final Seq<Tuple2<Class<?>, Serializer>> bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final Map<Object, Serializer> serializerByIdentity;

    public static DynamicVariable<Address> currentTransportAddress() {
        return Serialization$.MODULE$.currentTransportAddress();
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public Either<Throwable, byte[]> serialize(Object o) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply((Object)this.findSerializerFor(o).toBinary(o));
        }
        catch (Throwable throwable) {
            Throwable x4 = throwable;
            Option o11 = NonFatal$.MODULE$.unapply(x4);
            if (o11.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)o11.get();
            Left left = package$.MODULE$.Left().apply((Object)e);
            right = left;
        }
        return right;
    }

    public Either<Throwable, Object> deserialize(byte[] bytes, int serializerId, Option<Class<?>> clazz) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply(((Serializer)this.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)serializerId))).fromBinary(bytes, clazz));
        }
        catch (Throwable throwable) {
            Throwable x4 = throwable;
            Option o11 = NonFatal$.MODULE$.unapply(x4);
            if (o11.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)o11.get();
            Left left = package$.MODULE$.Left().apply((Object)e);
            right = left;
        }
        return right;
    }

    public Either<Throwable, Object> deserialize(byte[] bytes, Class<?> clazz) {
        Right right;
        try {
            right = package$.MODULE$.Right().apply(this.serializerFor(clazz).fromBinary(bytes, (Option<Class<?>>)new Some(clazz)));
        }
        catch (Throwable throwable) {
            Throwable x4 = throwable;
            Option o11 = NonFatal$.MODULE$.unapply(x4);
            if (o11.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)o11.get();
            Left left = package$.MODULE$.Left().apply((Object)e);
            right = left;
        }
        return right;
    }

    public Serializer findSerializerFor(Object o) {
        Serializer serializer;
        Object object = o;
        if (object == null) {
            Object x2 = object;
            serializer = NullSerializer$.MODULE$;
        } else {
            serializer = this.serializerFor(object.getClass());
        }
        return serializer;
    }

    public Serializer serializerFor(Class<?> clazz) {
        Serializer serializer;
        Serializer serializer2 = this.serializerMap().get(clazz);
        if (serializer2 == null) {
            Serializer serializer3;
            Serializer serializer4;
            Serializer x2 = serializer2;
            Seq seq = (Seq)this.bindings().filter((Function1)new $anonfun$1(this, clazz));
            Some o7 = Seq$.MODULE$.unapplySeq(seq);
            if (!o7.isEmpty() && o7.get() != null && ((SeqLike)o7.get()).lengthCompare(0) == 0) {
                throw new NotSerializableException(new StringOps(Predef$.MODULE$.augmentString("No configured serialization-bindings for class [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz.getName()})));
            }
            if (!this.unique$1(seq)) {
                this.log().warning(new StringBuilder().append((Object)"Multiple serializers found for ").append(clazz).append((Object)", choosing first: ").append((Object)seq).toString());
            }
            Serializer ser = serializer4 = (Serializer)((Tuple2)seq.apply(0))._2();
            Serializer serializer5 = this.serializerMap().putIfAbsent(clazz, ser);
            if (serializer5 == null) {
                Serializer x22 = serializer5;
                this.log().debug("Using serializer[{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                serializer3 = ser;
            } else {
                serializer3 = serializer5;
            }
            serializer = serializer3;
        } else {
            serializer = serializer2;
        }
        return serializer;
    }

    public Either<Throwable, Serializer> serializerOf(String serializerFQN) {
        return (Either)this.system().dynamicAccess().createInstanceFor(serializerFQN, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.extension$$minus$greater(Predef$.MODULE$.any2ArrowAssoc(ExtendedActorSystem.class), (Object)this.system())})), ClassTag$.MODULE$.apply(Serializer.class)).fold((Function1)new Serializable(this, serializerFQN){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final String serializerFQN$1;

            public final Either<Throwable, Serializer> apply(Throwable x$6) {
                return this.$outer.system().dynamicAccess().createInstanceFor(this.serializerFQN$1, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), ClassTag$.MODULE$.apply(Serializer.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.serializerFQN$1 = serializerFQN$1;
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Right<Nothing$, Serializer> apply(Serializer x$7) {
                return package$.MODULE$.Right().apply((Object)x$7);
            }
        });
    }

    public final Map<String, Serializer> akka$serialization$Serialization$$serializers() {
        return this.akka$serialization$Serialization$$serializers;
    }

    public Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    private Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        ArrayBuffer arrayBuffer = new ArrayBuffer(in.size());
        return (Seq)in.$div$colon((Object)arrayBuffer, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayBuffer<Tuple2<Class<?>, Serializer>> apply(ArrayBuffer<Tuple2<Class<?>, Serializer>> buf, Tuple2<Class<?>, Serializer> ca) {
                int n = buf.indexWhere((Function1)new $anonfun$sort$1$$anonfun$5(this, ca));
                switch (n) {
                    default: {
                        buf.insert(n, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                        break;
                    }
                    case -1: {
                        buf.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    }
                }
                return buf;
            }
        });
    }

    private ConcurrentHashMap<Class<?>, Serializer> serializerMap() {
        return this.serializerMap;
    }

    public Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private final boolean unique$1(Seq possibilities) {
        return possibilities.size() == 1 || ((IterableLike)possibilities.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Class<?> apply(Tuple2<Class<?>, Serializer> x$1) {
                return (Class)x$1._1();
            }
        }, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this, possibilities){
            public static final long serialVersionUID = 0L;
            private final Seq possibilities$1;

            public final boolean apply(Class<?> x$2) {
                return x$2.isAssignableFrom((Class)((Tuple2)this.possibilities$1.apply(0))._1());
            }
            {
                this.possibilities$1 = possibilities$1;
            }
        }) || ((IterableLike)possibilities.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Serializer apply(Tuple2<Class<?>, Serializer> x$3) {
                return (Serializer)x$3._2();
            }
        }, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this, possibilities){
            public static final long serialVersionUID = 0L;
            private final Seq possibilities$1;

            public final boolean apply(Serializer x$4) {
                Serializer serializer = x$4;
                Object object = ((Tuple2)this.possibilities$1.apply(0))._2();
                return !(serializer != null ? !serializer.equals(object) : object != null);
            }
            {
                this.possibilities$1 = possibilities$1;
            }
        });
    }

    public Serialization(ExtendedActorSystem system) {
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.log = Logging$.MODULE$.apply(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.akka$serialization$Serialization$$serializers = (Map)this.settings().Serializers().withFilter((Function1)new $anonfun$2(this)).map((Function1)new $anonfun$6(this), Map$.MODULE$.canBuildFrom());
        scala.collection.immutable.Iterable configuredBindings = (scala.collection.immutable.Iterable)this.settings().SerializationBindings().withFilter((Function1)new $anonfun$3(this)).withFilter((Function1)new $anonfun$4(this)).map((Function1)new $anonfun$7(this), Iterable$.MODULE$.canBuildFrom());
        this.bindings = this.sort((Iterable<Tuple2<Class<?>, Serializer>>)configuredBindings);
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        this.serializerMap = (ConcurrentHashMap)this.bindings().$div$colon(concurrentHashMap, (Function2)new $anonfun$10(this));
        this.serializerByIdentity = (Map)((TraversableLike)((TraversableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.extension$$minus$greater(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)NullSerializer$.MODULE$.identifier())), (Object)NullSerializer$.MODULE$)}))).$plus$plus(this.akka$serialization$Serialization$$serializers(), Map$.MODULE$.canBuildFrom())).map((Function1)new $anonfun$11(this), Map$.MODULE$.canBuildFrom());
    }

    public static class Settings {
        private final Config config;
        private final Map<String, String> Serializers;
        private final Map<String, String> SerializationBindings;

        public Config config() {
            return this.config;
        }

        public Map<String, String> Serializers() {
            return this.Serializers;
        }

        public Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private Map<String, String> configToMap(Config cfg) {
            return (Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(cfg.root().unwrapped()).asScala()).toMap(Predef$.MODULE$.conforms()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(Tuple2<String, Object> x0$1) {
                    Tuple2<String, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Object v = tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)k, (Object)v.toString());
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Map$.MODULE$.canBuildFrom());
        }

        public Settings(Config config) {
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("akka.actor.serializers"));
            this.SerializationBindings = this.configToMap(config.getConfig("akka.actor.serialization-bindings"));
        }
    }
}

