/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.cell;

import akka.actor.Actor;
import akka.actor.ActorCell;
import akka.actor.ActorInterruptedException;
import akka.actor.ActorRef;
import akka.actor.ChildRestartStats;
import akka.actor.Failed;
import akka.actor.InternalActorRef;
import akka.actor.PostRestartException;
import akka.actor.PreRestartException;
import akka.actor.cell.ChildrenContainer;
import akka.actor.cell.ChildrenContainer$Termination$;
import akka.dispatch.ChildTerminated;
import akka.event.Logging;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.util.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public abstract class FaultHandling$class {
    private static void suspendNonRecursive(ActorCell $this) {
        $this.dispatcher().suspend($this);
    }

    private static void resumeNonRecursive(ActorCell $this) {
        $this.dispatcher().resume($this);
    }

    private static boolean isFailed(ActorCell $this) {
        return $this.akka$actor$cell$FaultHandling$$_failed();
    }

    private static void setFailed(ActorCell $this) {
        $this.akka$actor$cell$FaultHandling$$_failed_$eq(true);
    }

    private static void clearFailed(ActorCell $this) {
        $this.akka$actor$cell$FaultHandling$$_failed_$eq(false);
    }

    public static void faultRecreate(ActorCell $this, Throwable cause) {
        Actor failedActor;
        block11: {
            block10: {
                block9: {
                    if (!$this.isNormal()) break block9;
                    failedActor = $this.actor();
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(failedActor), "restarting"));
                    }
                    if (failedActor == null) break block10;
                    None$ optionalMessage = $this.currentMessage() != null ? new Some($this.currentMessage().message()) : None$.MODULE$;
                    try {
                        if (failedActor.context() != null) {
                            failedActor.preRestart(cause, (Option<Object>)optionalMessage);
                        }
                        $this.clearActorFields(failedActor);
                    }
                    catch (Throwable throwable) {
                        Throwable x4 = throwable;
                        Option o11 = NonFatal$.MODULE$.unapply(x4);
                        if (o11.isEmpty()) {
                            throw throwable;
                        }
                        Throwable e = (Throwable)o11.get();
                        PreRestartException ex = new PreRestartException($this.self(), e, cause, (Option<Object>)optionalMessage);
                        $this.publish(new Logging.Error(ex, $this.self().path().toString(), $this.clazz(failedActor), e.getMessage()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                $this.faultResume(false);
                break block11;
            }
            Predef$.MODULE$.assert($this.mailbox().isSuspended(), (Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ActorCell $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"mailbox must be suspended during restart, status=").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.mailbox().status())).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            if (!$this.setChildrenTerminationReason(new ChildrenContainer.Recreation(cause))) {
                FaultHandling$class.finishRecreate($this, cause, failedActor);
            }
        }
        return;
        {
            finally {
                $this.clearActorFields(failedActor);
            }
        }
    }

    public static void faultSuspend(ActorCell $this) {
        FaultHandling$class.suspendNonRecursive($this);
        $this.suspendChildren($this.suspendChildren$default$1());
    }

    public static void faultResume(ActorCell $this, boolean inResponseToFailure) {
        try {
            FaultHandling$class.resumeNonRecursive($this);
            $this.resumeChildren();
            return;
        }
        finally {
            if (inResponseToFailure) {
                FaultHandling$class.clearFailed($this);
            }
        }
    }

    public static void terminate(ActorCell $this) {
        $this.setReceiveTimeout((Option<Duration>)None$.MODULE$);
        $this.cancelReceiveTimeout();
        $this.children().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ActorCell $outer;

            public final void apply(ActorRef actor) {
                this.$outer.stop(actor);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        boolean wasTerminating = $this.isTerminating();
        if ($this.setChildrenTerminationReason(ChildrenContainer$Termination$.MODULE$)) {
            if (!wasTerminating) {
                FaultHandling$class.suspendNonRecursive($this);
                FaultHandling$class.setFailed($this);
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz($this.actor()), "stopping"));
                }
            }
        } else {
            $this.setTerminated();
            FaultHandling$class.finishTerminate($this);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final void handleInvokeFailure(ActorCell $this, Throwable t, String message) {
        block9: {
            $this.publish(new Logging.Error(t, $this.self().path().toString(), $this.clazz($this.actor()), message));
            if (FaultHandling$class.isFailed($this)) break block9;
            try {
                FaultHandling$class.suspendNonRecursive($this);
                FaultHandling$class.setFailed($this);
                var10_3 = $this.currentMessage();
                if (var10_3 == null) ** GOTO lbl-1000
                p2 = var10_3.message();
                child = var10_3.sender();
                if (!(p2 instanceof Failed) || (x4 = (Failed)p2) == null) ** GOTO lbl-1000
                p3 = x4.cause();
                v0 = t;
                var15_8 = p3;
                if (!(v0 != null ? v0.equals(var15_8) == false : var15_8 != null)) {
                    x5 = p3;
                    var17_10 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ActorRef[]{child}));
                } else lbl-1000:
                // 3 sources

                {
                    var17_10 = Predef$.MODULE$.Set().empty();
                }
                skip = var17_10;
                $this.suspendChildren((Set<ActorRef>)skip);
                var18_12 = t;
                if (var18_12 instanceof InterruptedException) {
                    x2 = (InterruptedException)var18_12;
                    $this.parent().tell(new Failed(new ActorInterruptedException(t)), $this.self());
                    throw t;
                }
                $this.parent().tell(new Failed(t), $this.self());
                var20_14 = BoxedUnit.UNIT;
            }
            catch (Throwable var3_15) {
                x4 = var3_15;
                o11 = NonFatal$.MODULE$.unapply(x4);
                if (o11.isEmpty()) {
                    throw var3_15;
                }
                e = (Throwable)o11.get();
                $this.publish(new Logging.Error(e, $this.self().path().toString(), $this.clazz($this.actor()), "emergency stop: exception in failure handling"));
                $this.children().foreach((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ActorCell $outer;

                    public final void apply(ActorRef actor) {
                        this.$outer.stop(actor);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                var7_19 = BoxedUnit.UNIT;
            }
        }
        return;
        {
            finally {
                FaultHandling$class.finishTerminate($this);
            }
        }
    }

    private static void finishTerminate(ActorCell $this) {
        Actor a;
        block94: {
            a = $this.actor();
            try {
                if (a == null) break block94;
                a.postStop();
            }
            catch (Throwable throwable) {
                try {
                    $this.dispatcher().detach($this);
                }
                catch (Throwable throwable2) {
                    try {
                        $this.parent().sendSystemMessage(new ChildTerminated($this.self()));
                    }
                    catch (Throwable throwable3) {
                        try {
                            $this.tellWatchersWeDied(a);
                        }
                        catch (Throwable throwable4) {
                            try {
                                $this.unwatchWatchedActors(a);
                                throw throwable4;
                            }
                            finally {
                                if ($this.system().settings().DebugLifecycle()) {
                                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                                }
                                $this.clearActorFields(a);
                                $this.actor_$eq(null);
                            }
                        }
                        try {
                            $this.unwatchWatchedActors(a);
                            throw throwable3;
                        }
                        finally {
                            if ($this.system().settings().DebugLifecycle()) {
                                $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                            }
                            $this.clearActorFields(a);
                            $this.actor_$eq(null);
                        }
                    }
                    try {
                        $this.tellWatchersWeDied(a);
                    }
                    catch (Throwable throwable5) {
                        try {
                            $this.unwatchWatchedActors(a);
                            throw throwable5;
                        }
                        finally {
                            if ($this.system().settings().DebugLifecycle()) {
                                $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                            }
                            $this.clearActorFields(a);
                            $this.actor_$eq(null);
                        }
                    }
                    try {
                        $this.unwatchWatchedActors(a);
                        throw throwable2;
                    }
                    finally {
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                        }
                        $this.clearActorFields(a);
                        $this.actor_$eq(null);
                    }
                }
                try {
                    $this.parent().sendSystemMessage(new ChildTerminated($this.self()));
                }
                catch (Throwable throwable6) {
                    try {
                        $this.tellWatchersWeDied(a);
                    }
                    catch (Throwable throwable7) {
                        try {
                            $this.unwatchWatchedActors(a);
                            throw throwable7;
                        }
                        finally {
                            if ($this.system().settings().DebugLifecycle()) {
                                $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                            }
                            $this.clearActorFields(a);
                            $this.actor_$eq(null);
                        }
                    }
                    try {
                        $this.unwatchWatchedActors(a);
                        throw throwable6;
                    }
                    finally {
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                        }
                        $this.clearActorFields(a);
                        $this.actor_$eq(null);
                    }
                }
                try {
                    $this.tellWatchersWeDied(a);
                }
                catch (Throwable throwable8) {
                    try {
                        $this.unwatchWatchedActors(a);
                        throw throwable8;
                    }
                    finally {
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                        }
                        $this.clearActorFields(a);
                        $this.actor_$eq(null);
                    }
                }
                try {
                    $this.unwatchWatchedActors(a);
                    throw throwable;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                    }
                    $this.clearActorFields(a);
                    $this.actor_$eq(null);
                }
            }
        }
        try {
            $this.dispatcher().detach($this);
        }
        catch (Throwable throwable) {
            try {
                $this.parent().sendSystemMessage(new ChildTerminated($this.self()));
            }
            catch (Throwable throwable9) {
                try {
                    $this.tellWatchersWeDied(a);
                }
                catch (Throwable throwable10) {
                    try {
                        $this.unwatchWatchedActors(a);
                        throw throwable10;
                    }
                    finally {
                        if ($this.system().settings().DebugLifecycle()) {
                            $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                        }
                        $this.clearActorFields(a);
                        $this.actor_$eq(null);
                    }
                }
                try {
                    $this.unwatchWatchedActors(a);
                    throw throwable9;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                    }
                    $this.clearActorFields(a);
                    $this.actor_$eq(null);
                }
            }
            try {
                $this.tellWatchersWeDied(a);
            }
            catch (Throwable throwable11) {
                try {
                    $this.unwatchWatchedActors(a);
                    throw throwable11;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                    }
                    $this.clearActorFields(a);
                    $this.actor_$eq(null);
                }
            }
            try {
                $this.unwatchWatchedActors(a);
                throw throwable;
            }
            finally {
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                }
                $this.clearActorFields(a);
                $this.actor_$eq(null);
            }
        }
        try {
            $this.parent().sendSystemMessage(new ChildTerminated($this.self()));
        }
        catch (Throwable throwable) {
            try {
                $this.tellWatchersWeDied(a);
            }
            catch (Throwable throwable12) {
                try {
                    $this.unwatchWatchedActors(a);
                    throw throwable12;
                }
                finally {
                    if ($this.system().settings().DebugLifecycle()) {
                        $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                    }
                    $this.clearActorFields(a);
                    $this.actor_$eq(null);
                }
            }
            try {
                $this.unwatchWatchedActors(a);
                throw throwable;
            }
            finally {
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                }
                $this.clearActorFields(a);
                $this.actor_$eq(null);
            }
        }
        try {
            $this.tellWatchersWeDied(a);
        }
        catch (Throwable throwable) {
            try {
                $this.unwatchWatchedActors(a);
                throw throwable;
            }
            finally {
                if ($this.system().settings().DebugLifecycle()) {
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
                }
                $this.clearActorFields(a);
                $this.actor_$eq(null);
            }
        }
        try {
            $this.unwatchWatchedActors(a);
            return;
        }
        finally {
            if ($this.system().settings().DebugLifecycle()) {
                $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(a), "stopped"));
            }
            $this.clearActorFields(a);
            $this.actor_$eq(null);
        }
    }

    private static void finishRecreate(ActorCell $this, Throwable cause, Actor failedActor) {
        block8: {
            try {
                Actor freshActor;
                Iterable<ActorRef> survivors;
                block7: {
                    FaultHandling$class.resumeNonRecursive($this);
                    survivors = $this.children();
                    freshActor = $this.newActor();
                    $this.actor_$eq(freshActor);
                    if (freshActor == failedActor) {
                        $this.setActorFields(freshActor, $this, $this.self());
                    }
                    freshActor.postRestart(cause);
                    if (!$this.system().settings().DebugLifecycle()) break block7;
                    $this.publish(new Logging.Debug($this.self().path().toString(), $this.clazz(freshActor), "restarted"));
                }
                survivors.foreach((Function1)new Serializable($this, cause, freshActor){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ActorCell $outer;
                    private final Throwable cause$1;
                    private final Actor freshActor$1;

                    public final void apply(ActorRef child) {
                        try {
                            ((InternalActorRef)child).restart(this.cause$1);
                        }
                        catch (Throwable throwable) {
                            Throwable x4 = throwable;
                            Option o11 = NonFatal$.MODULE$.unapply(x4);
                            if (o11.isEmpty()) {
                                throw throwable;
                            }
                            Throwable e = (Throwable)o11.get();
                            this.$outer.publish(new Logging.Error(e, this.$outer.self().path().toString(), this.$outer.clazz(this.freshActor$1), new StringBuilder().append((Object)"restarting ").append((Object)child).toString()));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.cause$1 = cause$1;
                        this.freshActor$1 = freshActor$1;
                    }
                });
                break block8;
                finally {
                    FaultHandling$class.clearFailed($this);
                }
            }
            catch (Throwable throwable) {
                Throwable x4 = throwable;
                Option o11 = NonFatal$.MODULE$.unapply(x4);
                if (o11.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)o11.get();
                $this.clearActorFields($this.actor());
                $this.handleInvokeFailure(new PostRestartException((ActorRef)$this.self(), e, cause), e.getMessage());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static final void handleFailure(ActorCell $this, ActorRef child, Throwable cause) {
        Option<ChildRestartStats> option;
        block5: {
            block4: {
                block2: {
                    block3: {
                        Some x2;
                        option = $this.getChildByRef(child);
                        if (!(option instanceof Some) || (x2 = (Some)option) == null) break block2;
                        ChildRestartStats stats2 = (ChildRestartStats)x2.x();
                        if (!$this.actor().supervisorStrategy().handleFailure($this, child, cause, stats2, $this.getAllChildStats())) break block3;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    throw cause;
                }
                None$ none$ = None$.MODULE$;
                Option<ChildRestartStats> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block5;
                Option<ChildRestartStats> x3 = option;
                $this.publish(new Logging.Warning($this.self().path().toString(), $this.clazz($this.actor()), new StringBuilder().append((Object)"dropping Failed(").append((Object)cause).append((Object)") from unknown child ").append((Object)child).toString()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void handleChildTerminated(ActorCell $this, ActorRef child) {
        Option<ChildrenContainer.SuspendReason> status = $this.removeChildAndGetStateChange(child);
        try {
            $this.actor().supervisorStrategy().handleChildTerminated($this, child, $this.children());
        }
        catch (Throwable throwable) {
            Throwable x4 = throwable;
            Option o11 = NonFatal$.MODULE$.unapply(x4);
            if (o11.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)o11.get();
            $this.handleInvokeFailure(e, "handleChildTerminated failed");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        boolean rc9 = false;
        Some x3 = null;
        Option<ChildrenContainer.SuspendReason> option = status;
        if (option instanceof Some) {
            ChildrenContainer.Recreation x4;
            ChildrenContainer.SuspendReason p2;
            rc9 = true;
            x3 = (Some)option;
            if (x3 != null && (p2 = (ChildrenContainer.SuspendReason)x3.x()) instanceof ChildrenContainer.Recreation && (x4 = (ChildrenContainer.Recreation)p2) != null) {
                Throwable cause = x4.cause();
                FaultHandling$class.finishRecreate($this, cause, $this.actor());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (rc9 && x3 != null) {
            ChildrenContainer.SuspendReason p5 = (ChildrenContainer.SuspendReason)x3.x();
            ChildrenContainer$Termination$ childrenContainer$Termination$ = ChildrenContainer$Termination$.MODULE$;
            ChildrenContainer.SuspendReason suspendReason = p5;
            if (!(childrenContainer$Termination$ != null ? !childrenContainer$Termination$.equals(suspendReason) : suspendReason != null)) {
                ChildrenContainer.SuspendReason x7 = p5;
                FaultHandling$class.finishTerminate($this);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static void $init$(ActorCell $this) {
        $this.akka$actor$cell$FaultHandling$$_failed_$eq(false);
    }
}

