/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.cell;

import akka.actor.ActorCell;
import akka.actor.ActorPath$;
import akka.actor.ActorRef;
import akka.actor.ChildRestartStats;
import akka.actor.ChildStats;
import akka.actor.Deploy;
import akka.actor.InternalActorRef;
import akka.actor.InvalidActorNameException;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.Props;
import akka.actor.RepointableRef;
import akka.actor.cell.AbstractActorCell;
import akka.actor.cell.ChildrenContainer;
import akka.actor.cell.ChildrenContainer$EmptyChildrenContainer$;
import akka.actor.cell.ChildrenContainer$TerminatedChildrenContainer$;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.util.Helpers$;
import akka.util.Unsafe;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public abstract class Children$class {
    public static ChildrenContainer childrenRefs(ActorCell $this) {
        return (ChildrenContainer)Unsafe.instance.getObjectVolatile($this, AbstractActorCell.childrenOffset);
    }

    public static final Iterable children(ActorCell $this) {
        return $this.childrenRefs().children();
    }

    public static final java.lang.Iterable getChildren(ActorCell $this) {
        return (java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter($this.children()).asJava();
    }

    public static ActorRef actorOf(ActorCell $this, Props props) {
        return Children$class.makeChild($this, $this, props, $this.randomName(), false);
    }

    public static ActorRef actorOf(ActorCell $this, Props props, String name) {
        return Children$class.makeChild($this, $this, props, Children$class.checkName($this, name), false);
    }

    public static ActorRef attachChild(ActorCell $this, Props props) {
        return Children$class.makeChild($this, $this, props, $this.randomName(), true);
    }

    public static ActorRef attachChild(ActorCell $this, Props props, String name) {
        return Children$class.makeChild($this, $this, props, Children$class.checkName($this, name), true);
    }

    public static final String randomName(ActorCell $this) {
        return Helpers$.MODULE$.base64(Children$class.inc$1($this), Helpers$.MODULE$.base64$default$2());
    }

    public static final void stop(ActorCell $this, ActorRef actor) {
        boolean bl;
        ActorRef actorRef = actor;
        if (actorRef instanceof RepointableRef) {
            ActorRef x2 = actorRef;
            bl = ((RepointableRef)((Object)x2)).isStarted();
        } else {
            bl = true;
        }
        boolean started = bl;
        Object object = $this.childrenRefs().getByRef(actor).isDefined() && started ? BoxesRunTime.boxToBoolean((boolean)$this.shallDie(actor)) : BoxedUnit.UNIT;
        ((InternalActorRef)actor).stop();
    }

    private static boolean swapChildrenRefs(ActorCell $this, ChildrenContainer oldChildren, ChildrenContainer newChildren) {
        return Unsafe.instance.compareAndSwapObject($this, AbstractActorCell.childrenOffset, oldChildren, newChildren);
    }

    public static final boolean reserveChild(ActorCell $this, String name) {
        while (true) {
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), c.reserve(name))) continue;
            return true;
        }
    }

    public static final boolean unreserveChild(ActorCell $this, String name) {
        while (true) {
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), c.unreserve(name))) continue;
            return true;
        }
    }

    public static final boolean addChild(ActorCell $this, ActorRef ref) {
        return $this.childrenRefs().getByRef(ref).isEmpty() ? Children$class.rec$1($this, ref) : false;
    }

    public static final boolean shallDie(ActorCell $this, ActorRef ref) {
        while (true) {
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), c.shallDie(ref))) continue;
            return true;
        }
    }

    private static final ChildrenContainer removeChild(ActorCell $this, ActorRef ref) {
        while (true) {
            ChildrenContainer n;
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), n = c.remove(ref))) continue;
            return n;
        }
    }

    public static final boolean setChildrenTerminationReason(ActorCell $this, ChildrenContainer.SuspendReason reason) {
        boolean bl;
        block1: {
            ChildrenContainer childrenContainer;
            while ((childrenContainer = $this.childrenRefs()) instanceof ChildrenContainer.TerminatingChildrenContainer) {
                Set<ActorRef> x$4;
                ChildrenContainer.TerminatingChildrenContainer x2 = (ChildrenContainer.TerminatingChildrenContainer)childrenContainer;
                ChildrenContainer.SuspendReason x$2 = reason;
                TreeMap<String, ChildStats> x$3 = x2.copy$default$1();
                if (!Children$class.swapChildrenRefs($this, x2, x2.copy(x$3, x$4 = x2.copy$default$2(), x$2))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final void setTerminated(ActorCell $this) {
        Unsafe.instance.putObjectVolatile($this, AbstractActorCell.childrenOffset, ChildrenContainer$TerminatedChildrenContainer$.MODULE$);
    }

    public static boolean isNormal(ActorCell $this) {
        return $this.childrenRefs().isNormal();
    }

    public static boolean isTerminating(ActorCell $this) {
        return $this.childrenRefs().isTerminating();
    }

    public static void suspendChildren(ActorCell $this, Set skip) {
        $this.childrenRefs().stats().foreach((Function1)new Serializable($this, skip){
            public static final long serialVersionUID = 0L;
            private final Set skip$1;

            /*
             * Enabled aggressive block sorting
             */
            public final void apply(ChildRestartStats x0$1) {
                ChildRestartStats childRestartStats = x0$1;
                if (childRestartStats != null) {
                    ActorRef child = childRestartStats.child();
                    int p2 = childRestartStats.maxNrOfRetriesCount();
                    long p3 = childRestartStats.restartTimeWindowStartNanos();
                    if (!this.skip$1.contains((Object)child)) {
                        ((InternalActorRef)child).suspend();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                this.skip$1 = skip$1;
            }
        });
    }

    public static Set suspendChildren$default$1(ActorCell $this) {
        return Predef$.MODULE$.Set().empty();
    }

    public static void resumeChildren(ActorCell $this) {
        $this.childrenRefs().stats().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(ChildRestartStats x$1) {
                ((InternalActorRef)x$1.child()).resume(false);
            }
        });
    }

    public static Option getChildByName(ActorCell $this, String name) {
        return $this.childrenRefs().getByName(name);
    }

    public static Option getChildByRef(ActorCell $this, ActorRef ref) {
        return $this.childrenRefs().getByRef(ref);
    }

    public static Iterable getAllChildStats(ActorCell $this) {
        return $this.childrenRefs().stats();
    }

    public static Option removeChildAndGetStateChange(ActorCell $this, ActorRef child) {
        None$ none$;
        ChildrenContainer.TerminatingChildrenContainer x4;
        ChildrenContainer childrenContainer = $this.childrenRefs();
        if (childrenContainer instanceof ChildrenContainer.TerminatingChildrenContainer && (x4 = (ChildrenContainer.TerminatingChildrenContainer)childrenContainer) != null) {
            TreeMap<String, ChildStats> p2 = x4.c();
            Set<ActorRef> p3 = x4.toDie();
            ChildrenContainer.SuspendReason reason = x4.reason();
            ChildrenContainer newContainer = Children$class.removeChild($this, child);
            none$ = newContainer instanceof ChildrenContainer.TerminatingChildrenContainer ? None$.MODULE$ : new Some((Object)reason);
        } else {
            Children$class.removeChild($this, child);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private static String checkName(ActorCell $this, String name) {
        String string = name;
        if (string == null) {
            String x3 = string;
            throw new InvalidActorNameException("actor name must not be null");
        }
        String string2 = string;
        if (!("" != null ? !"".equals(string2) : string2 != null)) {
            String x4 = string;
            throw new InvalidActorNameException("actor name must not be empty");
        }
        Option o11 = ActorPath$.MODULE$.ElementRegex().unapplySeq((Object)string);
        if (!o11.isEmpty() && o11.get() != null && ((LinearSeqOptimized)o11.get()).lengthCompare(0) == 0) {
            String string3 = name;
            return string3;
        }
        throw new InvalidActorNameException(new StringBuilder().append((Object)"illegal actor name '").append((Object)name).append((Object)"', must conform to ").append((Object)ActorPath$.MODULE$.ElementRegex()).toString());
    }

    private static ActorRef makeChild(ActorCell $this, ActorCell cell, Props props, String name, boolean async2) {
        InternalActorRef actor;
        if (cell.system().settings().SerializeAllCreators() && !(props.creator() instanceof NoSerializationVerificationNeeded)) {
            Right x3;
            Left x2;
            Serialization ser = (Serialization)SerializationExtension$.MODULE$.apply(cell.system());
            Either<Throwable, byte[]> either = ser.serialize(props.creator());
            if (either instanceof Left && (x2 = (Left)either) != null) {
                Throwable t = (Throwable)x2.a();
                throw t;
            }
            if (either instanceof Right && (x3 = (Right)either) != null) {
                Left x22;
                byte[] bytes = (byte[])x3.b();
                Either<Throwable, Object> either2 = ser.deserialize(bytes, props.creator().getClass());
                if (either2 instanceof Left && (x22 = (Left)either2) != null) {
                    Throwable t = (Throwable)x22.a();
                    throw t;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(either);
            }
        }
        if (cell.childrenRefs().isTerminating()) {
            throw new IllegalStateException("cannot create children while terminating or terminated");
        }
        $this.reserveChild(name);
        try {
            actor = cell.provider().actorOf(cell.systemImpl(), props, cell.self(), cell.self().path().$div(name), false, (Option<Deploy>)None$.MODULE$, true, async2);
            $this.addChild(actor);
        }
        catch (Throwable throwable) {
            Throwable x4 = throwable;
            Option o11 = NonFatal$.MODULE$.unapply(x4);
            if (o11.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)o11.get();
            $this.unreserveChild(name);
            throw e;
        }
        return actor;
    }

    private static final long inc$1(ActorCell $this) {
        while (true) {
            long current;
            if (!Unsafe.instance.compareAndSwapLong($this, AbstractActorCell.nextNameOffset, current = Unsafe.instance.getLongVolatile($this, AbstractActorCell.nextNameOffset), current + 1L)) continue;
            return current;
        }
    }

    private static final boolean rec$1(ActorCell $this, ActorRef ref$1) {
        while (true) {
            ChildrenContainer c;
            if (!Children$class.swapChildrenRefs($this, c = $this.childrenRefs(), c.add(ref$1))) continue;
            return true;
        }
    }

    public static void $init$(ActorCell $this) {
        $this.akka$actor$cell$Children$$_childrenRefsDoNotCallMeDirectly_$eq(ChildrenContainer$EmptyChildrenContainer$.MODULE$);
        $this.akka$actor$cell$Children$$_nextNameDoNotCallMeDirectly_$eq(0L);
    }
}

