/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.cell;

import akka.actor.ActorCell;
import akka.actor.ActorRef;
import akka.actor.cell.AbstractActorCell;
import akka.dispatch.Create;
import akka.dispatch.Envelope$;
import akka.dispatch.Mailbox;
import akka.dispatch.MessageDispatcher;
import akka.dispatch.Recreate;
import akka.dispatch.Resume;
import akka.dispatch.Supervise;
import akka.dispatch.Suspend;
import akka.dispatch.SystemMessage;
import akka.dispatch.Terminate;
import akka.util.Unsafe;

public abstract class Dispatch$class {
    public static final Mailbox mailbox(ActorCell $this) {
        return (Mailbox)Unsafe.instance.getObjectVolatile($this, AbstractActorCell.mailboxOffset);
    }

    public static final Mailbox swapMailbox(ActorCell $this, Mailbox newMailbox) {
        while (true) {
            Mailbox oldMailbox;
            if (!Unsafe.instance.compareAndSwapObject($this, AbstractActorCell.mailboxOffset, oldMailbox = $this.mailbox(), newMailbox)) continue;
            return oldMailbox;
        }
    }

    public static final boolean hasMessages(ActorCell $this) {
        return $this.mailbox().hasMessages();
    }

    public static final int numberOfMessages(ActorCell $this) {
        return $this.mailbox().numberOfMessages();
    }

    public static final MessageDispatcher getDispatcher(ActorCell $this) {
        return $this.dispatcher();
    }

    public static final boolean isTerminated(ActorCell $this) {
        return $this.mailbox().isClosed();
    }

    public static final ActorCell start(ActorCell $this, boolean sendSupervise) {
        $this.swapMailbox($this.dispatcher().createMailbox($this));
        $this.mailbox().setActor($this);
        $this.mailbox().systemEnqueue($this.self(), new Create());
        if (sendSupervise) {
            $this.parent().sendSystemMessage(new Supervise($this.self()));
        }
        $this.dispatcher().attach($this);
        return $this;
    }

    public static final void suspend(ActorCell $this) {
        $this.dispatcher().systemDispatch($this, new Suspend());
    }

    public static final void resume(ActorCell $this, boolean inResponseToFailure) {
        $this.dispatcher().systemDispatch($this, new Resume(inResponseToFailure));
    }

    public static final void restart(ActorCell $this, Throwable cause) {
        $this.dispatcher().systemDispatch($this, new Recreate(cause));
    }

    public static final void stop(ActorCell $this) {
        $this.dispatcher().systemDispatch($this, new Terminate());
    }

    public static void tell(ActorCell $this, Object message, ActorRef sender) {
        $this.dispatcher().dispatch($this, Envelope$.MODULE$.apply(message, sender == null ? $this.system().deadLetters() : sender, $this.system()));
    }

    public static void sendSystemMessage(ActorCell $this, SystemMessage message) {
        $this.dispatcher().systemDispatch($this, message);
    }

    public static void $init$(ActorCell $this) {
        $this.akka$actor$cell$Dispatch$_setter_$dispatcher_$eq($this.system().dispatchers().lookup($this.props().dispatcher()));
    }
}

