/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.NumericRange;
import scala.collection.mutable.StringBuilder;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Numeric$BigDecimalAsIfIntegral$;
import scala.math.Numeric$BigIntIsIntegral$;
import scala.math.Numeric$ByteIsIntegral$;
import scala.math.Numeric$CharIsIntegral$;
import scala.math.Numeric$DoubleAsIfIntegral$;
import scala.math.Numeric$FloatAsIfIntegral$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.Numeric$ShortIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$BigDecimal$;
import scala.math.Ordering$BigInt$;
import scala.math.Ordering$Byte$;
import scala.math.Ordering$Char$;
import scala.math.Ordering$Double$;
import scala.math.Ordering$Float$;
import scala.math.Ordering$Int$;
import scala.math.Ordering$Long$;
import scala.math.Ordering$Short$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NumericRange$
implements Serializable {
    public static final NumericRange$ MODULE$;
    private final Map<Numeric<?>, Ordering<?>> defaultOrdering;

    static {
        new NumericRange$();
    }

    public <T> int count(T start, T end, T step, boolean isInclusive, Integral<T> num) {
        int n;
        Object zero2 = num.zero();
        boolean upward = num.lt(start, end);
        boolean posStep = num.gt(step, zero2);
        if (BoxesRunTime.equals(step, zero2)) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        if (BoxesRunTime.equals(start, end)) {
            n = isInclusive ? 1 : 0;
        } else if (upward != posStep) {
            n = 0;
        } else {
            boolean isOverflow;
            T diff2 = num.minus(end, start);
            long jumps = num.toLong(num.quot(diff2, step));
            T remainder = num.rem(diff2, step);
            long longCount = jumps + (long)(!isInclusive && BoxesRunTime.equals(zero2, remainder) ? 0 : 1);
            boolean bl = isOverflow = longCount == 0L && num.lt(num.plus(start, step), end) == upward;
            if (longCount > Integer.MAX_VALUE || longCount < 0L || isOverflow) {
                String word = isInclusive ? "to" : "until";
                String descr = List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray(new Object[]{start, word, end, "by", step})).mkString(" ");
                throw new IllegalArgumentException(new StringBuilder().append((Object)descr).append((Object)": seqs cannot contain more than Int.MaxValue elements.").toString());
            }
            n = (int)longCount;
        }
        return n;
    }

    public <T> NumericRange.Exclusive<T> apply(T start, T end, T step, Integral<T> num) {
        return new NumericRange.Exclusive<T>(start, end, step, num);
    }

    public <T> NumericRange.Inclusive<T> inclusive(T start, T end, T step, Integral<T> num) {
        return new NumericRange.Inclusive<T>(start, end, step, num);
    }

    public Map<Numeric<?>, Ordering<?>> defaultOrdering() {
        return this.defaultOrdering;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private NumericRange$() {
        MODULE$ = this;
        this.defaultOrdering = (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.extension$$minus$greater(Predef$.MODULE$.any2ArrowAssoc(Numeric$BigIntIsIntegral$.MODULE$), Ordering$BigInt$.MODULE$), Predef$ArrowAssoc$.MODULE$.extension$$minus$greater(Predef$.MODULE$.any2ArrowAssoc(Numeric$IntIsIntegral$.MODULE$), Ordering$Int$.MODULE$), Predef$ArrowAssoc$.MODULE$.extension$$minus$greater(Predef$.MODULE$.any2ArrowAssoc(Numeric$ShortIsIntegral$.MODULE$), Ordering$Short$.MODULE$), Predef$ArrowAssoc$.MODULE$.extension$$minus$greater(Predef$.MODULE$.any2ArrowAssoc(Numeric$ByteIsIntegral$.MODULE$), Ordering$Byte$.MODULE$), Predef$ArrowAssoc$.MODULE$.extension$$minus$greater(Predef$.MODULE$.any2ArrowAssoc(Numeric$CharIsIntegral$.MODULE$), Ordering$Char$.MODULE$), Predef$ArrowAssoc$.MODULE$.extension$$minus$greater(Predef$.MODULE$.any2ArrowAssoc(Numeric$LongIsIntegral$.MODULE$), Ordering$Long$.MODULE$), Predef$ArrowAssoc$.MODULE$.extension$$minus$greater(Predef$.MODULE$.any2ArrowAssoc(Numeric$FloatAsIfIntegral$.MODULE$), Ordering$Float$.MODULE$), Predef$ArrowAssoc$.MODULE$.extension$$minus$greater(Predef$.MODULE$.any2ArrowAssoc(Numeric$DoubleAsIfIntegral$.MODULE$), Ordering$Double$.MODULE$), Predef$ArrowAssoc$.MODULE$.extension$$minus$greater(Predef$.MODULE$.any2ArrowAssoc(Numeric$BigDecimalAsIfIntegral$.MODULE$), Ordering$BigDecimal$.MODULE$)}));
    }
}

