/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigDelayedMerge;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ReplaceableMergeStack;
import com.typesafe.config.impl.ResolveContext;
import com.typesafe.config.impl.ResolveReplacer;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.Unmergeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ConfigDelayedMergeObject
extends AbstractConfigObject
implements Unmergeable,
ReplaceableMergeStack {
    private final List<AbstractConfigValue> stack;

    ConfigDelayedMergeObject(ConfigOrigin configOrigin, List<AbstractConfigValue> list) {
        super(configOrigin);
        this.stack = list;
        if (list.isEmpty()) {
            throw new ConfigException.BugOrBroken("creating empty delayed merge object");
        }
        if (!(list.get(0) instanceof AbstractConfigObject)) {
            throw new ConfigException.BugOrBroken("created a delayed merge object not guaranteed to be an object");
        }
        for (AbstractConfigValue abstractConfigValue : list) {
            if (!(abstractConfigValue instanceof ConfigDelayedMerge) && !(abstractConfigValue instanceof ConfigDelayedMergeObject)) continue;
            throw new ConfigException.BugOrBroken("placed nested DelayedMerge in a ConfigDelayedMergeObject, should have consolidated stack");
        }
    }

    @Override
    protected ConfigDelayedMergeObject newCopy(ResolveStatus resolveStatus, ConfigOrigin configOrigin) {
        if (resolveStatus != this.resolveStatus()) {
            throw new ConfigException.BugOrBroken("attempt to create resolved ConfigDelayedMergeObject");
        }
        return new ConfigDelayedMergeObject(configOrigin, this.stack);
    }

    @Override
    AbstractConfigObject resolveSubstitutions(ResolveContext resolveContext) throws AbstractConfigValue.NotPossibleToResolve {
        AbstractConfigValue abstractConfigValue = ConfigDelayedMerge.resolveSubstitutions(this, this.stack, resolveContext);
        if (abstractConfigValue instanceof AbstractConfigObject) {
            return (AbstractConfigObject)abstractConfigValue;
        }
        throw new ConfigException.BugOrBroken("somehow brokenly merged an object and didn't get an object, got " + abstractConfigValue);
    }

    @Override
    public ResolveReplacer makeReplacer(final int n) {
        return new ResolveReplacer(){

            @Override
            protected AbstractConfigValue makeReplacement(ResolveContext resolveContext) throws AbstractConfigValue.NotPossibleToResolve {
                return ConfigDelayedMerge.makeReplacement(resolveContext, ConfigDelayedMergeObject.this.stack, n);
            }
        };
    }

    @Override
    ResolveStatus resolveStatus() {
        return ResolveStatus.UNRESOLVED;
    }

    @Override
    ConfigDelayedMergeObject relativized(Path path) {
        ArrayList<AbstractConfigValue> arrayList = new ArrayList<AbstractConfigValue>();
        for (AbstractConfigValue abstractConfigValue : this.stack) {
            arrayList.add(abstractConfigValue.relativized(path));
        }
        return new ConfigDelayedMergeObject(this.origin(), arrayList);
    }

    @Override
    protected boolean ignoresFallbacks() {
        return ConfigDelayedMerge.stackIgnoresFallbacks(this.stack);
    }

    @Override
    protected final ConfigDelayedMergeObject mergedWithTheUnmergeable(Unmergeable unmergeable) {
        this.requireNotIgnoringFallbacks();
        return (ConfigDelayedMergeObject)this.mergedWithTheUnmergeable(this.stack, unmergeable);
    }

    @Override
    protected final ConfigDelayedMergeObject mergedWithObject(AbstractConfigObject abstractConfigObject) {
        return this.mergedWithNonObject(abstractConfigObject);
    }

    @Override
    protected final ConfigDelayedMergeObject mergedWithNonObject(AbstractConfigValue abstractConfigValue) {
        this.requireNotIgnoringFallbacks();
        return (ConfigDelayedMergeObject)this.mergedWithNonObject(this.stack, abstractConfigValue);
    }

    @Override
    public ConfigDelayedMergeObject withFallback(ConfigMergeable configMergeable) {
        return (ConfigDelayedMergeObject)super.withFallback(configMergeable);
    }

    @Override
    public ConfigDelayedMergeObject withOnlyKey(String string) {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public ConfigDelayedMergeObject withoutKey(String string) {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    protected AbstractConfigObject withOnlyPathOrNull(Path path) {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    AbstractConfigObject withOnlyPath(Path path) {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    AbstractConfigObject withoutPath(Path path) {
        throw ConfigDelayedMergeObject.notResolved();
    }

    public Collection<AbstractConfigValue> unmergedValues() {
        return this.stack;
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof ConfigDelayedMergeObject;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ConfigDelayedMergeObject) {
            return this.canEqual(object) && ((Object)this.stack).equals(((ConfigDelayedMergeObject)object).stack);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.stack).hashCode();
    }

    @Override
    protected void render(StringBuilder stringBuilder, int n, String string, ConfigRenderOptions configRenderOptions) {
        ConfigDelayedMerge.render(this.stack, stringBuilder, n, string, configRenderOptions);
    }

    @Override
    protected void render(StringBuilder stringBuilder, int n, ConfigRenderOptions configRenderOptions) {
        this.render(stringBuilder, n, null, configRenderOptions);
    }

    private static ConfigException notResolved() {
        return new ConfigException.NotResolved("need to Config#resolve() before using this object, see the API docs for Config#resolve()");
    }

    @Override
    public Map<String, Object> unwrapped() {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public AbstractConfigValue get(Object object) {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public boolean containsKey(Object object) {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public boolean containsValue(Object object) {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public Set<Map.Entry<String, ConfigValue>> entrySet() {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public boolean isEmpty() {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public Set<String> keySet() {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public int size() {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    public Collection<ConfigValue> values() {
        throw ConfigDelayedMergeObject.notResolved();
    }

    @Override
    protected AbstractConfigValue attemptPeekWithPartialResolve(String string) {
        for (AbstractConfigValue abstractConfigValue : this.stack) {
            if (abstractConfigValue instanceof AbstractConfigObject) {
                AbstractConfigObject abstractConfigObject = (AbstractConfigObject)abstractConfigValue;
                AbstractConfigValue abstractConfigValue2 = abstractConfigObject.attemptPeekWithPartialResolve(string);
                if (abstractConfigValue2 != null) {
                    if (!abstractConfigValue2.ignoresFallbacks()) continue;
                    return abstractConfigValue2;
                }
                if (!(abstractConfigValue instanceof Unmergeable)) continue;
                throw new ConfigException.BugOrBroken("should not be reached: unmergeable object returned null value");
            }
            if (abstractConfigValue instanceof Unmergeable) {
                throw new ConfigException.NotResolved("Key '" + string + "' is not available at '" + this.origin().description() + "' because value at '" + abstractConfigValue.origin().description() + "' has not been resolved and may turn out to contain or hide '" + string + "'." + " Be sure to Config#resolve() before using a config object.");
            }
            if (abstractConfigValue.resolveStatus() == ResolveStatus.UNRESOLVED) {
                if (!(abstractConfigValue instanceof ConfigList)) {
                    throw new ConfigException.BugOrBroken("Expecting a list here, not " + abstractConfigValue);
                }
                return null;
            }
            if (!abstractConfigValue.ignoresFallbacks()) {
                throw new ConfigException.BugOrBroken("resolved non-object should ignore fallbacks");
            }
            return null;
        }
        throw new ConfigException.BugOrBroken("Delayed merge stack does not contain any unmergeable values");
    }
}

