/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config;

import com.typesafe.config.ConfigOrigin;

public abstract class ConfigException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final ConfigOrigin origin;

    protected ConfigException(ConfigOrigin configOrigin, String string, Throwable throwable) {
        super(configOrigin.description() + ": " + string, throwable);
        this.origin = configOrigin;
    }

    protected ConfigException(ConfigOrigin configOrigin, String string) {
        this(configOrigin.description() + ": " + string, null);
    }

    protected ConfigException(String string, Throwable throwable) {
        super(string, throwable);
        this.origin = null;
    }

    protected ConfigException(String string) {
        this(string, null);
    }

    public ConfigOrigin origin() {
        return this.origin;
    }

    public static class Generic
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public Generic(String string, Throwable throwable) {
            super(string, throwable);
        }

        public Generic(String string) {
            this(string, null);
        }
    }

    public static class ValidationFailed
    extends ConfigException {
        private static final long serialVersionUID = 1L;
        private final Iterable<ValidationProblem> problems;

        public ValidationFailed(Iterable<ValidationProblem> iterable) {
            super(ValidationFailed.makeMessage(iterable), null);
            this.problems = iterable;
        }

        public Iterable<ValidationProblem> problems() {
            return this.problems;
        }

        private static String makeMessage(Iterable<ValidationProblem> iterable) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ValidationProblem validationProblem : iterable) {
                stringBuilder.append(validationProblem.origin().description());
                stringBuilder.append(": ");
                stringBuilder.append(validationProblem.path());
                stringBuilder.append(": ");
                stringBuilder.append(validationProblem.problem());
                stringBuilder.append(", ");
            }
            if (stringBuilder.length() == 0) {
                throw new BugOrBroken("ValidationFailed must have a non-empty list of problems");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            return stringBuilder.toString();
        }
    }

    public static class ValidationProblem {
        private final String path;
        private final ConfigOrigin origin;
        private final String problem;

        public ValidationProblem(String string, ConfigOrigin configOrigin, String string2) {
            this.path = string;
            this.origin = configOrigin;
            this.problem = string2;
        }

        public String path() {
            return this.path;
        }

        public ConfigOrigin origin() {
            return this.origin;
        }

        public String problem() {
            return this.problem;
        }
    }

    public static class NotResolved
    extends BugOrBroken {
        private static final long serialVersionUID = 1L;

        public NotResolved(String string, Throwable throwable) {
            super(string, throwable);
        }

        public NotResolved(String string) {
            this(string, null);
        }
    }

    public static class UnresolvedSubstitution
    extends Parse {
        private static final long serialVersionUID = 1L;

        public UnresolvedSubstitution(ConfigOrigin configOrigin, String string, Throwable throwable) {
            super(configOrigin, "Could not resolve substitution to a value: " + string, throwable);
        }

        public UnresolvedSubstitution(ConfigOrigin configOrigin, String string) {
            this(configOrigin, string, null);
        }
    }

    public static class Parse
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public Parse(ConfigOrigin configOrigin, String string, Throwable throwable) {
            super(configOrigin, string, throwable);
        }

        public Parse(ConfigOrigin configOrigin, String string) {
            this(configOrigin, string, null);
        }
    }

    public static class IO
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public IO(ConfigOrigin configOrigin, String string, Throwable throwable) {
            super(configOrigin, string, throwable);
        }

        public IO(ConfigOrigin configOrigin, String string) {
            this(configOrigin, string, null);
        }
    }

    public static class BugOrBroken
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public BugOrBroken(String string, Throwable throwable) {
            super(string, throwable);
        }

        public BugOrBroken(String string) {
            this(string, null);
        }
    }

    public static class BadPath
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public BadPath(ConfigOrigin configOrigin, String string, String string2, Throwable throwable) {
            super(configOrigin, string != null ? "Invalid path '" + string + "': " + string2 : string2, throwable);
        }

        public BadPath(ConfigOrigin configOrigin, String string, String string2) {
            this(configOrigin, string, string2, null);
        }

        public BadPath(String string, String string2, Throwable throwable) {
            super(string != null ? "Invalid path '" + string + "': " + string2 : string2, throwable);
        }

        public BadPath(String string, String string2) {
            this(string, string2, null);
        }

        public BadPath(ConfigOrigin configOrigin, String string) {
            this(configOrigin, null, string);
        }
    }

    public static class BadValue
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public BadValue(ConfigOrigin configOrigin, String string, String string2, Throwable throwable) {
            super(configOrigin, "Invalid value at '" + string + "': " + string2, throwable);
        }

        public BadValue(ConfigOrigin configOrigin, String string, String string2) {
            this(configOrigin, string, string2, null);
        }

        public BadValue(String string, String string2, Throwable throwable) {
            super("Invalid value at '" + string + "': " + string2, throwable);
        }

        public BadValue(String string, String string2) {
            this(string, string2, null);
        }
    }

    public static class Null
    extends Missing {
        private static final long serialVersionUID = 1L;

        private static String makeMessage(String string, String string2) {
            if (string2 != null) {
                return "Configuration key '" + string + "' is set to null but expected " + string2;
            }
            return "Configuration key '" + string + "' is null";
        }

        public Null(ConfigOrigin configOrigin, String string, String string2, Throwable throwable) {
            super(configOrigin, Null.makeMessage(string, string2), throwable);
        }

        public Null(ConfigOrigin configOrigin, String string, String string2) {
            this(configOrigin, string, string2, null);
        }
    }

    public static class Missing
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public Missing(String string, Throwable throwable) {
            super("No configuration setting found for key '" + string + "'", throwable);
        }

        public Missing(String string) {
            this(string, null);
        }

        protected Missing(ConfigOrigin configOrigin, String string, Throwable throwable) {
            super(configOrigin, string, throwable);
        }

        protected Missing(ConfigOrigin configOrigin, String string) {
            this(configOrigin, string, null);
        }
    }

    public static class WrongType
    extends ConfigException {
        private static final long serialVersionUID = 1L;

        public WrongType(ConfigOrigin configOrigin, String string, String string2, String string3, Throwable throwable) {
            super(configOrigin, string + " has type " + string3 + " rather than " + string2, throwable);
        }

        public WrongType(ConfigOrigin configOrigin, String string, String string2, String string3) {
            this(configOrigin, string, string2, string3, null);
        }

        public WrongType(ConfigOrigin configOrigin, String string, Throwable throwable) {
            super(configOrigin, string, throwable);
        }

        public WrongType(ConfigOrigin configOrigin, String string) {
            super(configOrigin, string, null);
        }
    }
}

