/*
 * Decompiled with CFR 0.152.
 */
package scala.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URLClassLoader;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.convert.DecorateAsScala$class;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtils$ {
    public static final ReflectionUtils$ MODULE$;

    static {
        new ReflectionUtils$();
    }

    public Throwable unwrapThrowable(Throwable x) {
        boolean bl;
        while ((bl = x instanceof InvocationTargetException ? true : (x instanceof ExceptionInInitializerError ? true : (x instanceof UndeclaredThrowableException ? true : (x instanceof ClassNotFoundException ? true : x instanceof NoClassDefFoundError)))) && x.getCause() != null) {
            x = x.getCause();
        }
        return x;
    }

    public <T> PartialFunction<Throwable, T> unwrapHandler(PartialFunction<Throwable, T> pf$1) {
        return new Serializable(pf$1){
            public static final long serialVersionUID;
            private final PartialFunction pf$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 A1, Function1<A1, B1> function1) {
                Object object = this.pf$1.isDefinedAt(ReflectionUtils$.MODULE$.unwrapThrowable(A1)) ? this.pf$1.apply(ReflectionUtils$.MODULE$.unwrapThrowable(A1)) : function1.apply(A1);
                return object;
            }

            public final boolean isDefinedAt(Throwable throwable) {
                boolean bl = this.pf$1.isDefinedAt(ReflectionUtils$.MODULE$.unwrapThrowable(throwable));
                return bl;
            }
            {
                this.pf$1 = partialFunction;
            }
        };
    }

    private Iterator<Tuple2<String, String>> systemProperties() {
        return ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(System.getProperties()).asScala()).iterator();
    }

    /*
     * WARNING - void declaration
     */
    private String searchForBootClasspath() {
        void $inlThis4;
        void $inlThis1;
        Option option = ((MapLike)DecorateAsScala$class.propertiesAsScalaMapConverter(JavaConverters$.MODULE$, System.getProperties()).asScala()).iterator().find(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, String> tuple2) {
                return tuple2._1().endsWith(".boot.class.path");
            }
        });
        Option option2 = option.isEmpty() ? None$.MODULE$ : new Some<String>((String)((Tuple2)$inlThis1.get())._2());
        return option2.isEmpty() ? "" : $inlThis4.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String show(ClassLoader cl) {
        if (cl != null) return new StringOps("%s of type %s with classpath %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{cl, cl.getClass(), this.inferClasspath$1(cl)}));
        if (cl != null) throw new MatchError(cl);
        return new StringOps("primordial classloader with boot classpath [%s]").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.searchForBootClasspath()}));
    }

    public ClassLoader defaultReflectionClassLoader() {
        return this.getClass().getClassLoader();
    }

    public Object singletonInstance(ClassLoader cl, String className) {
        String name = className.endsWith("$") ? className : new StringBuilder().append((Object)className).append((Object)"$").toString();
        Class<?> clazz = Class.forName(name, true, cl);
        Object singleton = clazz.getField("MODULE$").get(null);
        return singleton;
    }

    public Option<Object> singletonInstanceOpt(ClassLoader cl, String className) {
        Option option;
        try {
            option = new Some<Object>(this.singletonInstance(cl, className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            option = None$.MODULE$;
        }
        return option;
    }

    public Object invokeFactory(ClassLoader cl, String className, String methodName, Seq<Object> args) {
        Object singleton = this.singletonInstance(cl, className);
        Method method = singleton.getClass().getMethod(methodName, ClassLoader.class);
        return method.invoke(singleton, (Object[])args.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public Option<Object> invokeFactoryOpt(ClassLoader cl, String className, String methodName, Seq<Object> args) {
        Option option;
        try {
            option = new Some<Object>(this.invokeFactory(cl, className, methodName, args));
        }
        catch (ClassNotFoundException classNotFoundException) {
            option = None$.MODULE$;
        }
        return option;
    }

    private final String inferClasspath$1(ClassLoader cl) {
        String string2;
        if (cl instanceof URLClassLoader) {
            URLClassLoader x2 = (URLClassLoader)cl;
            string2 = new StringBuilder().append((Object)"[").append((Object)Predef$.MODULE$.refArrayOps((Object[])x2.getURLs()).mkString(",")).append((Object)"]").toString();
        } else {
            string2 = "<unknown>";
        }
        return string2;
    }

    private ReflectionUtils$() {
        MODULE$ = this;
    }
}

