/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.util;

import java.util.concurrent.TimeUnit;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcJL$sp;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.util.Deadline;
import scala.concurrent.util.Duration;
import scala.concurrent.util.Duration$;
import scala.concurrent.util.FiniteDuration;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Duration$
implements Serializable {
    public static final Duration$ MODULE$;
    private final Regex RE;
    private final Regex REinf;
    private final Regex REminf;
    private final FiniteDuration Zero;
    private final Duration Undefined;
    private final Duration Inf;
    private final Duration MinusInf;

    static {
        new Duration$();
    }

    public Duration timeLeft(Deadline d) {
        return d.timeLeft();
    }

    public FiniteDuration apply(long length, TimeUnit unit) {
        return new FiniteDuration(length, unit);
    }

    public FiniteDuration apply(double length, TimeUnit unit) {
        return this.fromNanos((double)unit.toNanos(1L) * length);
    }

    public FiniteDuration apply(long length, String unit) {
        return new FiniteDuration(length, this.timeUnit(unit));
    }

    /*
     * WARNING - void declaration
     */
    public Duration apply(String s$1) {
        void $inlThis1;
        Serializable serializable2 = new Serializable(s$1){
            public static final long serialVersionUID;
            private final String s$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nothing$ apply() {
                return package$.MODULE$.error(new StringBuilder().append((Object)"format error ").append((Object)this.s$1).toString());
            }
            {
                this.s$1 = string2;
            }
        };
        Option<Duration> option = this.unapply(s$1);
        if (option.isEmpty()) {
            void default1;
            throw default1.apply();
        }
        return (Duration)$inlThis1.get();
    }

    private Regex RE() {
        return this.RE;
    }

    private Regex REinf() {
        return this.REinf;
    }

    private Regex REminf() {
        return this.REminf;
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(Duration d) {
        return d.finite_$qmark() ? new Some<Tuple2$mcJL$sp<TimeUnit>>(new Tuple2$mcJL$sp<TimeUnit>(d.length(), d.unit())) : None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Duration> unapply(String s) {
        void var5_7;
        Option<List<String>> o8 = this.RE().unapplySeq(s);
        if (!o8.isEmpty() && o8.get() != null && ((LinearSeqOptimized)o8.get()).lengthCompare(8) == 0) {
            Some<FiniteDuration> some;
            if (((LinearSeqOptimized)o8.get()).apply(1) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o8.get()).apply(0)), TimeUnit.DAYS));
            } else if (((LinearSeqOptimized)o8.get()).apply(2) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o8.get()).apply(0)), TimeUnit.HOURS));
            } else if (((LinearSeqOptimized)o8.get()).apply(3) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o8.get()).apply(0)), TimeUnit.MINUTES));
            } else if (((LinearSeqOptimized)o8.get()).apply(4) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o8.get()).apply(0)), TimeUnit.SECONDS));
            } else if (((LinearSeqOptimized)o8.get()).apply(5) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o8.get()).apply(0)), TimeUnit.MILLISECONDS));
            } else if (((LinearSeqOptimized)o8.get()).apply(6) != null) {
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o8.get()).apply(0)), TimeUnit.MICROSECONDS));
            } else {
                if (((LinearSeqOptimized)o8.get()).apply(7) == null) throw package$.MODULE$.error("made some error in regex (should not be possible)");
                some = new Some<FiniteDuration>(this.apply(Double.parseDouble((String)((LinearSeqOptimized)o8.get()).apply(0)), TimeUnit.NANOSECONDS));
            }
            Some<FiniteDuration> some2 = some;
            return var5_7;
        } else {
            Option<List<String>> o10 = this.REinf().unapplySeq(s);
            if (!o10.isEmpty() && o10.get() != null && ((LinearSeqOptimized)o10.get()).lengthCompare(0) == 0) {
                Some<Duration> some = new Some<Duration>(this.Inf());
                return var5_7;
            } else {
                Option<List<String>> o12 = this.REminf().unapplySeq(s);
                if (!o12.isEmpty() && o12.get() != null && ((LinearSeqOptimized)o12.get()).lengthCompare(0) == 0) {
                    Some<Duration> some = new Some<Duration>(this.MinusInf());
                    return var5_7;
                } else {
                    None$ none$ = None$.MODULE$;
                }
            }
        }
        return var5_7;
    }

    public FiniteDuration fromNanos(double nanos) {
        return this.fromNanos((long)(nanos + 0.5));
    }

    public FiniteDuration fromNanos(long nanos) {
        return nanos % 86400000000000L == 0L ? this.apply(nanos / 86400000000000L, TimeUnit.DAYS) : (nanos % 3600000000000L == 0L ? this.apply(nanos / 3600000000000L, TimeUnit.HOURS) : (nanos % 60000000000L == 0L ? this.apply(nanos / 60000000000L, TimeUnit.MINUTES) : (nanos % 1000000000L == 0L ? this.apply(nanos / 1000000000L, TimeUnit.SECONDS) : (nanos % 1000000L == 0L ? this.apply(nanos / 1000000L, TimeUnit.MILLISECONDS) : (nanos % 1000L == 0L ? this.apply(nanos / 1000L, TimeUnit.MICROSECONDS) : this.apply(nanos, TimeUnit.NANOSECONDS))))));
    }

    public TimeUnit timeUnit(String unit) {
        String string2;
        block9: {
            TimeUnit timeUnit;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        string2 = unit.toLowerCase();
                                        boolean bl = !("d" != null ? !"d".equals(string2) : string2 != null) ? true : (!("day" != null ? !"day".equals(string2) : string2 != null) ? true : !("days" != null ? !"days".equals(string2) : string2 != null));
                                        if (!bl) break block2;
                                        timeUnit = TimeUnit.DAYS;
                                        break block3;
                                    }
                                    boolean bl = !("h" != null ? !"h".equals(string2) : string2 != null) ? true : (!("hour" != null ? !"hour".equals(string2) : string2 != null) ? true : !("hours" != null ? !"hours".equals(string2) : string2 != null));
                                    if (!bl) break block4;
                                    timeUnit = TimeUnit.HOURS;
                                    break block3;
                                }
                                boolean bl = !("min" != null ? !"min".equals(string2) : string2 != null) ? true : (!("minute" != null ? !"minute".equals(string2) : string2 != null) ? true : !("minutes" != null ? !"minutes".equals(string2) : string2 != null));
                                if (!bl) break block5;
                                timeUnit = TimeUnit.MINUTES;
                                break block3;
                            }
                            boolean bl = !("s" != null ? !"s".equals(string2) : string2 != null) ? true : (!("sec" != null ? !"sec".equals(string2) : string2 != null) ? true : (!("second" != null ? !"second".equals(string2) : string2 != null) ? true : !("seconds" != null ? !"seconds".equals(string2) : string2 != null)));
                            if (!bl) break block6;
                            timeUnit = TimeUnit.SECONDS;
                            break block3;
                        }
                        boolean bl = !("ms" != null ? !"ms".equals(string2) : string2 != null) ? true : (!("milli" != null ? !"milli".equals(string2) : string2 != null) ? true : (!("millis" != null ? !"millis".equals(string2) : string2 != null) ? true : (!("millisecond" != null ? !"millisecond".equals(string2) : string2 != null) ? true : !("milliseconds" != null ? !"milliseconds".equals(string2) : string2 != null))));
                        if (!bl) break block7;
                        timeUnit = TimeUnit.MILLISECONDS;
                        break block3;
                    }
                    boolean bl = !("\u00b5s" != null ? !"\u00b5s".equals(string2) : string2 != null) ? true : (!("micro" != null ? !"micro".equals(string2) : string2 != null) ? true : (!("micros" != null ? !"micros".equals(string2) : string2 != null) ? true : (!("microsecond" != null ? !"microsecond".equals(string2) : string2 != null) ? true : !("microseconds" != null ? !"microseconds".equals(string2) : string2 != null))));
                    if (!bl) break block8;
                    timeUnit = TimeUnit.MICROSECONDS;
                    break block3;
                }
                boolean bl = !("ns" != null ? !"ns".equals(string2) : string2 != null) ? true : (!("nano" != null ? !"nano".equals(string2) : string2 != null) ? true : (!("nanos" != null ? !"nanos".equals(string2) : string2 != null) ? true : (!("nanosecond" != null ? !"nanosecond".equals(string2) : string2 != null) ? true : !("nanoseconds" != null ? !"nanoseconds".equals(string2) : string2 != null))));
                if (!bl) break block9;
                timeUnit = TimeUnit.NANOSECONDS;
            }
            return timeUnit;
        }
        throw new MatchError((Object)string2);
    }

    public FiniteDuration Zero() {
        return this.Zero;
    }

    public Duration Undefined() {
        return this.Undefined;
    }

    public Duration Inf() {
        return this.Inf;
    }

    public Duration MinusInf() {
        return this.MinusInf;
    }

    public FiniteDuration create(long length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public FiniteDuration create(double length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public FiniteDuration create(long length, String unit) {
        return this.apply(length, unit);
    }

    public Duration parse(String s) {
        return this.unapply(s).get();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Duration$() {
        MODULE$ = this;
        this.RE = new StringOps(Predef$.MODULE$.augmentString("^\\s*([\\+|-]?\\d+(?:\\.\\d+)?)\\s*(?:(d|day|days)|(h|hour|hours)|(min|minute|minutes)|(s|sec|second|seconds)|(ms|milli|millis|millisecond|milliseconds)|(\u00b5s|micro|micros|microsecond|microseconds)|(ns|nano|nanos|nanosecond|nanoseconds))\\s*$")).r();
        this.REinf = new StringOps(Predef$.MODULE$.augmentString("^\\s*(?:\\+|Plus)?Inf\\s*$")).r();
        this.REminf = new StringOps(Predef$.MODULE$.augmentString("^\\s*(?:-|Minus)Inf\\s*")).r();
        this.Zero = new FiniteDuration(0L, TimeUnit.NANOSECONDS);
        this.Undefined = new anon.1();
        this.Inf = new anon.2();
        this.MinusInf = new anon.3();
    }
}

