/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterator;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqOptimized;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.generic.CanBuildFrom;
import scala.collection.mutable.Builder;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class IndexedSeqOptimized$class {
    public static boolean isEmpty(IndexedSeqOptimized $this) {
        return $this.length() == 0;
    }

    public static void foreach(IndexedSeqOptimized $this, Function1 f) {
        int len = $this.length();
        for (int i = 0; i < len; ++i) {
            f.apply($this.apply(i));
        }
    }

    public static boolean forall(IndexedSeqOptimized $this, Function1 p$2) {
        return $this.prefixLength(new Serializable($this, p$2){
            public static final long serialVersionUID;
            private final Function1 p$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(A a) {
                return BoxesRunTime.unboxToBoolean(this.p$2.apply(a));
            }
            {
                this.p$2 = indexedSeqOptimized;
            }
        }) == $this.length();
    }

    public static boolean exists(IndexedSeqOptimized $this, Function1 p$1) {
        return $this.prefixLength(new Serializable($this, p$1){
            public static final long serialVersionUID;
            private final Function1 p$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(A a) {
                return !BoxesRunTime.unboxToBoolean(this.p$1.apply(a));
            }
            {
                this.p$1 = indexedSeqOptimized;
            }
        }) != $this.length();
    }

    public static Option find(IndexedSeqOptimized $this, Function1 p$3) {
        int i = $this.prefixLength(new Serializable($this, p$3){
            public static final long serialVersionUID;
            private final Function1 p$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(A a) {
                return !BoxesRunTime.unboxToBoolean(this.p$3.apply(a));
            }
            {
                this.p$3 = indexedSeqOptimized;
            }
        });
        return i < $this.length() ? new Some($this.apply(i)) : None$.MODULE$;
    }

    private static Object foldl(IndexedSeqOptimized $this, int start, int end, Object z, Function2 op) {
        while (start != end) {
            z = op.apply(z, $this.apply(start));
            ++start;
        }
        return z;
    }

    private static Object foldr(IndexedSeqOptimized $this, int start, int end, Object z, Function2 op) {
        while (start != end) {
            z = op.apply($this.apply(end - 1), z);
            --end;
        }
        return z;
    }

    public static Object foldLeft(IndexedSeqOptimized $this, Object z, Function2 op) {
        return IndexedSeqOptimized$class.foldl($this, 0, $this.length(), z, op);
    }

    public static Object foldRight(IndexedSeqOptimized $this, Object z, Function2 op) {
        return IndexedSeqOptimized$class.foldr($this, 0, $this.length(), z, op);
    }

    public static Object reduceLeft(IndexedSeqOptimized $this, Function2 op) {
        return $this.length() > 0 ? IndexedSeqOptimized$class.foldl($this, 1, $this.length(), $this.apply(0), op) : $this.scala$collection$IndexedSeqOptimized$$super$reduceLeft(op);
    }

    public static Object reduceRight(IndexedSeqOptimized $this, Function2 op) {
        return $this.length() > 0 ? IndexedSeqOptimized$class.foldr($this, 0, $this.length() - 1, $this.apply($this.length() - 1), op) : $this.scala$collection$IndexedSeqOptimized$$super$reduceRight(op);
    }

    public static Object zip(IndexedSeqOptimized $this, GenIterable that, CanBuildFrom bf) {
        Object object;
        GenIterable genIterable = that;
        if (genIterable instanceof IndexedSeq) {
            IndexedSeq indexedSeq;
            IndexedSeq that2 = indexedSeq = (IndexedSeq)genIterable;
            Builder b = bf.apply($this.repr());
            int len = Predef$.MODULE$.intWrapper($this.length()).min(that2.length());
            b.sizeHint(len);
            for (int i = 0; i < len; ++i) {
                b.$plus$eq(new Tuple2($this.apply(i), that2.apply(i)));
            }
            object = b.result();
        } else {
            object = $this.scala$collection$IndexedSeqOptimized$$super$zip(that, bf);
        }
        return object;
    }

    public static Object zipWithIndex(IndexedSeqOptimized $this, CanBuildFrom bf) {
        Builder b = bf.apply($this.repr());
        int len = $this.length();
        b.sizeHint(len);
        for (int i = 0; i < len; ++i) {
            b.$plus$eq(new Tuple2($this.apply(i), BoxesRunTime.boxToInteger(i)));
        }
        return b.result();
    }

    public static Object slice(IndexedSeqOptimized $this, int from2, int until2) {
        int lo = package$.MODULE$.max(from2, 0);
        int hi = package$.MODULE$.min(package$.MODULE$.max(until2, 0), $this.length());
        int elems = package$.MODULE$.max(hi - lo, 0);
        Builder b = $this.newBuilder();
        b.sizeHint(elems);
        for (int i = lo; i < hi; ++i) {
            b.$plus$eq($this.apply(i));
        }
        return b.result();
    }

    public static Object head(IndexedSeqOptimized $this) {
        return $this.isEmpty() ? $this.scala$collection$IndexedSeqOptimized$$super$head() : $this.apply(0);
    }

    public static Object tail(IndexedSeqOptimized $this) {
        return $this.isEmpty() ? $this.scala$collection$IndexedSeqOptimized$$super$tail() : $this.slice(1, $this.length());
    }

    public static Object last(IndexedSeqOptimized $this) {
        return $this.length() > 0 ? $this.apply($this.length() - 1) : $this.scala$collection$IndexedSeqOptimized$$super$last();
    }

    public static Object init(IndexedSeqOptimized $this) {
        return $this.length() > 0 ? $this.slice(0, $this.length() - 1) : $this.scala$collection$IndexedSeqOptimized$$super$init();
    }

    public static Object take(IndexedSeqOptimized $this, int n) {
        return $this.slice(0, n);
    }

    public static Object drop(IndexedSeqOptimized $this, int n) {
        return $this.slice(n, $this.length());
    }

    public static Object takeRight(IndexedSeqOptimized $this, int n) {
        return $this.slice($this.length() - n, $this.length());
    }

    public static Object dropRight(IndexedSeqOptimized $this, int n) {
        return $this.slice(0, $this.length() - n);
    }

    public static Tuple2 splitAt(IndexedSeqOptimized $this, int n) {
        return new Tuple2($this.take(n), $this.drop(n));
    }

    public static Object takeWhile(IndexedSeqOptimized $this, Function1 p) {
        return $this.take($this.prefixLength(p));
    }

    public static Object dropWhile(IndexedSeqOptimized $this, Function1 p) {
        return $this.drop($this.prefixLength(p));
    }

    public static Tuple2 span(IndexedSeqOptimized $this, Function1 p) {
        return $this.splitAt($this.prefixLength(p));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean sameElements(IndexedSeqOptimized $this, GenIterable that) {
        GenIterable genIterable = that;
        if (genIterable instanceof IndexedSeq) {
            int i;
            IndexedSeq indexedSeq;
            IndexedSeq that2 = indexedSeq = (IndexedSeq)genIterable;
            int len = $this.length();
            if (len != that2.length()) return false;
            for (i = 0; i < len; ++i) {
                void y1;
                void x1;
                Object r = that2.apply(i);
                Object a = $this.apply(i);
                if (!(a == r ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1)))))) break;
            }
            if (i != len) return false;
            return true;
        }
        boolean bl = $this.scala$collection$IndexedSeqOptimized$$super$sameElements(that);
        return bl;
    }

    public static void copyToArray(IndexedSeqOptimized $this, Object xs, int start, int len) {
        int i = 0;
        int j = start;
        int end = Predef$.MODULE$.intWrapper(Predef$.MODULE$.intWrapper($this.length()).min(len)).min(ScalaRunTime$.MODULE$.array_length(xs) - start);
        while (i < end) {
            ScalaRunTime$.MODULE$.array_update(xs, j, $this.apply(i));
            ++i;
            ++j;
        }
    }

    public static int lengthCompare(IndexedSeqOptimized $this, int len) {
        return $this.length() - len;
    }

    public static int segmentLength(IndexedSeqOptimized $this, Function1 p, int from2) {
        int i;
        int len = $this.length();
        for (i = from2; i < len && BoxesRunTime.unboxToBoolean(p.apply($this.apply(i))); ++i) {
        }
        return i - from2;
    }

    private static int negLength(IndexedSeqOptimized $this, int n) {
        return n >= $this.length() ? -1 : n;
    }

    public static int indexWhere(IndexedSeqOptimized $this, Function1 p$4, int from2) {
        int start = Predef$.MODULE$.intWrapper(from2).max(0);
        return IndexedSeqOptimized$class.negLength($this, start + $this.segmentLength(new Serializable($this, p$4){
            public static final long serialVersionUID;
            private final Function1 p$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(A a) {
                return !BoxesRunTime.unboxToBoolean(this.p$4.apply(a));
            }
            {
                this.p$4 = indexedSeqOptimized;
            }
        }, start));
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexWhere(IndexedSeqOptimized $this, Function1 p, int end) {
        void var3_3;
        for (int i = end; i >= 0 && !BoxesRunTime.unboxToBoolean(p.apply($this.apply(i))); --i) {
        }
        return (int)var3_3;
    }

    public static Object reverse(IndexedSeqOptimized $this) {
        Builder b = $this.newBuilder();
        b.sizeHint($this.length());
        int i = $this.length();
        while (0 < i) {
            b.$plus$eq($this.apply(--i));
        }
        return b.result();
    }

    public static Iterator reverseIterator(IndexedSeqOptimized $this) {
        return new AbstractIterator<A>($this){
            private int i;
            private final IndexedSeqOptimized $outer;

            private int i() {
                return this.i;
            }

            private void i_$eq(int n) {
                this.i = n;
            }

            public boolean hasNext() {
                return 0 < this.i();
            }

            public A next() {
                Nothing$ nothing$;
                if (0 < this.i()) {
                    this.i_$eq(this.i() - 1);
                    nothing$ = this.$outer.apply(this.i());
                } else {
                    nothing$ = Iterator$.MODULE$.empty().next();
                }
                return (A)nothing$;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.i = $outer.length();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static boolean startsWith(IndexedSeqOptimized $this, GenSeq that, int offset) {
        boolean bl;
        GenSeq genSeq = that;
        if (genSeq instanceof IndexedSeq) {
            int j;
            IndexedSeq indexedSeq;
            IndexedSeq that2 = indexedSeq = (IndexedSeq)genSeq;
            int i = offset;
            int thisLen = $this.length();
            int thatLen = that2.length();
            for (j = 0; i < thisLen && j < thatLen; ++i, ++j) {
                void y1;
                void x1;
                Object r = that2.apply(j);
                Object a = $this.apply(i);
                if (!(a == r ? true : (x1 == null ? false : (x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1)))))) break;
            }
            bl = j == thatLen;
        } else {
            int thisLen = $this.length();
            Iterator thatElems = that.iterator();
            for (int i = offset; i < thisLen && thatElems.hasNext(); ++i) {
                void y2;
                void x2;
                Object a = thatElems.next();
                Object a2 = $this.apply(i);
                if (a2 == a ? true : (x2 == null ? false : (x2 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x2, y2) : (x2 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x2, y2) : x2.equals(y2))))) {
                    continue;
                }
                return false;
            }
            bl = !thatElems.hasNext();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean endsWith(IndexedSeqOptimized $this, GenSeq that) {
        GenSeq genSeq = that;
        if (genSeq instanceof IndexedSeq) {
            IndexedSeq indexedSeq;
            IndexedSeq that2 = indexedSeq = (IndexedSeq)genSeq;
            int i = $this.length() - 1;
            int j = that2.length() - 1;
            if (j > i) return false;
            while (j >= 0) {
                boolean bl;
                Object r = that2.apply(j);
                Object a = $this.apply(i);
                if (a == r) {
                    bl = true;
                } else {
                    void y1;
                    void x1;
                    if (x1 == null) {
                        return false;
                    }
                    bl = x1 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x1, y1) : (x1 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x1, y1) : x1.equals(y1));
                }
                if (!bl) return false;
                --i;
                --j;
            }
            if (!true) return false;
            return true;
        }
        boolean bl = $this.scala$collection$IndexedSeqOptimized$$super$endsWith(that);
        return bl;
    }

    public static void $init$(IndexedSeqOptimized $this) {
    }
}

