/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.util.Iterator;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.MappedResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;

public class MappedResourceCollection
extends DataType
implements ResourceCollection,
Cloneable {
    private ResourceCollection nested = null;
    private Mapper mapper = null;

    public synchronized void add(ResourceCollection c) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.nested != null) {
            throw new BuildException("Only one resource collection can be nested into mappedresources", this.getLocation());
        }
        this.setChecked(false);
        this.nested = c;
    }

    public Mapper createMapper() throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.mapper != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.setChecked(false);
        this.mapper = new Mapper(this.getProject());
        return this.mapper;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    public boolean isFilesystemOnly() {
        if (this.isReference()) {
            return ((MappedResourceCollection)this.getCheckedRef()).isFilesystemOnly();
        }
        this.checkInitialized();
        return false;
    }

    public int size() {
        if (this.isReference()) {
            return ((MappedResourceCollection)this.getCheckedRef()).size();
        }
        this.checkInitialized();
        return this.nested.size();
    }

    public Iterator iterator() {
        if (this.isReference()) {
            return ((MappedResourceCollection)this.getCheckedRef()).iterator();
        }
        this.checkInitialized();
        return new MappedIterator(this.nested.iterator(), this.mapper);
    }

    public void setRefid(Reference r) {
        if (this.nested != null || this.mapper != null) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    public Object clone() {
        try {
            MappedResourceCollection c = (MappedResourceCollection)super.clone();
            c.nested = this.nested;
            c.mapper = this.mapper;
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new BuildException(e);
        }
    }

    protected synchronized void dieOnCircularReference(Stack stk, Project p) throws BuildException {
        if (this.isChecked()) {
            return;
        }
        if (this.isReference()) {
            super.dieOnCircularReference(stk, p);
        } else {
            this.checkInitialized();
            if (this.mapper != null) {
                MappedResourceCollection.pushAndInvokeCircularReferenceCheck(this.mapper, stk, p);
            }
            if (this.nested instanceof DataType) {
                MappedResourceCollection.pushAndInvokeCircularReferenceCheck((DataType)((Object)this.nested), stk, p);
            }
            this.setChecked(true);
        }
    }

    private void checkInitialized() {
        if (this.nested == null) {
            throw new BuildException("A nested resource collection element is required", this.getLocation());
        }
        this.dieOnCircularReference();
    }

    private static class MappedIterator
    implements Iterator {
        private final Iterator sourceIterator;
        private final FileNameMapper mapper;

        private MappedIterator(Iterator source, Mapper m) {
            this.sourceIterator = source;
            this.mapper = m != null ? m.getImplementation() : new IdentityMapper();
        }

        public boolean hasNext() {
            return this.sourceIterator.hasNext();
        }

        public Object next() {
            return new MappedResource((Resource)this.sourceIterator.next(), this.mapper);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

