/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JCode;
import ch.epfl.lamp.fjbg.JLocalVariable;
import ch.epfl.lamp.fjbg.JMethod;
import ch.epfl.lamp.fjbg.JMethodType;
import ch.epfl.lamp.fjbg.JOpcode;
import ch.epfl.lamp.fjbg.JReferenceType;
import ch.epfl.lamp.fjbg.JType;

public class JExtendedCode
extends JCode {
    public static final int COND_EQ = 0;
    public static final int COND_NE = 1;
    public static final int COND_LT = 2;
    public static final int COND_GE = 3;
    public static final int COND_GT = 4;
    public static final int COND_LE = 5;
    private final JOpcode[] forbidden = new JOpcode[0];
    private final JOpcode[] nothingToDo = new JOpcode[0];
    private final JOpcode[][][] typeConversions = new JOpcode[][][]{{this.nothingToDo, this.forbidden, this.forbidden, this.forbidden, this.forbidden, this.forbidden, this.forbidden, this.forbidden}, {this.forbidden, this.nothingToDo, {JOpcode.I2F}, {JOpcode.I2D}, {JOpcode.I2B}, this.nothingToDo, this.nothingToDo, {JOpcode.I2L}}, {this.forbidden, {JOpcode.F2I, JOpcode.I2C}, this.nothingToDo, {JOpcode.F2D}, {JOpcode.F2I, JOpcode.I2B}, {JOpcode.F2I, JOpcode.I2S}, {JOpcode.F2I}, {JOpcode.F2L}}, {this.forbidden, {JOpcode.D2I, JOpcode.I2C}, {JOpcode.D2F}, this.nothingToDo, {JOpcode.D2I, JOpcode.I2B}, {JOpcode.D2I, JOpcode.I2S}, {JOpcode.D2I}, {JOpcode.D2L}}, {this.forbidden, {JOpcode.I2C}, {JOpcode.I2F}, {JOpcode.I2D}, this.nothingToDo, this.nothingToDo, this.nothingToDo, {JOpcode.I2L}}, {this.forbidden, this.nothingToDo, {JOpcode.I2F}, {JOpcode.I2D}, {JOpcode.I2B}, this.nothingToDo, this.nothingToDo, {JOpcode.I2L}}, {this.forbidden, {JOpcode.I2C}, {JOpcode.I2F}, {JOpcode.I2D}, {JOpcode.I2B}, {JOpcode.I2S}, this.nothingToDo, {JOpcode.I2L}}, {this.forbidden, {JOpcode.L2I, JOpcode.I2C}, {JOpcode.L2F}, {JOpcode.L2D}, {JOpcode.L2I, JOpcode.I2B}, {JOpcode.L2I, JOpcode.I2S}, {JOpcode.L2I}, this.nothingToDo}};

    public JExtendedCode(FJBGContext context, JClass clazz, JMethod owner) {
        super(context, clazz, owner);
    }

    public void emitPUSH(boolean value) {
        this.emitPUSH(value ? 1 : 0);
    }

    public void emitPUSH(Boolean value) {
        this.emitPUSH((boolean)value);
    }

    public void emitPUSH(byte value) {
        this.emitBIPUSH(value);
    }

    public void emitPUSH(Byte value) {
        this.emitPUSH((byte)value);
    }

    public void emitPUSH(short value) {
        this.emitSIPUSH(value);
    }

    public void emitPUSH(Short value) {
        this.emitPUSH((short)value);
    }

    public void emitPUSH(char value) {
        this.emitPUSH((int)value);
    }

    public void emitPUSH(Character value) {
        this.emitPUSH(value.charValue());
    }

    public void emitPUSH(int value) {
        switch (value) {
            case -1: {
                this.emitICONST_M1();
                break;
            }
            case 0: {
                this.emitICONST_0();
                break;
            }
            case 1: {
                this.emitICONST_1();
                break;
            }
            case 2: {
                this.emitICONST_2();
                break;
            }
            case 3: {
                this.emitICONST_3();
                break;
            }
            case 4: {
                this.emitICONST_4();
                break;
            }
            case 5: {
                this.emitICONST_5();
                break;
            }
            default: {
                this.emitPUSH_index(this.pool.addInteger(value));
            }
        }
    }

    public void emitPUSH(Integer value) {
        this.emitPUSH((int)value);
    }

    public void emitPUSH(long value) {
        if (value == 0L) {
            this.emitLCONST_0();
        } else if (value == 1L) {
            this.emitLCONST_1();
        } else {
            this.emitLDC2_W(value);
        }
    }

    public void emitPUSH(Long value) {
        this.emitPUSH((long)value);
    }

    public void emitPUSH(float value) {
        if (value == 0.0f) {
            this.emitFCONST_0();
        } else if (value == 1.0f) {
            this.emitFCONST_1();
        } else if (value == 2.0f) {
            this.emitFCONST_2();
        } else {
            this.emitPUSH_index(this.pool.addFloat(value));
        }
    }

    public void emitPUSH(Float value) {
        this.emitPUSH(value.floatValue());
    }

    public void emitPUSH(double value) {
        if (value == 0.0) {
            this.emitDCONST_0();
        } else if (value == 1.0) {
            this.emitDCONST_1();
        } else {
            this.emitLDC2_W(value);
        }
    }

    public void emitPUSH(Double value) {
        this.emitPUSH((double)value);
    }

    public void emitPUSH(String s) {
        this.emitPUSH_index(this.pool.addString(s));
    }

    public void emitPUSH(JReferenceType type) {
        assert (this.owner.owner.major >= 49);
        this.emitPUSH_index(this.pool.addClass(type.getDescriptor()));
    }

    protected void emitPUSH_index(int index) {
        if (index <= 255) {
            this.emitU1(JOpcode.LDC, index);
        } else {
            this.emitU2(JOpcode.LDC_W, index);
        }
    }

    public void emitLOAD(int index, JType type) {
        JOpcode opcode;
        switch (type.getTag()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                switch (index) {
                    case 0: {
                        this.emitILOAD_0();
                        return;
                    }
                    case 1: {
                        this.emitILOAD_1();
                        return;
                    }
                    case 2: {
                        this.emitILOAD_2();
                        return;
                    }
                    case 3: {
                        this.emitILOAD_3();
                        return;
                    }
                }
                opcode = JOpcode.ILOAD;
                break;
            }
            case 6: {
                switch (index) {
                    case 0: {
                        this.emitFLOAD_0();
                        return;
                    }
                    case 1: {
                        this.emitFLOAD_1();
                        return;
                    }
                    case 2: {
                        this.emitFLOAD_2();
                        return;
                    }
                    case 3: {
                        this.emitFLOAD_3();
                        return;
                    }
                }
                opcode = JOpcode.FLOAD;
                break;
            }
            case 11: {
                switch (index) {
                    case 0: {
                        this.emitLLOAD_0();
                        return;
                    }
                    case 1: {
                        this.emitLLOAD_1();
                        return;
                    }
                    case 2: {
                        this.emitLLOAD_2();
                        return;
                    }
                    case 3: {
                        this.emitLLOAD_3();
                        return;
                    }
                }
                opcode = JOpcode.LLOAD;
                break;
            }
            case 7: {
                switch (index) {
                    case 0: {
                        this.emitDLOAD_0();
                        return;
                    }
                    case 1: {
                        this.emitDLOAD_1();
                        return;
                    }
                    case 2: {
                        this.emitDLOAD_2();
                        return;
                    }
                    case 3: {
                        this.emitDLOAD_3();
                        return;
                    }
                }
                opcode = JOpcode.DLOAD;
                break;
            }
            case 13: 
            case 14: {
                switch (index) {
                    case 0: {
                        this.emitALOAD_0();
                        return;
                    }
                    case 1: {
                        this.emitALOAD_1();
                        return;
                    }
                    case 2: {
                        this.emitALOAD_2();
                        return;
                    }
                    case 3: {
                        this.emitALOAD_3();
                        return;
                    }
                }
                opcode = JOpcode.ALOAD;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type for load " + type);
            }
        }
        if (index > 255) {
            this.emitWIDE(opcode, index);
        } else {
            this.emitU1(opcode, index);
        }
    }

    public void emitLOAD(JLocalVariable var) {
        this.emitLOAD(var.index, var.type);
    }

    public void emitSTORE(int index, JType type) {
        JOpcode opcode;
        switch (type.getTag()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                switch (index) {
                    case 0: {
                        this.emitISTORE_0();
                        return;
                    }
                    case 1: {
                        this.emitISTORE_1();
                        return;
                    }
                    case 2: {
                        this.emitISTORE_2();
                        return;
                    }
                    case 3: {
                        this.emitISTORE_3();
                        return;
                    }
                }
                opcode = JOpcode.ISTORE;
                break;
            }
            case 6: {
                switch (index) {
                    case 0: {
                        this.emitFSTORE_0();
                        return;
                    }
                    case 1: {
                        this.emitFSTORE_1();
                        return;
                    }
                    case 2: {
                        this.emitFSTORE_2();
                        return;
                    }
                    case 3: {
                        this.emitFSTORE_3();
                        return;
                    }
                }
                opcode = JOpcode.FSTORE;
                break;
            }
            case 11: {
                switch (index) {
                    case 0: {
                        this.emitLSTORE_0();
                        return;
                    }
                    case 1: {
                        this.emitLSTORE_1();
                        return;
                    }
                    case 2: {
                        this.emitLSTORE_2();
                        return;
                    }
                    case 3: {
                        this.emitLSTORE_3();
                        return;
                    }
                }
                opcode = JOpcode.LSTORE;
                break;
            }
            case 7: {
                switch (index) {
                    case 0: {
                        this.emitDSTORE_0();
                        return;
                    }
                    case 1: {
                        this.emitDSTORE_1();
                        return;
                    }
                    case 2: {
                        this.emitDSTORE_2();
                        return;
                    }
                    case 3: {
                        this.emitDSTORE_3();
                        return;
                    }
                }
                opcode = JOpcode.DSTORE;
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                switch (index) {
                    case 0: {
                        this.emitASTORE_0();
                        return;
                    }
                    case 1: {
                        this.emitASTORE_1();
                        return;
                    }
                    case 2: {
                        this.emitASTORE_2();
                        return;
                    }
                    case 3: {
                        this.emitASTORE_3();
                        return;
                    }
                }
                opcode = JOpcode.ASTORE;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type for store " + type);
            }
        }
        if (index > 255) {
            this.emitWIDE(opcode, index);
        } else {
            this.emitU1(opcode, index);
        }
    }

    public void emitSTORE(JLocalVariable var) {
        this.emitSTORE(var.index, var.type);
    }

    public void emitALOAD(JType type) {
        switch (type.getTag()) {
            case 4: 
            case 8: {
                this.emitBALOAD();
                break;
            }
            case 5: {
                this.emitCALOAD();
                break;
            }
            case 9: {
                this.emitSALOAD();
                break;
            }
            case 10: {
                this.emitIALOAD();
                break;
            }
            case 6: {
                this.emitFALOAD();
                break;
            }
            case 11: {
                this.emitLALOAD();
                break;
            }
            case 7: {
                this.emitDALOAD();
                break;
            }
            case 13: 
            case 14: {
                this.emitAALOAD();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type for aload " + type);
            }
        }
    }

    public void emitASTORE(JType type) {
        switch (type.getTag()) {
            case 4: 
            case 8: {
                this.emitBASTORE();
                break;
            }
            case 5: {
                this.emitCASTORE();
                break;
            }
            case 9: {
                this.emitSASTORE();
                break;
            }
            case 10: {
                this.emitIASTORE();
                break;
            }
            case 6: {
                this.emitFASTORE();
                break;
            }
            case 11: {
                this.emitLASTORE();
                break;
            }
            case 7: {
                this.emitDASTORE();
                break;
            }
            case 13: 
            case 14: {
                this.emitAASTORE();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type for astore " + type);
            }
        }
    }

    public void emitRETURN(JType type) {
        if (type.isValueType()) {
            switch (type.getTag()) {
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    this.emitIRETURN();
                    break;
                }
                case 6: {
                    this.emitFRETURN();
                    break;
                }
                case 11: {
                    this.emitLRETURN();
                    break;
                }
                case 7: {
                    this.emitDRETURN();
                }
            }
        } else if (type.isArrayType() || type.isObjectType()) {
            this.emitARETURN();
        } else if (type == JType.VOID) {
            this.emitRETURN();
        } else {
            throw new IllegalArgumentException("invalid type for RETURN " + type);
        }
    }

    public void emitADD(JType type) {
        switch (type.getTag()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                this.emitIADD();
                break;
            }
            case 6: {
                this.emitFADD();
                break;
            }
            case 11: {
                this.emitLADD();
                break;
            }
            case 7: {
                this.emitDADD();
            }
        }
    }

    public void emitT2T(JType fromType, JType toType) {
        assert (fromType.getTag() >= 4 && fromType.getTag() <= 11 && toType.getTag() >= 4 && toType.getTag() <= 11);
        JOpcode[] conv = this.typeConversions[fromType.getTag() - 4][toType.getTag() - 4];
        if (conv == this.forbidden) {
            throw new Error("inconvertible types : " + fromType.toString() + " -> " + toType.toString());
        }
        if (conv != this.nothingToDo) {
            int i = 0;
            while (i < conv.length) {
                this.emit(conv[i]);
                ++i;
            }
        }
    }

    public void emitIF(int cond, JCode.Label label) throws JCode.OffsetTooBigException {
        assert (cond >= 0 && cond <= 5);
        this.emitU2(JOpcode.OPCODES[153 + cond], label.getOffset16(this.getPC() + 1, this.getPC()));
    }

    public void emitIF(int cond, int targetPC) throws JCode.OffsetTooBigException {
        int offset = targetPC - this.getPC();
        this.emitU2(JOpcode.OPCODES[153 + cond], offset);
    }

    public void emitIF(int cond) throws JCode.OffsetTooBigException {
        this.emitIF(cond, 0);
    }

    public void emitIF_ICMP(int cond, JCode.Label label) throws JCode.OffsetTooBigException {
        assert (cond >= 0 && cond <= 5);
        this.emitU2(JOpcode.OPCODES[159 + cond], label.getOffset16(this.getPC() + 1, this.getPC()));
    }

    public void emitIF_ICMP(int cond, int targetPC) throws JCode.OffsetTooBigException {
        int offset = targetPC - this.getPC();
        this.emitU2(JOpcode.OPCODES[159 + cond], offset);
    }

    public void emitIF_ICMP(int cond) throws JCode.OffsetTooBigException {
        this.emitIF_ICMP(cond, 0);
    }

    public void emitIF_ACMP(int cond, JCode.Label label) throws JCode.OffsetTooBigException {
        assert (cond == 0 || cond == 1);
        this.emitU2(JOpcode.OPCODES[165 + cond], label.getOffset16(this.getPC() + 1, this.getPC()));
    }

    public void emitIF_ACMP(int cond, int targetPC) throws JCode.OffsetTooBigException {
        int offset = targetPC - this.getPC();
        this.emitU2(JOpcode.OPCODES[165 + cond], offset);
    }

    public void emitIF_ACMP(int cond) throws JCode.OffsetTooBigException {
        this.emitIF_ACMP(cond, 0);
    }

    public void emitGOTO_maybe_W(JCode.Label label, boolean defaultToWide) {
        if (label.anchored) {
            this.emitGOTO_maybe_W(label.targetPC);
        } else if (defaultToWide) {
            this.emitGOTO_W(label);
        } else {
            try {
                this.emitGOTO(label);
            }
            catch (JCode.OffsetTooBigException e) {
                throw new Error(e);
            }
        }
    }

    public void emitGOTO_maybe_W(int targetPC) {
        int offset = targetPC - (this.getPC() + 1);
        if (offset < Short.MIN_VALUE || offset > Short.MAX_VALUE) {
            this.emitGOTO_W(targetPC);
        } else {
            try {
                this.emitGOTO(targetPC);
            }
            catch (JCode.OffsetTooBigException e) {
                throw new Error(e);
            }
        }
    }

    public void emitSWITCH(int[][] keySets, JCode.Label[] branches, JCode.Label defaultBranch, double minDensity) {
        assert (keySets.length == branches.length);
        int flatSize = 0;
        int i = 0;
        while (i < keySets.length) {
            flatSize += keySets[i].length;
            ++i;
        }
        int[] flatKeys = new int[flatSize];
        JCode.Label[] flatBranches = new JCode.Label[flatSize];
        int flatI = 0;
        int i2 = 0;
        while (i2 < keySets.length) {
            JCode.Label branch = branches[i2];
            int[] keys = keySets[i2];
            int j = 0;
            while (j < keys.length) {
                flatKeys[flatI] = keys[j];
                flatBranches[flatI] = branch;
                ++j;
            }
            ++flatI;
            ++i2;
        }
        assert (flatI == flatSize);
        this.emitSWITCH(flatKeys, flatBranches, defaultBranch, minDensity);
    }

    public void emitSWITCH(int[] keys, JCode.Label[] branches, JCode.Label defaultBranch, double minDensity) {
        assert (keys.length == branches.length);
        int i = 1;
        while (i < keys.length) {
            int j = 1;
            while (j <= keys.length - i) {
                if (keys[j] < keys[j - 1]) {
                    int tmp = keys[j];
                    keys[j] = keys[j - 1];
                    keys[j - 1] = tmp;
                    JCode.Label tmp_l = branches[j];
                    branches[j] = branches[j - 1];
                    branches[j - 1] = tmp_l;
                }
                ++j;
            }
            ++i;
        }
        int keyMax = keys[keys.length - 1];
        int keyMin = keys[0];
        int keyRange = keyMax - keyMin + 1;
        if ((double)keys.length / (double)keyRange >= minDensity) {
            int[] newKeys = new int[keyRange];
            JCode.Label[] newBranches = new JCode.Label[keyRange];
            int oldPos = 0;
            int i2 = 0;
            while (i2 < keyRange) {
                int key;
                newKeys[i2] = key = keyMin + i2;
                if (keys[oldPos] == key) {
                    newBranches[i2] = branches[oldPos];
                    ++oldPos;
                } else {
                    newBranches[i2] = defaultBranch;
                }
                ++i2;
            }
            assert (oldPos == keys.length);
            this.emitTABLESWITCH(newKeys, newBranches, defaultBranch);
        } else {
            this.emitLOOKUPSWITCH(keys, branches, defaultBranch);
        }
    }

    public void emitINVOKE(JMethod method) {
        String mName = method.getName();
        String cName = method.getOwner().getName();
        JMethodType mType = (JMethodType)method.getType();
        if (method.isStatic()) {
            this.emitINVOKESTATIC(cName, mName, mType);
        } else if (method.getOwner().isInterface()) {
            this.emitINVOKEINTERFACE(cName, mName, mType);
        } else {
            this.emitINVOKEVIRTUAL(cName, mName, mType);
        }
    }
}

