/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.distributed;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import scala.Console$;
import scala.MatchError;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.actors.Debug;
import scala.actors.distributed.JavaSerializer;
import scala.actors.distributed.Send;
import scala.actors.distributed.TcpNode;
import scala.actors.distributed.TcpService;
import scala.runtime.BoxedUnit;

public class TcpServiceWorker
extends Thread
implements ScalaObject {
    private boolean running;
    private TcpNode connectedNode;
    private Debug log;
    private PrintWriter writer;
    private BufferedReader reader;
    private DataOutputStream dataout;
    private DataInputStream datain;
    private OutputStream out;
    private InputStream in;
    private Socket so;
    private TcpService parent;

    public TcpServiceWorker(TcpService tcpService, Socket socket) {
        this.parent = tcpService;
        this.so = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.datain = new DataInputStream(this.in());
        this.dataout = new DataOutputStream(this.out());
        this.reader = new BufferedReader(new InputStreamReader(this.in()));
        this.writer = new PrintWriter(new OutputStreamWriter(this.out()));
        this.log = new Debug("TcpServiceWorker");
        this.log().level_$eq(2);
        this.running = true;
    }

    public void run() {
        try {
            while (this.running()) {
                if (this.in().available() <= 0) continue;
                this.log().info("deserializing...");
                Object object = this.parent.serializer().readObject(this.datain());
                this.log().info("Received object: " + object);
                this.parent.kernel().processMsg(object);
            }
        }
        catch (Exception exception) {
            Console$.MODULE$.println("" + exception + " while reading from socket.");
            this.parent.nodeDown(this.connectedNode());
        }
        catch (IOException iOException) {
            Console$.MODULE$.println("" + iOException + " while reading from socket.");
            this.parent.nodeDown(this.connectedNode());
        }
    }

    public void halt() {
        TcpServiceWorker tcpServiceWorker = this;
        synchronized (tcpServiceWorker) {
            this.so.close();
            this.running_$eq(false);
            return;
        }
    }

    public void running_$eq(boolean bl) {
        this.running = bl;
    }

    public boolean running() {
        return this.running;
    }

    public void readNode() {
        BoxedUnit boxedUnit;
        TcpNode tcpNode;
        Console$.MODULE$.println("" + this.parent.node() + ": Reading node name...");
        Object object = this.parent.serializer().readObject(this.datain());
        Console$.MODULE$.println("Connection from " + object);
        Object object2 = object;
        if (!(object2 instanceof TcpNode)) {
            throw new MatchError(object2);
        }
        TcpNode tcpNode2 = tcpNode = (TcpNode)object2;
        this.connectedNode_$eq(tcpNode2);
        Console$.MODULE$.println("Adding connection to " + object + " to table.");
        this.parent.addConnection(tcpNode2, this);
        BoxedUnit boxedUnit2 = boxedUnit = BoxedUnit.UNIT;
    }

    public void connectedNode_$eq(TcpNode tcpNode) {
        this.connectedNode = tcpNode;
    }

    public TcpNode connectedNode() {
        return this.connectedNode;
    }

    public void sendNode() {
        Console$.MODULE$.println("Sending our name " + this.parent.node());
        this.parent.serializer().writeObject(this.dataout(), this.parent.node());
    }

    public void transmit(byte[] byArray) {
        TcpServiceWorker tcpServiceWorker = this;
        synchronized (tcpServiceWorker) {
            this.log().info("Transmitting " + byArray);
            this.dataout().writeInt(byArray.length);
            this.dataout().write(byArray);
            this.dataout().flush();
            return;
        }
    }

    public void transmit(String string) {
        TcpServiceWorker tcpServiceWorker = this;
        synchronized (tcpServiceWorker) {
            this.log().info("Transmitting " + string);
            this.writer().write(string);
            this.writer().flush();
            return;
        }
    }

    public void transmit(Send send) {
        TcpServiceWorker tcpServiceWorker = this;
        synchronized (tcpServiceWorker) {
            byte[] byArray = ((JavaSerializer)this.parent.serializer()).serialize(send);
            this.transmit(byArray);
            return;
        }
    }

    public Debug log() {
        return this.log;
    }

    public PrintWriter writer() {
        return this.writer;
    }

    public BufferedReader reader() {
        return this.reader;
    }

    public DataOutputStream dataout() {
        return this.dataout;
    }

    public DataInputStream datain() {
        return this.datain;
    }

    public OutputStream out() {
        return this.out;
    }

    public InputStream in() {
        return this.in;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

