/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2006, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: NodeTraverser.scala 5889 2006-03-05 00:33:02Z mihaylov $


package scala.xml;


abstract class NodeTraverser extends parsing.MarkupHandler {

  def traverse(n: Node): Unit = n match {
    case x:ProcInstr => procInstr(0, x.target, x.text)
    case x:Comment   => comment(0, x.text)
    case x:Text      => text(0, x.data)
    case x:EntityRef => entityRef(0, x.entityName)
    case _ => 
      elemStart(0, n.prefix, n.label, n.attributes, n.scope);
      for (val m <- n.child)
        traverse(m);
      elem(0, n.prefix, n.label, n.attributes, n.scope, NodeSeq.fromSeq(n.child));
      elemEnd(0, n.prefix, n.label);
  }

}
