/*
 * Decompiled with CFR 0.152.
 */
package scala.dbc.datatype;

import scala.MatchError;
import scala.ScalaObject;
import scala.Tuple2;
import scala.dbc.DataType;
import scala.dbc.datatype.Numeric;
import scala.dbc.exception.UnsupportedFeature;
import scala.runtime.BoxedInt;
import scala.runtime.BoxedNumber;
import scala.runtime.ScalaRunTime$;

public abstract class ApproximateNumeric
extends Numeric
implements ScalaObject {
    private int nativeTypeId;

    public ApproximateNumeric(int n) {
        this.nativeTypeId = n;
        super(n);
    }

    public String sqlString() {
        String string;
        Tuple2 tuple2 = new Tuple2(BoxedInt.box(this.precisionRadix()), BoxedInt.box(this.precision()));
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = tuple2;
        if (ScalaRunTime$.MODULE$.intValue((BoxedNumber)tuple22._1()) != 2) {
            String string2;
            if (ScalaRunTime$.MODULE$.intValue((BoxedNumber)tuple22._1()) != 10) {
                int n = ScalaRunTime$.MODULE$.intValue((BoxedNumber)tuple22._1());
                throw new UnsupportedFeature("SQL-99 does not support the precision of an approximate numeric type to be defined in a radix other than 2 or 10");
            }
            int n = ScalaRunTime$.MODULE$.intValue((BoxedNumber)tuple22._2());
            string = string2 = "FLOAT (" + ((Object)BoxedInt.box(n)).toString() + ")";
        } else if (ScalaRunTime$.MODULE$.intValue((BoxedNumber)tuple22._2()) != 64) {
            String string3;
            if (ScalaRunTime$.MODULE$.intValue((BoxedNumber)tuple22._2()) != 128) {
                int n = ScalaRunTime$.MODULE$.intValue((BoxedNumber)tuple22._2());
                throw new UnsupportedFeature("SQL-99 does not support an approximate numeric type with a binary defined precision other than 16, 32 and 64 bits");
            }
            string = string3 = "DOUBLE PRECISION";
        } else {
            String string4;
            string = string4 = "REAL";
        }
        return string;
    }

    public boolean isSubtypeOf(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (!(dataType2 instanceof ApproximateNumeric)) {
            boolean bl2;
            bl = bl2 = false;
        } else {
            boolean bl3;
            ApproximateNumeric approximateNumeric;
            ApproximateNumeric approximateNumeric2 = approximateNumeric = (ApproximateNumeric)dataType2;
            bl = bl3 = this.nativeTypeId() == approximateNumeric2.nativeTypeId() && this.precisionRadix() == approximateNumeric2.precisionRadix() && this.precision() <= approximateNumeric2.precision() && this.signed() == approximateNumeric2.signed();
        }
        return bl;
    }

    public boolean isEquivalent(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (!(dataType2 instanceof ApproximateNumeric)) {
            boolean bl2;
            bl = bl2 = false;
        } else {
            boolean bl3;
            ApproximateNumeric approximateNumeric;
            ApproximateNumeric approximateNumeric2 = approximateNumeric = (ApproximateNumeric)dataType2;
            bl = bl3 = this.nativeTypeId() == approximateNumeric2.nativeTypeId() && this.precisionRadix() == approximateNumeric2.precisionRadix() && this.precision() == approximateNumeric2.precision() && this.signed() == approximateNumeric2.signed();
        }
        return bl;
    }

    public int nativeTypeId() {
        return this.nativeTypeId;
    }
}

