/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.distributed;

import scala.All$;
import scala.Function1;
import scala.List;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.ScalaObject;
import scala.Some;
import scala.Symbol;
import scala.actors.Debug$;
import scala.actors.Done;
import scala.actors.distributed.Name;
import scala.actors.distributed.NetKernel;
import scala.actors.distributed.Node;
import scala.actors.distributed.RemoteActor$$anonfun$0;
import scala.actors.distributed.RemotePid;
import scala.actors.distributed.ServiceName;
import scala.actors.distributed.TCP;
import scala.actors.distributed.TcpService;
import scala.actors.distributed.TcpService$;
import scala.actors.multi.ExcHandlerDesc;
import scala.actors.multi.Process;
import scala.runtime.BoxedUnit;

public class RemoteActor
extends Process
implements ScalaObject {
    private RemotePid selfCached = null;
    private NetKernel kernel = null;

    public void die() {
        if (this.isAlive()) {
            this.isAlive_$eq(false);
            Debug$.MODULE$.info("" + this + " died.");
            this.kernel().exit(this.self(), new Symbol("normal"));
        }
    }

    public void die(Symbol symbol) {
        if (this.isAlive()) {
            this.isAlive_$eq(false);
            Debug$.MODULE$.info("" + this + " died.");
            this.kernel().exit(this.self(), symbol);
        }
    }

    public void processFlag(Symbol symbol, boolean bl) {
        this.kernel().processFlag(this.self(), symbol, bl);
    }

    public void exit(Symbol symbol) {
        this.kernel().exit(this.self(), symbol);
    }

    public void unlink(RemotePid remotePid) {
        this.kernel().unlink(this.self(), remotePid);
    }

    public void link(RemotePid remotePid) {
        this.kernel().link(this.self(), remotePid);
    }

    public void monitorNode(Node node, boolean bl) {
        this.kernel().monitorNode(this.self(), node, bl);
    }

    public RemotePid spawnLink(Function1 function1) {
        return this.kernel().spawnLink(this.self(), function1);
    }

    public RemotePid spawn(RemoteActor remoteActor) {
        RemotePid remotePid = this.kernel().register(remoteActor);
        remoteActor.start();
        return remotePid;
    }

    public RemotePid spawn(Function1 function1) {
        return this.kernel().spawn(function1);
    }

    public void spawn(Node node, RemoteActor remoteActor) {
        this.kernel().spawn(this.self(), node, remoteActor);
    }

    public RemotePid spawn(Node node, String string) {
        return this.kernel().spawn(this.self(), node, string);
    }

    public Name name(Node node, Symbol symbol) {
        return new Name(node, symbol, this.kernel());
    }

    public void register(Symbol symbol, RemoteActor remoteActor) {
        this.kernel().registerName(symbol, remoteActor);
    }

    public void register(Symbol symbol, RemotePid remotePid) {
        this.kernel().registerName(symbol, remotePid);
    }

    public void disconnectNode(Node node) {
        this.kernel().disconnectNode(node);
    }

    public Node node(RemotePid remotePid) {
        return remotePid.node();
    }

    public void alive(ServiceName serviceName) {
        BoxedUnit boxedUnit;
        TcpService tcpService;
        TcpService tcpService2 = null;
        ServiceName serviceName2 = serviceName;
        if (!(serviceName2 instanceof TCP)) {
            throw new Exception("Unknown Service in RemoteActor");
        }
        TCP tCP = (TCP)serviceName2;
        tcpService2 = tcpService = new TcpService(TcpService$.MODULE$.generatePort());
        tcpService.start();
        BoxedUnit boxedUnit2 = boxedUnit = BoxedUnit.UNIT;
        this.selfCached_$eq(tcpService2.kernel().register(this));
    }

    public void serialize(String string, Function1 function1) {
        this.kernel().registerSerializer(string, function1);
    }

    public RemotePid self() {
        RemotePid remotePid = this.selfCached();
        Object var1_1 = null;
        if (!(remotePid == null ? var1_1 != null : !((Object)remotePid).equals(var1_1))) {
            this.selfCached_$eq(this.kernel().pidOf(this));
        }
        return this.selfCached();
    }

    private void selfCached_$eq(RemotePid remotePid) {
        this.selfCached = remotePid;
    }

    private RemotePid selfCached() {
        return this.selfCached;
    }

    public List nodes() {
        return this.kernel().nodes();
    }

    public Node node() {
        return this.self().node();
    }

    public void kernel_$eq(NetKernel netKernel) {
        this.kernel = netKernel;
    }

    public NetKernel kernel() {
        return this.kernel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public All$ receive(PartialFunction partialFunction) {
        BoxedUnit boxedUnit;
        Object object;
        if (!this.isAlive()) throw new Done();
        this.continuation_$eq(null);
        Option option = this.sent().dequeueFirst(new RemoteActor$$anonfun$0(this, partialFunction));
        if (!(option instanceof Some)) {
            BoxedUnit boxedUnit2;
            Option option2 = option;
            None$ none$ = None$.MODULE$;
            if (option2 != null ? !option2.equals(none$) : none$ != null) {
                throw new MatchError(option);
            }
            this.continuation_$eq(partialFunction);
            Debug$.MODULE$.info("No msg found. " + this + " has continuation " + this.continuation() + ".");
            BoxedUnit boxedUnit22 = boxedUnit2 = BoxedUnit.UNIT;
            throw new Done();
        }
        Some some = (Some)option;
        Object object2 = some.x();
        try {
            object = partialFunction.apply(object2);
        }
        catch (Throwable throwable) {
            if (!this.excHandlerDescs().isEmpty()) {
                this.forwardExc((ExcHandlerDesc)this.excHandlerDescs().top(), throwable);
            } else {
                this.die(new Symbol(throwable.toString()));
            }
            object = BoxedUnit.UNIT;
        }
        catch (Done done) {
            throw new Done();
        }
        this.die();
        BoxedUnit boxedUnit3 = boxedUnit = BoxedUnit.UNIT;
        throw new Done();
    }

    public void forwardExc(ExcHandlerDesc excHandlerDesc, Throwable throwable) {
        Process process = excHandlerDesc.p();
        RemoteActor remoteActor = this;
        if (process != null ? !process.equals(remoteActor) : remoteActor != null) {
            this.kernel().forwardExc(excHandlerDesc, throwable);
        } else {
            this.handleExc(excHandlerDesc, throwable);
        }
    }
}

