/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.distributed;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import scala.Function0;
import scala.Function1;
import scala.Iterator;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Some;
import scala.Symbol;
import scala.actors.distributed.Exit1;
import scala.actors.distributed.ForwardExc;
import scala.actors.distributed.Link;
import scala.actors.distributed.Name;
import scala.actors.distributed.NamedSend;
import scala.actors.distributed.NetKernel$;
import scala.actors.distributed.NetKernel$$anon$0;
import scala.actors.distributed.NetKernel$$anon$1;
import scala.actors.distributed.NetKernel$$anonfun$0;
import scala.actors.distributed.Node;
import scala.actors.distributed.RA;
import scala.actors.distributed.RemoteActor;
import scala.actors.distributed.RemotePid;
import scala.actors.distributed.Send;
import scala.actors.distributed.Service;
import scala.actors.distributed.Spawn;
import scala.actors.distributed.SpawnObject;
import scala.actors.distributed.UnLink;
import scala.actors.multi.ExcHandlerDesc;
import scala.actors.multi.Process;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedInt;
import scala.runtime.BoxedNumber;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public class NetKernel
implements ScalaObject {
    private HashMap monNodes;
    private HashSet exitMarks;
    private HashSet trapExits;
    private HashMap links;
    private HashMap nameTable;
    private ConsoleHandler consHand;
    private Logger l;
    private Level logLevel;
    private boolean running;
    private HashMap pidTable;
    private HashMap rtable;
    private HashMap ptable;
    private Service service;

    public NetKernel(Service service) {
        this.service = service;
        NetKernel$.MODULE$.kernel_$eq(this);
        this.ptable = new HashMap();
        this.rtable = new HashMap();
        this.pidTable = new HashMap();
        this.running = true;
        this.logLevel = Level.FINE;
        this.l = Logger.getLogger("NetKernel");
        this.l().setLevel(this.logLevel());
        this.consHand = new ConsoleHandler();
        this.consHand().setLevel(this.logLevel());
        this.l().addHandler(this.consHand());
        this.nameTable = new HashMap();
        this.links = new HashMap();
        this.trapExits = new HashSet();
        this.exitMarks = new HashSet();
        this.monNodes = new HashMap();
    }

    private final void liftedTry0$0(Node node) {
        try {
            this.service.connect(node);
        }
        catch (SecurityException securityException) {
            this.nodeDown(node);
        }
        catch (IOException iOException) {
            this.nodeDown(node);
        }
        catch (UnknownHostException unknownHostException) {
            this.nodeDown(node);
        }
    }

    public void nodeDown(Node node) {
        block4: {
            BoxedUnit boxedUnit;
            Option option;
            Option option2 = option = this.monNodes().get(node);
            None$ none$ = None$.MODULE$;
            if (option2 != null ? !option2.equals(none$) : none$ != null) {
                if (!(option instanceof Some)) {
                    throw new MatchError(option);
                }
                Some some = (Some)option;
                HashMap hashMap = (HashMap)some.x();
                Iterator iterator = hashMap.keys();
                while (true) {
                    if (!iterator.hasNext()) {
                        BoxedUnit boxedUnit2;
                        BoxedUnit boxedUnit3 = boxedUnit2 = BoxedUnit.UNIT;
                        break block4;
                    }
                    RemotePid remotePid = (RemotePid)iterator.next();
                    List$.MODULE$.range(0, ScalaRunTime$.MODULE$.intValue((BoxedNumber)hashMap.apply(remotePid))).foreach(new NetKernel$$anonfun$0(this, node, remotePid));
                }
            }
            BoxedUnit boxedUnit4 = boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void monitorNode(RemotePid remotePid, Node node, boolean bl) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            Option option;
            Option option2 = option = this.monNodes().get(node);
            None$ none$ = None$.MODULE$;
            if (option2 != null ? !option2.equals(none$) : none$ != null) {
                BoxedUnit boxedUnit;
                if (!(option instanceof Some)) {
                    throw new MatchError(option);
                }
                Some some = (Some)option;
                HashMap hashMap = (HashMap)some.x();
                hashMap.update(remotePid, BoxedInt.box(ScalaRunTime$.MODULE$.intValue((BoxedNumber)hashMap.apply(remotePid)) + (!bl ? -1 : 1)));
                BoxedUnit boxedUnit2 = boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                if (bl) {
                    HashMap hashMap = new HashMap();
                    hashMap.$plus$eq(remotePid).$minus$greater(BoxedInt.box(1));
                    this.monNodes().$plus$eq(node).$minus$greater(hashMap);
                }
                BoxedUnit boxedUnit3 = boxedUnit = BoxedUnit.UNIT;
            }
            if (bl && !this.service.isConnected(node)) {
                this.liftedTry0$0(node);
            }
            return;
        }
    }

    private HashMap monNodes() {
        return this.monNodes;
    }

    public void exit(RemotePid remotePid, Symbol symbol) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            block10: {
                if (!this.exitMarks().contains(remotePid)) {
                    BoxedUnit boxedUnit;
                    Option option;
                    this.exitMarks().$plus$eq(remotePid);
                    RemoteActor remoteActor = (RemoteActor)this.rtable().apply(BoxedInt.box(remotePid.localId()));
                    this.rtable().$minus$eq(BoxedInt.box(remotePid.localId()));
                    this.pidTable().$minus$eq(remoteActor);
                    Option option2 = option = this.links().get(BoxedInt.box(remotePid.localId()));
                    ScalaObject scalaObject = None$.MODULE$;
                    if (option2 != null ? !option2.equals(scalaObject) : scalaObject != null) {
                        if (!(option instanceof Some)) {
                            throw new MatchError(option);
                        }
                        Some some = (Some)option;
                        HashSet hashSet = (HashSet)some.x();
                        Iterator iterator = hashSet.elements();
                        while (true) {
                            if (!iterator.hasNext()) {
                                BoxedUnit boxedUnit2;
                                this.exitMarks().$minus$eq(remotePid);
                                BoxedUnit boxedUnit3 = boxedUnit2 = BoxedUnit.UNIT;
                                break block10;
                            }
                            RemotePid remotePid2 = (RemotePid)iterator.next();
                            this.unlinkFromLocal(remotePid, remotePid2);
                            Node node = remotePid2.node();
                            scalaObject = this.node();
                            if (node != null ? !node.equals(scalaObject) : scalaObject != null) {
                                this.sendToNode(remotePid2.node(), new Exit1(remotePid, remotePid2, symbol));
                                continue;
                            }
                            this.unlinkFromLocal(remotePid2, remotePid);
                            if (!this.trapExits().contains(BoxedInt.box(remotePid2.localId()))) {
                                if (symbol.name().equals("normal")) continue;
                                this.exit(remotePid2, symbol);
                                continue;
                            }
                            this.localSend(remotePid2, (Object)new Exit1(remotePid, remotePid2, symbol));
                        }
                    }
                    BoxedUnit boxedUnit4 = boxedUnit = BoxedUnit.UNIT;
                }
            }
            return;
        }
    }

    public HashSet exitMarks() {
        return this.exitMarks;
    }

    public void exit(RemotePid remotePid, RemotePid remotePid2, Symbol symbol) {
        this.unlinkFromLocal(remotePid2, remotePid);
        this.exit(remotePid2, symbol);
    }

    public void link(RemotePid remotePid, RemotePid remotePid2) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            BoxedUnit boxedUnit;
            this.linkFromLocal(remotePid, remotePid2);
            Node node = remotePid2.node();
            Node node2 = this.node();
            if (node != null ? !node.equals(node2) : node2 != null) {
                this.sendToNode(remotePid2.node(), new Link(remotePid2, remotePid));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.linkFromLocal(remotePid2, remotePid);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private void linkFromLocal(RemotePid remotePid, RemotePid remotePid2) {
        Option option;
        Option option2 = option = this.links().get(BoxedInt.box(remotePid.localId()));
        None$ none$ = None$.MODULE$;
        if (option2 != null ? !option2.equals(none$) : none$ != null) {
            BoxedUnit boxedUnit;
            if (!(option instanceof Some)) {
                throw new MatchError(option);
            }
            Some some = (Some)option;
            HashSet hashSet = (HashSet)some.x();
            hashSet.$plus$eq(remotePid2);
            BoxedUnit boxedUnit2 = boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            HashSet hashSet = new HashSet();
            hashSet.$plus$eq(remotePid2);
            this.links().$plus$eq(BoxedInt.box(remotePid.localId())).$minus$greater(hashSet);
            BoxedUnit boxedUnit3 = boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void unlink(RemotePid remotePid, RemotePid remotePid2) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            BoxedUnit boxedUnit;
            this.unlinkFromLocal(remotePid, remotePid2);
            Node node = remotePid2.node();
            Node node2 = this.node();
            if (node != null ? !node.equals(node2) : node2 != null) {
                this.sendToNode(remotePid2.node(), new UnLink(remotePid2, remotePid));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.unlinkFromLocal(remotePid2, remotePid);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private void unlinkFromLocal(RemotePid remotePid, RemotePid remotePid2) {
        Option option;
        Option option2 = option = this.links().get(BoxedInt.box(remotePid.localId()));
        None$ none$ = None$.MODULE$;
        if (option2 != null ? !option2.equals(none$) : none$ != null) {
            BoxedUnit boxedUnit;
            if (!(option instanceof Some)) {
                throw new MatchError(option);
            }
            Some some = (Some)option;
            HashSet hashSet = (HashSet)some.x();
            hashSet.$minus$eq(remotePid2);
            if (hashSet.size() == 0) {
                this.links().$minus$eq(BoxedInt.box(remotePid.localId()));
            }
            BoxedUnit boxedUnit2 = boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit3 = boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void processFlag(RemotePid remotePid, Symbol symbol, boolean bl) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            if (symbol.name().equals("trapExit")) {
                if (this.trapExits().contains(BoxedInt.box(remotePid.localId())) && !bl) {
                    this.trapExits().$minus$eq(BoxedInt.box(remotePid.localId()));
                } else if (!this.trapExits().contains(BoxedInt.box(remotePid.localId())) && bl) {
                    this.trapExits().$plus$eq(BoxedInt.box(remotePid.localId()));
                }
            }
            return;
        }
    }

    private HashSet trapExits() {
        return this.trapExits;
    }

    private HashMap links() {
        return this.links;
    }

    public RemotePid spawnLink(RemotePid remotePid, Function1 function1) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            NetKernel$$anon$1 netKernel$$anon$1 = new NetKernel$$anon$1(this, function1);
            RemotePid remotePid2 = this.register(netKernel$$anon$1);
            this.link(remotePid, remotePid2);
            netKernel$$anon$1.start();
            return remotePid2;
        }
    }

    public RemotePid spawn(Function1 function1) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            NetKernel$$anon$0 netKernel$$anon$0 = new NetKernel$$anon$0(this, function1);
            RemotePid remotePid = this.register(netKernel$$anon$0);
            netKernel$$anon$0.start();
            return remotePid;
        }
    }

    public RemotePid spawn(RemotePid remotePid, Node node, String string) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            RemotePid remotePid2;
            Node node2 = node;
            Node node3 = this.node();
            if (node2 != null ? !node2.equals(node3) : node3 != null) {
                this.sendToNode(node, new Spawn(remotePid, string));
                remotePid2 = null;
            } else {
                RemotePid remotePid3;
                remotePid2 = remotePid3 = this.spawn(string);
            }
            return remotePid2;
        }
    }

    public void registerSerializer(String string, Function1 function1) {
        this.service.serializer().addRep(string, function1);
    }

    public void spawn(RemotePid remotePid, Node node, RemoteActor remoteActor) {
        RA rA = new RA(remoteActor);
        byte[] byArray = this.service.serializer().serialize(rA);
        this.sendToNode(node, new SpawnObject(remotePid, byArray));
    }

    public RemotePid spawn(String string, RemotePid remotePid) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            RemotePid remotePid2 = this.spawn(string);
            this.localSend(remotePid2, (Object)remotePid);
            return remotePid2;
        }
    }

    public RemotePid spawn(String string) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            RemotePid remotePid;
            Option option;
            Option option2 = option = this.ptable().get(string);
            None$ none$ = None$.MODULE$;
            if (option2 != null ? !option2.equals(none$) : none$ != null) {
                RemotePid remotePid2;
                if (!(option instanceof Some)) {
                    throw new MatchError(option);
                }
                Some some = (Some)option;
                Function0 function0 = (Function0)some.x();
                RemoteActor remoteActor = (RemoteActor)function0.apply();
                RemotePid remotePid3 = this.register(remoteActor);
                remoteActor.start();
                remotePid = remotePid2 = remotePid3;
            } else {
                RemotePid remotePid4;
                RemoteActor remoteActor = (RemoteActor)Class.forName(string).newInstance();
                RemotePid remotePid5 = this.register(remoteActor);
                remoteActor.start();
                remotePid = remotePid4 = remotePid5;
            }
            return remotePid;
        }
    }

    public RemotePid register(RemoteActor remoteActor) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            remoteActor.kernel_$eq(this);
            RemotePid remotePid = this.service.createPid(remoteActor);
            this.rtable().$plus$eq(BoxedInt.box(remotePid.localId())).$minus$greater(remoteActor);
            this.pidTable().$plus$eq(remoteActor).$minus$greater(remotePid);
            return remotePid;
        }
    }

    public void processMsg(Object object) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            Object object2 = object;
            if (!(object2 instanceof Spawn)) {
                if (!(object2 instanceof SpawnObject)) {
                    if (!(object2 instanceof NamedSend)) {
                        if (!(object2 instanceof Send)) {
                            if (!(object2 instanceof Link)) {
                                if (!(object2 instanceof UnLink)) {
                                    BoxedUnit boxedUnit;
                                    BoxedUnit boxedUnit2;
                                    if (!(object2 instanceof Exit1)) {
                                        throw new MatchError(object2);
                                    }
                                    Exit1 exit1 = (Exit1)object2;
                                    RemotePid remotePid = exit1.from();
                                    RemotePid remotePid2 = exit1.to();
                                    Symbol symbol = exit1.reason();
                                    if (!this.trapExits().contains(BoxedInt.box(remotePid2.localId()))) {
                                        if (!symbol.name().equals("normal")) {
                                            this.exit(remotePid, remotePid2, symbol);
                                            boxedUnit2 = BoxedUnit.UNIT;
                                        } else {
                                            boxedUnit2 = BoxedUnit.UNIT;
                                        }
                                    } else {
                                        this.localSend(remotePid2, (Object)new Exit1(remotePid, remotePid2, symbol));
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit3 = boxedUnit = boxedUnit2;
                                } else {
                                    BoxedUnit boxedUnit;
                                    UnLink unLink = (UnLink)object2;
                                    RemotePid remotePid = unLink.from();
                                    RemotePid remotePid3 = unLink.to();
                                    this.unlinkFromLocal(remotePid, remotePid3);
                                    BoxedUnit boxedUnit4 = boxedUnit = BoxedUnit.UNIT;
                                }
                            } else {
                                BoxedUnit boxedUnit;
                                Link link = (Link)object2;
                                RemotePid remotePid = link.from();
                                RemotePid remotePid4 = link.to();
                                this.linkFromLocal(remotePid, remotePid4);
                                BoxedUnit boxedUnit5 = boxedUnit = BoxedUnit.UNIT;
                            }
                        } else {
                            BoxedUnit boxedUnit;
                            Send send = (Send)object2;
                            RemotePid remotePid = send.rec();
                            byte[] byArray = send.data();
                            Object object3 = this.service.serializer().deserialize(byArray);
                            this.localSend(remotePid, object3);
                            BoxedUnit boxedUnit6 = boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        BoxedUnit boxedUnit;
                        Option option;
                        NamedSend namedSend = (NamedSend)object2;
                        Symbol symbol = namedSend.sym();
                        byte[] byArray = namedSend.data();
                        Option option2 = option = this.nameTable().get(symbol);
                        None$ none$ = None$.MODULE$;
                        if (option2 != null ? !option2.equals(none$) : none$ != null) {
                            BoxedUnit boxedUnit7;
                            if (!(option instanceof Some)) {
                                throw new MatchError(option);
                            }
                            Some some = (Some)option;
                            int n = ScalaRunTime$.MODULE$.intValue((BoxedNumber)some.x());
                            Object object4 = this.service.serializer().deserialize(byArray);
                            this.localSend(n, object4);
                            BoxedUnit boxedUnit8 = boxedUnit7 = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit9;
                            BoxedUnit boxedUnit10 = boxedUnit9 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit11 = boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    BoxedUnit boxedUnit;
                    BoxedUnit boxedUnit12;
                    SpawnObject spawnObject = (SpawnObject)object2;
                    RemotePid remotePid = spawnObject.replyto();
                    byte[] byArray = spawnObject.data();
                    Object object5 = this.service.serializer().deserialize(byArray);
                    if (!(object5 instanceof RA)) {
                        throw new MatchError(object5);
                    }
                    RA rA = (RA)object5;
                    RemoteActor remoteActor = rA.a();
                    RemotePid remotePid5 = this.register(remoteActor);
                    remoteActor.start();
                    this.remoteSend(remotePid, remotePid5);
                    BoxedUnit boxedUnit13 = boxedUnit12 = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit14 = boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                BoxedUnit boxedUnit;
                Spawn spawn = (Spawn)object2;
                RemotePid remotePid = spawn.replyto();
                String string = spawn.p();
                RemotePid remotePid6 = this.spawn(string);
                this.remoteSend(remotePid, remotePid6);
                BoxedUnit boxedUnit15 = boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void registerName(Symbol symbol, RemoteActor remoteActor) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            RemotePid remotePid = this.register(remoteActor);
            this.registerName(symbol, remotePid);
            remoteActor.start();
            return;
        }
    }

    public void registerName(Symbol symbol, RemotePid remotePid) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            this.nameTable().$plus$eq(symbol).$minus$greater(BoxedInt.box(remotePid.localId()));
            return;
        }
    }

    public HashMap nameTable() {
        return this.nameTable;
    }

    public void namedSend(Name name, Object object) {
        Node node = name.node();
        ScalaObject scalaObject = this.node();
        if (node != null ? !node.equals(scalaObject) : scalaObject != null) {
            byte[] byArray = this.service.serializer().serialize(object);
            this.sendToNode(name.node(), new NamedSend(name.sym(), byArray));
        } else {
            Option option;
            Option option2 = option = this.nameTable().get(name.sym());
            scalaObject = None$.MODULE$;
            if (option2 != null ? !option2.equals(scalaObject) : scalaObject != null) {
                BoxedUnit boxedUnit;
                if (!(option instanceof Some)) {
                    throw new MatchError(option);
                }
                Some some = (Some)option;
                int n = ScalaRunTime$.MODULE$.intValue((BoxedNumber)some.x());
                this.localSend(n, object);
                BoxedUnit boxedUnit2 = boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit3 = boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void remoteSend(RemotePid remotePid, Object object) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            BoxedUnit boxedUnit;
            Object object2;
            Object object3 = object;
            if (!(object3 instanceof Object)) {
                throw new MatchError(object3);
            }
            Object object4 = object2 = object3;
            this.service.remoteSend(remotePid, object4);
            BoxedUnit boxedUnit2 = boxedUnit = BoxedUnit.UNIT;
            return;
        }
    }

    public void localSend(RemotePid remotePid, Object object) {
        this.localSend(remotePid.localId(), object);
    }

    public void localSend(int n, Object object) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            Option option;
            Option option2 = option = this.rtable().get(BoxedInt.box(n));
            None$ none$ = None$.MODULE$;
            if (option2 != null ? !option2.equals(none$) : none$ != null) {
                BoxedUnit boxedUnit;
                if (!(option instanceof Some)) {
                    throw new MatchError(option);
                }
                Some some = (Some)option;
                RemoteActor remoteActor = (RemoteActor)some.x();
                remoteActor.send(object);
                BoxedUnit boxedUnit2 = boxedUnit = BoxedUnit.UNIT;
                return;
            }
            Predef$.MODULE$.error("" + BoxedInt.box(n) + " is not registered at " + this);
            return;
        }
    }

    public RemoteActor getLocalRef(int n) {
        Option option;
        Option option2 = option = this.rtable().get(BoxedInt.box(n));
        None$ none$ = None$.MODULE$;
        if (option2 != null ? !option2.equals(none$) : none$ != null) {
            RemoteActor remoteActor;
            RemoteActor remoteActor2;
            if (!(option instanceof Some)) {
                throw new MatchError(option);
            }
            Some some = (Some)option;
            RemoteActor remoteActor3 = remoteActor2 = (remoteActor = (RemoteActor)some.x());
            return remoteActor3;
        }
        Predef$.MODULE$.error("" + BoxedInt.box(n) + " is not registered at " + this);
        return null;
    }

    public void disconnectNode(Node node) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            this.service.disconnectNode(node);
            return;
        }
    }

    public RemotePid pidOf(RemoteActor remoteActor) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            block5: {
                RemotePid remotePid;
                RemotePid remotePid2;
                Option option;
                Option option2 = option = this.pidTable().get(remoteActor);
                None$ none$ = None$.MODULE$;
                if (!(option2 != null ? !option2.equals(none$) : none$ != null)) break block5;
                if (!(option instanceof Some)) {
                    throw new MatchError(option);
                }
                Some some = (Some)option;
                RemotePid remotePid3 = remotePid2 = (remotePid = (RemotePid)some.x());
                return remotePid3;
            }
            Predef$.MODULE$.error("malformed pid table in " + this);
            return null;
        }
    }

    public List nodes() {
        return this.service.nodes();
    }

    public Node node() {
        return this.service.node();
    }

    public void addConstructor(String string, Function0 function0) {
        this.ptable().update(string, function0);
    }

    public void sendToNode(Node node, Object object) {
        byte[] byArray = this.service.serializer().serialize(object);
        this.service.send(node, byArray);
    }

    public void forwardExc(ExcHandlerDesc excHandlerDesc, Throwable throwable) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        RemotePid remotePid;
        Process process = excHandlerDesc.p();
        if (!(process instanceof RemotePid)) {
            throw new MatchError(process);
        }
        RemotePid remotePid2 = remotePid = (RemotePid)process;
        Node node = remotePid2.node();
        Node node2 = this.node();
        if (node != null ? !node.equals(node2) : node2 != null) {
            this.sendToNode(remotePid2.node(), new ForwardExc(excHandlerDesc, throwable));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            this.handleExc(excHandlerDesc, throwable);
            boxedUnit2 = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit3 = boxedUnit = boxedUnit2;
    }

    public void handleExc(ExcHandlerDesc excHandlerDesc, Throwable throwable) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        RemotePid remotePid;
        Process process = excHandlerDesc.p();
        if (!(process instanceof RemotePid)) {
            throw new MatchError(process);
        }
        RemotePid remotePid2 = remotePid = (RemotePid)process;
        Option option = this.rtable().get(BoxedInt.box(remotePid2.localId()));
        if (!(option instanceof Some)) {
            Option option2 = option;
            None$ none$ = None$.MODULE$;
            if (option2 != null ? !option2.equals(none$) : none$ != null) {
                throw new MatchError(option);
            }
            Predef$.MODULE$.error("exc desc refers to non-registered actor");
            return;
        }
        Some some = (Some)option;
        RemoteActor remoteActor = (RemoteActor)some.x();
        remoteActor.handleExc(excHandlerDesc, throwable);
        BoxedUnit boxedUnit3 = boxedUnit2 = BoxedUnit.UNIT;
        BoxedUnit boxedUnit4 = boxedUnit = BoxedUnit.UNIT;
    }

    public ConsoleHandler consHand() {
        return this.consHand;
    }

    public Logger l() {
        return this.l;
    }

    public Level logLevel() {
        return this.logLevel;
    }

    private void running_$eq(boolean bl) {
        this.running = bl;
    }

    private boolean running() {
        return this.running;
    }

    private HashMap pidTable() {
        return this.pidTable;
    }

    private HashMap rtable() {
        return this.rtable;
    }

    private HashMap ptable() {
        return this.ptable;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

