/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import scala.ScalaObject;

public class SocketConnection
implements ScalaObject {
    private String errorMessage;
    private BufferedReader in;
    private PrintWriter out;
    private Socket socket;
    private int port;
    private String hostname;

    public SocketConnection(String string, int n) {
        this.hostname = string;
        this.port = n;
    }

    public void close() {
        this.in().close();
        this.out().close();
        this.socket().close();
    }

    public boolean open() {
        boolean bl;
        try {
            this.socket_$eq(new Socket(this.hostname, this.port));
            this.out_$eq(new PrintWriter(this.socket().getOutputStream(), true));
            this.in_$eq(new BufferedReader(new InputStreamReader(this.socket().getInputStream())));
            bl = true;
        }
        catch (IOException iOException) {
            this.errorMessage_$eq("Couldn't get I/O for the connection to: " + this.hostname + ".");
            bl = false;
        }
        catch (UnknownHostException unknownHostException) {
            this.errorMessage_$eq("Don't know about host: " + this.hostname + ".");
            bl = false;
        }
        return bl;
    }

    public void errorMessage_$eq(String string) {
        this.errorMessage = string;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public void in_$eq(BufferedReader bufferedReader) {
        this.in = bufferedReader;
    }

    public BufferedReader in() {
        return this.in;
    }

    public void out_$eq(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public PrintWriter out() {
        return this.out;
    }

    private void socket_$eq(Socket socket) {
        this.socket = socket;
    }

    private Socket socket() {
        return this.socket;
    }

    public SocketConnection(int n) {
        this(InetAddress.getLocalHost().getHostName(), n);
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

