/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.distributed;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import scala.Console$;
import scala.Function1;
import scala.List;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.actors.distributed.JavaSerializer;
import scala.actors.distributed.NetKernel;
import scala.actors.distributed.Node;
import scala.actors.distributed.RemoteActor;
import scala.actors.distributed.RemotePid;
import scala.actors.distributed.Serializer;
import scala.actors.distributed.Service;
import scala.actors.distributed.Service$class;
import scala.actors.distributed.TcpNode;
import scala.actors.distributed.TcpPid;
import scala.actors.distributed.TcpServiceWorker;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedBoolean;
import scala.runtime.BoxedInt;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TcpService
extends Thread
implements Service,
ScalaObject {
    private int scala$actors$distributed$Service$$idCnt;
    private NetKernel scala$actors$distributed$Service$$kern;
    private HashMap connections;
    private TcpNode internalNode;
    private JavaSerializer serializer;
    private int port;

    public TcpService(int n) {
        this.port = n;
        Service$class.$init$(this);
        this.serializer = new JavaSerializer(this);
        this.internalNode = new TcpNode(InetAddress.getLocalHost().getHostAddress(), n);
        this.connections = new HashMap();
    }

    public Serializer serializer() {
        return this.serializer();
    }

    public Node node() {
        return this.node();
    }

    public void nodeDown(TcpNode tcpNode) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            this.kernel().nodeDown(tcpNode);
            this.connections().$minus$eq((Object)tcpNode);
            return;
        }
    }

    public long getRoundTripTimeMillis(Node node) {
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReachable(Node node) {
        if (this.isConnected(node)) return true;
        try {
            this.connect(node);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public void disconnectNode(Node node) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            BoxedUnit boxedUnit;
            Option option;
            TcpNode tcpNode;
            Node node2 = node;
            if (!(node2 instanceof TcpNode)) {
                Node node3 = node2;
                Predef$.MODULE$.error("No TcpNode!!");
                return;
            }
            TcpNode tcpNode2 = tcpNode = (TcpNode)node2;
            Console$.MODULE$.println((Object)("Disconnecting from " + tcpNode2 + " ..."));
            Option option2 = option = this.connections().get((Object)tcpNode2);
            None$ none$ = None$.MODULE$;
            if (option2 != null ? !option2.equals(none$) : none$ != null) {
                BoxedUnit boxedUnit2;
                if (!(option instanceof Some)) {
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                TcpServiceWorker tcpServiceWorker = (TcpServiceWorker)some.x();
                this.connections().$minus$eq((Object)tcpNode2);
                Console$.MODULE$.println((Object)"Halting worker...");
                tcpServiceWorker.halt();
                BoxedUnit boxedUnit3 = boxedUnit2 = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit4;
                Console$.MODULE$.println((Object)("Cannot disconnect from " + tcpNode2 + ". Not connected."));
                BoxedUnit boxedUnit5 = boxedUnit4 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit = BoxedUnit.UNIT;
            return;
        }
    }

    public TcpServiceWorker connect(TcpNode tcpNode) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            Console$.MODULE$.println((Object)("" + this.node() + ": Connecting to node " + tcpNode + " ..."));
            Socket socket = new Socket(tcpNode.address(), tcpNode.port());
            Console$.MODULE$.println((Object)"Connected.");
            TcpServiceWorker tcpServiceWorker = new TcpServiceWorker(this, socket);
            tcpServiceWorker.sendNode();
            tcpServiceWorker.start();
            this.addConnection(tcpNode, tcpServiceWorker);
            return tcpServiceWorker;
        }
    }

    public void connect(Node node) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            BoxedUnit boxedUnit;
            TcpNode tcpNode;
            Node node2 = node;
            if (!(node2 instanceof TcpNode)) {
                throw new MatchError((Object)node2);
            }
            TcpNode tcpNode2 = tcpNode = (TcpNode)node2;
            this.connect(tcpNode2);
            BoxedUnit boxedUnit2 = boxedUnit = BoxedUnit.UNIT;
            return;
        }
    }

    public boolean isConnected(Node node) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            boolean bl;
            Node node2 = node;
            if (!(node2 instanceof TcpNode)) {
                boolean bl2;
                bl = bl2 = false;
            } else {
                boolean bl3;
                TcpNode tcpNode;
                TcpNode tcpNode2 = tcpNode = (TcpNode)node2;
                bl = bl3 = !this.connections().get((Object)tcpNode2).isEmpty();
            }
            return ScalaRunTime$.MODULE$.booleanValue(BoxedBoolean.box((boolean)bl));
        }
    }

    public Option getConnection(TcpNode tcpNode) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            return this.connections().get((Object)tcpNode);
        }
    }

    public void addConnection(TcpNode tcpNode, TcpServiceWorker tcpServiceWorker) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            this.connections().$plus$eq((Object)tcpNode).$minus$greater((Object)tcpServiceWorker);
            return;
        }
    }

    public List nodes() {
        throw new Exception("nodes need to be implemented in TcpService!");
    }

    private HashMap connections() {
        return this.connections;
    }

    public void run() {
        try {
            ServerSocket serverSocket = new ServerSocket(this.port);
            Console$.MODULE$.println((Object)("Tcp Service started: " + this.node()));
            while (true) {
                Socket socket = serverSocket.accept();
                Console$.MODULE$.println((Object)("Received request from " + socket.getInetAddress() + ":" + BoxedInt.box((int)socket.getPort())));
                TcpServiceWorker tcpServiceWorker = new TcpServiceWorker(this, socket);
                tcpServiceWorker.readNode();
                tcpServiceWorker.start();
            }
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void send(Node node, byte[] byArray) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            BoxedUnit boxedUnit;
            Option option;
            TcpNode tcpNode;
            Node node2 = node;
            if (!(node2 instanceof TcpNode)) {
                Node node3 = node2;
                Predef$.MODULE$.error("no TcpNode!");
                return;
            }
            TcpNode tcpNode2 = tcpNode = (TcpNode)node2;
            Option option2 = option = this.getConnection(tcpNode2);
            None$ none$ = None$.MODULE$;
            if (option2 != null ? !option2.equals(none$) : none$ != null) {
                BoxedUnit boxedUnit2;
                if (!(option instanceof Some)) {
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                TcpServiceWorker tcpServiceWorker = (TcpServiceWorker)some.x();
                tcpServiceWorker.transmit(byArray);
                BoxedUnit boxedUnit3 = boxedUnit2 = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit4;
                Console$.MODULE$.println((Object)"We are not connected, yet.");
                TcpServiceWorker tcpServiceWorker = this.connect(tcpNode2);
                tcpServiceWorker.transmit(byArray);
                BoxedUnit boxedUnit5 = boxedUnit4 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit = BoxedUnit.UNIT;
            return;
        }
    }

    public void send(Node node, String string) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            BoxedUnit boxedUnit;
            Option option;
            TcpNode tcpNode;
            Node node2 = node;
            if (!(node2 instanceof TcpNode)) {
                Node node3 = node2;
                Predef$.MODULE$.error("no TcpNode!");
                return;
            }
            TcpNode tcpNode2 = tcpNode = (TcpNode)node2;
            Option option2 = option = this.getConnection(tcpNode2);
            None$ none$ = None$.MODULE$;
            if (option2 != null ? !option2.equals(none$) : none$ != null) {
                BoxedUnit boxedUnit2;
                if (!(option instanceof Some)) {
                    throw new MatchError((Object)option);
                }
                Some some = (Some)option;
                TcpServiceWorker tcpServiceWorker = (TcpServiceWorker)some.x();
                tcpServiceWorker.transmit(string);
                BoxedUnit boxedUnit3 = boxedUnit2 = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit4;
                Console$.MODULE$.println((Object)"We are not connected, yet.");
                TcpServiceWorker tcpServiceWorker = this.connect(tcpNode2);
                tcpServiceWorker.transmit(string);
                BoxedUnit boxedUnit5 = boxedUnit4 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit = BoxedUnit.UNIT;
            return;
        }
    }

    public RemotePid createPid(RemoteActor remoteActor) {
        return new TcpPid(this.internalNode(), this.makeUid(), this.kernel(), remoteActor);
    }

    public TcpNode node() {
        return this.internalNode();
    }

    private TcpNode internalNode() {
        return this.internalNode;
    }

    public JavaSerializer serializer() {
        return this.serializer;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }

    public final void scala$actors$distributed$Service$$kern_$eq(NetKernel netKernel) {
        this.scala$actors$distributed$Service$$kern = netKernel;
    }

    public final void scala$actors$distributed$Service$$idCnt_$eq(int n) {
        this.scala$actors$distributed$Service$$idCnt = n;
    }

    public final int scala$actors$distributed$Service$$idCnt() {
        return this.scala$actors$distributed$Service$$idCnt;
    }

    public final NetKernel scala$actors$distributed$Service$$kern() {
        return this.scala$actors$distributed$Service$$kern;
    }

    public int makeUid() {
        return Service$class.makeUid(this);
    }

    public void remoteSend(RemotePid remotePid, Object object) {
        Service$class.remoteSend(this, remotePid, object);
    }

    public void send(RemotePid remotePid, Object object) {
        Service$class.send(this, remotePid, object);
    }

    public RemotePid spawn(RemoteActor remoteActor) {
        return Service$class.spawn((Service)this, remoteActor);
    }

    public RemotePid spawn(Function1 function1) {
        return Service$class.spawn((Service)this, function1);
    }

    public RemotePid spawn(String string, RemotePid remotePid) {
        return Service$class.spawn(this, string, remotePid);
    }

    public RemotePid spawn(String string) {
        return Service$class.spawn((Service)this, string);
    }

    public NetKernel kernel() {
        return Service$class.kernel(this);
    }
}

