/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.distributed;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import scala.Function1;
import scala.ScalaObject;
import scala.actors.distributed.Service;
import scala.io.BytePickle;

public abstract class Serializer
implements ScalaObject {
    private Service s;

    public Serializer(Service service) {
        this.s = service;
    }

    public abstract void addRep(String var1, Function1 var2);

    public Service service() {
        return this.s;
    }

    public abstract BytePickle.SPU pid();

    public void writeObject(DataOutputStream dataOutputStream, Object object) {
        byte[] byArray = this.serialize(object);
        this.writeBytes(dataOutputStream, byArray);
    }

    public void writeBytes(DataOutputStream dataOutputStream, byte[] byArray) {
        int n = byArray.length;
        dataOutputStream.writeInt(n);
        dataOutputStream.write(byArray, 0, n);
        dataOutputStream.flush();
    }

    public Object readObject(DataInputStream dataInputStream) {
        byte[] byArray = this.readBytes(dataInputStream);
        return this.deserialize(byArray);
    }

    public byte[] readBytes(DataInputStream dataInputStream) {
        try {
            int n = dataInputStream.readInt();
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray, 0, n);
            return byArray;
        }
        catch (NullPointerException nullPointerException) {
            throw new EOFException("Connection closed.");
        }
    }

    public abstract Object deserialize(byte[] var1);

    public abstract byte[] serialize(Object var1);

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

