/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.runtime.BoxedInt;
import scala.tools.nsc.CompileSocket$$anonfun$0;

public final class CompileSocket$
implements ScalaObject {
    public static final CompileSocket$ MODULE$;
    private int sleepTime;
    private int MaxAttempts;
    private File tmpDir;
    private String serverClass = "scala.tools.nsc.CompileServer";
    private String vmCommand = "java";
    private String dirName = "scalac-compile-server-port";

    static {
        CompileSocket$ compileSocket$ = new CompileSocket$();
    }

    public CompileSocket$() {
        MODULE$ = this;
        File file = new File(System.getProperty("java.io.tmpdir"), this.dirName());
        if (!file.isDirectory() && !file.mkdir()) {
            System.err.println("cannot create directory " + this.dirName() + "; exiting");
            Predef$.MODULE$.exit(1);
            return;
        }
        this.tmpDir = file;
        this.MaxAttempts = 100;
        this.sleepTime = 20;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Socket getsock$0(int n, String string) {
        while (true) {
            if (n == 0) {
                System.err.println("unable to establish connection to server; exiting");
                Predef$.MODULE$.exit(1);
                return null;
            }
            int n2 = this.getPort(string);
            String string2 = InetAddress.getLocalHost().getHostName();
            try {
                return new Socket(string2, n2);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                System.err.println("...connection attempt to server at port " + BoxedInt.box((int)n2) + " failed; re-trying...");
                --n;
                continue;
            }
            break;
        }
    }

    public Socket getSocket(String string, int n) {
        try {
            return new Socket(string, n);
        }
        catch (IOException iOException) {
            System.err.println("unable to establish connection to server " + string + ":" + BoxedInt.box((int)n) + "; exiting");
            Predef$.MODULE$.exit(1);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Socket getSocket(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            System.err.println("malformed server address: " + string + "; exiting");
            Predef$.MODULE$.exit(1);
            return null;
        }
        String string2 = string.substring(0, n);
        try {
            int n2 = Integer.parseInt(string.substring(n + 1));
            return this.getSocket(string2, n2);
        }
        catch (Throwable throwable) {
            System.err.println("malformed server address: " + string + "; exiting");
            Predef$.MODULE$.exit(1);
            return null;
        }
    }

    public Socket getOrCreateSocket(String string) {
        return this.getsock$0(3, string);
    }

    public void deletePort(int n) {
        this.portFile(n).delete();
    }

    public void setPort(int n) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.portFile(n));
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println("cannot create file: " + this.portFile(n).getAbsolutePath() + "; exiting");
            throw new Error();
        }
    }

    public int getPort(String string) {
        int n = 0;
        int n2 = this.pollPort();
        if (n2 < 0) {
            Runtime.getRuntime().exec(this.serverCommand(string));
        }
        while (true) {
            if (n2 >= 0 || n >= this.MaxAttempts()) {
                if (n2 >= 0) {
                    return n2;
                }
                System.err.println("cannot start server with command");
                System.err.println(this.serverCommand(string));
                Predef$.MODULE$.exit(1);
                return 0;
            }
            ++n;
            Thread.sleep(Predef$.MODULE$.int2long(this.sleepTime()));
            n2 = this.pollPort();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int pollPort() {
        int n;
        File[] fileArray = this.tmpDir().listFiles();
        if (fileArray.length == 0) return -1;
        try {
            Predef$.MODULE$.intWrapper(1).until(fileArray.length).foreach((Function1)new CompileSocket$$anonfun$0(fileArray));
            n = Integer.parseInt(fileArray[0].getName());
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
            System.err.println("bad file in temp directory: " + fileArray[0].getAbsolutePath());
            System.err.println("please remove the file and try again");
            Predef$.MODULE$.exit(1);
            return 0;
        }
        return n;
    }

    public File portFile(int n) {
        return new File(this.tmpDir(), BoxedInt.box((int)n).toString());
    }

    public String serverCommand(String string) {
        return this.vmCommand() + string + " " + this.serverClass();
    }

    private int sleepTime() {
        return this.sleepTime;
    }

    private int MaxAttempts() {
        return this.MaxAttempts;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private String serverClass() {
        return this.serverClass;
    }

    private String vmCommand() {
        return this.vmCommand;
    }

    private String dirName() {
        return this.dirName;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

