@echo off

rem ##########################################################################
rem # Copyright copyright 2002-2006 LAMP EPFL
rem #
rem # This is free software; see the distribution for copying conditions.
rem # There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A
rem # PARTICULAR PURPOSE.
rem ##########################################################################

rem We adopt the following conventions:
rem - System/user environment variables start with a letter
rem - Local batch variables start with an underscore ('_')

if "%OS%"=="Windows_NT" (
  @setlocal
  call :set_home
) else (
  set _SCALA_HOME=%SCALA_HOME%
  if "%_SCALA_HOME%"=="" goto error1
)

rem We use the value of the JAVACMD environment variable if defined
set _JAVACMD=%JAVACMD%
if "%_JAVACMD%"=="" set _JAVACMD=java

set _EXTENSION_CLASSPATH=
if "%_EXTENSION_CLASSPATH%"=="" (
  for %%f in ("%_SCALA_HOME%\lib\*") do call :add_cpath "%%f"
)

set _BOOT_CLASSPATH=
if "%_BOOT_CLASSPATH%"=="" (
  if exist "%_SCALA_HOME%\lib\scala-library.jar" (
    set _BOOT_CLASSPATH=%_SCALA_HOME%\lib\scala-library.jar
  )
  if exist "%_SCALA_HOME%\lib\library" (
    set _BOOT_CLASSPATH=%_SCALA_HOME%\lib\library
  )
)

rem We use the value of the CLASSPATH environment variable if defined
set _USER_CLASSPATH=%CLASSPATH%
if "%_USER_CLASSPATH%"=="" set _USER_CLASSPATH=.

set _ARGS=
:loop
rem Argument %1 may contain quotes so we use parentheses here
if (%1)==() goto exec
if (%1)==(-classpath) goto cpath
if (%1)==(-cp) goto cpath
if (%1)==(-version) goto version
set _ARGS=%_ARGS% %1
shift
goto loop

:cpath
shift
if (%1)==() goto help
set _USER_CLASSPATH=%1
shift
goto :loop

:exec
if not "%_EXTENSION_CLASSPATH%"=="" set _MYCLASSPATH=%_USER_CLASSPATH%;%_EXTENSION_CLASSPATH%
if not "%_BOOT_CLASSPATH%"=="" set _MYCLASSPATH=%_BOOT_CLASSPATH%;%_MYCLASSPATH%

rem Variable _USER_CLASSPATH is set to CLASSPATH, %1 or . and DO NOT need to be quoted
set _PROPS=-Dscala.home="%_SCALA_HOME%" 

rem echo %_JAVACMD% -Xmx256M -Xms16M %_PROPS% -cp %_MYCLASSPATH% %_ARGS%
%_JAVACMD% -Xmx256M -Xms16M %_PROPS% -cp %_MYCLASSPATH% %_ARGS%
goto end

:version
echo Scala runtime version 2.1.5 -- copyright 2002-2006 LAMP EPFL
%_JAVACMD% -version
goto end

:help
echo Scala runtime version 2.1.5 -- copyright 2002-2006 LAMP EPFL
%_JAVACMD% -help
goto end

rem ##########################################################################
rem # subroutines

:add_cpath
  if "%_EXTENSION_CLASSPATH%"=="" (
    set _EXTENSION_CLASSPATH=%~1
  ) else (
    set _EXTENSION_CLASSPATH=%_EXTENSION_CLASSPATH%;%~1
  )
goto :eof

rem Variable "%~dps0" works on WinXP SP2 or newer
rem (see http://support.microsoft.com/?kbid=833431)
rem set _SCALA_HOME=%~dps0..
:set_home
  set _BIN_DIR=
  for %%i in (%~sf0) do set _BIN_DIR=%_BIN_DIR%%%~dpsi
  set _SCALA_HOME=%_BIN_DIR%..
goto :eof

rem ##########################################################################
rem # errors

:error1
echo ERROR: environment variable SCALA_HOME is undefined. It should point to your installation directory.
goto end

:end
if "%OS%"=="Windows_NT" @endlocal
