/*                     __                                               *\
**     ________ ___   / /  ___     Scala API                            **
**    / __/ __// _ | / /  / _ |    (c) 2003-2006, LAMP/EPFL             **
**  __\ \/ /__/ __ |/ /__/ __ |                                         **
** /____/\___/_/ |_/____/_/ | |                                         **
**                          |/                                          **
\*                                                                      */

// $Id: EntityRef.scala 5889 2006-03-05 00:33:02Z mihaylov $


package scala.xml;


/** an XML node for entity references
 *
 * @author buraq
 * @param text the text contained in this node
 **/

case class EntityRef(entityName: String) extends SpecialNode {

  final override def typeTag$:Int = -5;

  /** structural equality */
  override def equals(x: Any): Boolean = x match {
    case EntityRef(x) => x.equals(entityName);
    case _ => false
  }

  /** the constant "#ENTITY"
  */
  def label    = "#ENTITY";

  override def hashCode() = entityName.hashCode();

  override def text = "";

  /** appends "&amp; entityName;" to this stringbuffer */
  def toString(sb:StringBuffer) = 
    sb.append("&").append(entityName).append(";");

}
