/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.File;
import java.io.FileInputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import scala.ScalaObject;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.io.SourceReader$;

public class SourceReader
implements ScalaObject {
    private CharBuffer chars;
    private ByteBuffer bytes;
    private CharsetDecoder decoder;

    public SourceReader(CharsetDecoder charsetDecoder) {
        this.decoder = charsetDecoder;
        this.bytes = ByteBuffer.allocate(16384);
        this.chars = CharBuffer.allocate(16384);
    }

    private char[] terminate(CharBuffer charBuffer) {
        char[] cArray = new char[charBuffer.length()];
        charBuffer.get(cArray);
        this.chars_$eq(charBuffer);
        return cArray;
    }

    public char[] read(ReadableByteChannel readableByteChannel) {
        CharsetDecoder charsetDecoder = this.decoder.reset();
        ByteBuffer byteBuffer = this.bytes();
        ((Buffer)byteBuffer).clear();
        CharBuffer charBuffer = this.chars();
        ((Buffer)charBuffer).clear();
        boolean bl = false;
        while (!bl) {
            bl = readableByteChannel.read(byteBuffer) < 0;
            ((Buffer)byteBuffer).flip();
            charBuffer = SourceReader$.MODULE$.decode(charsetDecoder, byteBuffer, charBuffer, bl);
        }
        return this.terminate(SourceReader$.MODULE$.flush(charsetDecoder, charBuffer));
    }

    public char[] read(AbstractFile abstractFile) {
        CharsetDecoder charsetDecoder = this.decoder.reset();
        ByteBuffer byteBuffer = ByteBuffer.wrap(abstractFile.read());
        CharBuffer charBuffer = this.chars();
        ((Buffer)charBuffer).clear();
        return this.terminate(SourceReader$.MODULE$.flush(charsetDecoder, SourceReader$.MODULE$.decode(charsetDecoder, byteBuffer, charBuffer, true)));
    }

    public char[] read(File file) {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        try {
            char[] cArray = this.read(fileChannel);
            fileChannel.close();
            return cArray;
        }
        catch (Throwable throwable) {
            fileChannel.close();
            throw throwable;
        }
    }

    public char[] read(String string) {
        return this.read(new File(string));
    }

    private void chars_$eq(CharBuffer charBuffer) {
        this.chars = charBuffer;
    }

    private CharBuffer chars() {
        return this.chars;
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

