/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.parsing;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import scala.List;
import scala.List$;
import scala.Nil$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.collection.mutable.Stack;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.parsing.FactoryAdapter$$anonfun$0;

public abstract class FactoryAdapter
extends DefaultHandler
implements ScalaObject {
    private Node rootElem = null;
    private boolean normalizeWhitespace = false;
    private boolean capture = false;
    private String curTag = null;
    private Stack scopeStack;
    private Stack tagStack;
    private Stack hStack;
    private Stack attribStack;
    private StringBuffer buffer = new StringBuffer();

    public FactoryAdapter() {
        this.attribStack = new Stack();
        this.hStack = new Stack();
        this.tagStack = new Stack();
        this.scopeStack = new Stack();
    }

    public Node load(String string) {
        return this.loadXML(new InputSource(string));
    }

    public Node load(Reader reader) {
        return this.loadXML(new InputSource(reader));
    }

    public Node load(InputStream inputStream) {
        return this.loadXML(new InputSource(inputStream));
    }

    public Node loadFile(String string) {
        return this.loadXML(new InputSource(new FileInputStream(string)));
    }

    public Node loadFile(FileDescriptor fileDescriptor) {
        return this.loadXML(new InputSource(new FileInputStream(fileDescriptor)));
    }

    public Node loadFile(File file) {
        return this.loadXML(new InputSource(new FileInputStream(file)));
    }

    public Node loadXML(InputSource inputSource) {
        Object object;
        SAXParser sAXParser = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(false);
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (Exception exception) {
            System.err.println("error: Unable to instantiate parser");
            System.exit(-1);
        }
        try {
            this.scopeStack().push(new BoxedObjectArray(new NamespaceBinding[]{TopScope$.MODULE$}));
            sAXParser.parse(inputSource, (DefaultHandler)this);
            object = this.scopeStack().pop();
        }
        catch (Exception exception) {
            System.err.println("error: Parse error occurred - " + exception.getMessage());
            if (!(exception instanceof SAXException)) {
                exception.printStackTrace(System.err);
            } else {
                ((SAXException)exception).getException().printStackTrace(System.err);
            }
            object = BoxedUnit.UNIT;
        }
        catch (SAXParseException sAXParseException) {
            object = BoxedUnit.UNIT;
        }
        return this.rootElem();
    }

    public void rootElem_$eq(Node node) {
        this.rootElem = node;
    }

    public Node rootElem() {
        return this.rootElem;
    }

    public void printError(String string, SAXParseException sAXParseException) {
        int n;
        String string2;
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string3 = string2 = sAXParseException.getSystemId();
        Object var4_4 = null;
        if ((string3 != null ? !string3.equals(var4_4) : var4_4 != null) && (n = string2.lastIndexOf(47)) != -1) {
            string2 = string2.substring(n + 1);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.printError("Fatal Error", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) {
        this.printError("Error", sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
    }

    public void endElement(String string, String string2, String string3) {
        Object var7_7;
        this.captureText();
        MetaData metaData = (MetaData)this.attribStack().pop();
        List list = Nil$.MODULE$;
        Node node = (Node)this.hStack().pop();
        while (true) {
            Node node2 = node;
            var7_7 = null;
            if (!(node2 != null ? !((Object)node2).equals(var7_7) : var7_7 != null)) break;
            Node node3 = node;
            list = list.$colon$colon(node3);
            node = (Node)this.hStack().pop();
        }
        int n = string3.indexOf(58);
        String string4 = -1 != n ? string3.substring(n + 1, string3.length()) : string3;
        NamespaceBinding namespaceBinding = (NamespaceBinding)this.scopeStack().pop();
        this.rootElem_$eq(-1 != n ? this.createNode(string3.substring(0, n), string4, metaData, namespaceBinding, list) : this.createNode(null, string4, metaData, namespaceBinding, list));
        this.hStack().push(new BoxedObjectArray(new Node[]{this.rootElem()}));
        this.curTag_$eq((String)this.tagStack().pop());
        String string5 = this.curTag();
        var7_7 = null;
        if (string5 != null ? !string5.equals(var7_7) : var7_7 != null) {
            this.capture_$eq(this.nodeContainsText(this.curTag()));
        } else {
            this.capture_$eq(false);
        }
    }

    public void captureText() {
        String string;
        if (this.capture() && (string = this.buffer().toString()).length() > 0 && !string.equals(" ")) {
            this.hStack().push(new BoxedObjectArray(new Node[]{this.createText(string)}));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.buffer().setLength(0);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.captureText();
        this.tagStack().push(new BoxedObjectArray(new String[]{this.curTag()}));
        this.curTag_$eq(string3);
        int n = string3.indexOf(58);
        String string4 = -1 != n ? string3.substring(n + 1, string3.length()) : string3;
        this.capture_$eq(this.nodeContainsText(string4));
        Node[] nodeArray = new Node[1];
        nodeArray[0] = null;
        this.hStack().push(new BoxedObjectArray(nodeArray));
        ObjectRef objectRef = new ObjectRef(Null$.MODULE$);
        ObjectRef objectRef2 = new ObjectRef((NamespaceBinding)this.scopeStack().top());
        List$.MODULE$.range(0, attributes.getLength()).foreach(new FactoryAdapter$$anonfun$0(this, attributes, objectRef, objectRef2));
        this.scopeStack().push(new BoxedObjectArray(new NamespaceBinding[]{(NamespaceBinding)objectRef2.elem}));
        this.attribStack().push(new BoxedObjectArray(new MetaData[]{(MetaData)objectRef.elem}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void characters(char[] cArray, int n, int n2) {
        if (!this.capture()) return;
        if (!this.normalizeWhitespace()) {
            this.buffer().append(cArray, n, n2);
            return;
        }
        int n3 = n;
        boolean bl = false;
        while (n3 < n + n2) {
            if (!Character.isWhitespace(cArray[n3])) {
                this.buffer().append(cArray[n3]);
                bl = false;
            } else if (!bl) {
                this.buffer().append(' ');
                bl = true;
            }
            ++n3;
        }
        return;
    }

    public boolean normalizeWhitespace() {
        return this.normalizeWhitespace;
    }

    public abstract Text createText(String var1);

    public abstract Node createNode(String var1, String var2, MetaData var3, NamespaceBinding var4, List var5);

    public abstract boolean nodeContainsText(String var1);

    public void capture_$eq(boolean bl) {
        this.capture = bl;
    }

    public boolean capture() {
        return this.capture;
    }

    public void curTag_$eq(String string) {
        this.curTag = string;
    }

    public String curTag() {
        return this.curTag;
    }

    public void scopeStack_$eq(Stack stack) {
        this.scopeStack = stack;
    }

    public Stack scopeStack() {
        return this.scopeStack;
    }

    public Stack tagStack() {
        return this.tagStack;
    }

    public Stack hStack() {
        return this.hStack;
    }

    public Stack attribStack() {
        return this.attribStack;
    }

    public StringBuffer buffer() {
        return this.buffer;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

